/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.extensions.spring.test.context;

import java.util.Optional;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.NonNull;
import org.springframework.test.context.TestContext;
import org.springframework.util.Assert;

public class TestContextApplicationEventPublisherAdapter
implements ApplicationEventPublisher {
    private final TestContext testContext;

    @NonNull
    protected static TestContextApplicationEventPublisherAdapter from(@NonNull TestContext testContext) {
        return new TestContextApplicationEventPublisherAdapter(testContext);
    }

    protected TestContextApplicationEventPublisherAdapter(@NonNull TestContext testContext) {
        Assert.notNull((Object)testContext, (String)"TestContext must not be null");
        this.testContext = testContext;
    }

    @NonNull
    protected TestContext getTestContext() {
        return this.testContext;
    }

    protected Optional<ApplicationEventPublisher> getApplicationEventPublisher() {
        return Optional.ofNullable(this.getTestContext()).filter(TestContext::hasApplicationContext).map(TestContext::getApplicationContext);
    }

    public void publishEvent(@NonNull Object event) {
        this.getApplicationEventPublisher().ifPresent(applicationEventPublisher -> applicationEventPublisher.publishEvent(event));
    }
}

