/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.tests.extensions.spring.context.annotation;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import org.apache.shiro.util.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.gemfire.tests.extensions.spring.context.annotation.DependencyOf;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class DependencyOfBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    protected static final Class<? extends Annotation> DEPENDENCY_OF_TYPE = DependencyOf.class;
    protected static final String VALUE_ATTRIBUTE_NAME = "value";

    public void postProcessBeanFactory(@NonNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] dependencyOfAnnotatedBeanNames;
        for (String beanName : dependencyOfAnnotatedBeanNames = (String[])ArrayUtils.nullSafeArray((Object[])beanFactory.getBeanNamesForAnnotation(DEPENDENCY_OF_TYPE), String.class)) {
            Annotation dependencyOf = beanFactory.findAnnotationOnBean(beanName, DEPENDENCY_OF_TYPE);
            Optional.ofNullable(dependencyOf).map(this::getAnnotationAttributes).map(this::getValueAttribute).ifPresent(dependentBeanNames -> {
                for (String dependentBeanName : dependentBeanNames) {
                    Optional.ofNullable(dependentBeanName).filter(StringUtils::hasText).map(arg_0 -> ((ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(arg_0)).ifPresent(dependentBeanDefinition -> SpringUtils.addDependsOn((BeanDefinition)dependentBeanDefinition, (String[])new String[]{beanName}));
                }
            });
        }
    }

    @Nullable
    private AnnotationAttributes getAnnotationAttributes(@NonNull Annotation annotation) {
        return annotation != null ? AnnotationAttributes.fromMap((Map)AnnotationUtils.getAnnotationAttributes((Annotation)annotation)) : null;
    }

    @Nullable
    private String[] getValueAttribute(@NonNull AnnotationAttributes annotationAttributes) {
        return annotationAttributes != null ? annotationAttributes.getStringArray(VALUE_ATTRIBUTE_NAME) : null;
    }
}

