/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.rest_client.RestClientOptions;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.springframework.context.annotation.Bean;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchClients;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClient;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchTemplate;
import org.springframework.data.elasticsearch.config.ElasticsearchConfigurationSupport;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.util.Assert;

public abstract class ReactiveElasticsearchConfiguration
extends ElasticsearchConfigurationSupport {
    @Bean(name={"elasticsearchClientConfiguration"})
    public abstract ClientConfiguration clientConfiguration();

    @Bean
    public RestClient elasticsearchRestClient(ClientConfiguration clientConfiguration) {
        Assert.notNull((Object)clientConfiguration, (String)"clientConfiguration must not be null");
        return ElasticsearchClients.getRestClient(clientConfiguration);
    }

    @Bean
    public ElasticsearchTransport elasticsearchTransport(RestClient restClient, JsonpMapper jsonpMapper) {
        Assert.notNull((Object)restClient, (String)"restClient must not be null");
        Assert.notNull((Object)jsonpMapper, (String)"jsonpMapper must not be null");
        return ElasticsearchClients.getElasticsearchTransport(restClient, "reactive", this.transportOptions(), jsonpMapper);
    }

    @Bean
    public ReactiveElasticsearchClient reactiveElasticsearchClient(ElasticsearchTransport transport) {
        Assert.notNull((Object)transport, (String)"transport must not be null");
        return ElasticsearchClients.createReactive(transport);
    }

    @Bean(name={"reactiveElasticsearchOperations", "reactiveElasticsearchTemplate"})
    public ReactiveElasticsearchOperations reactiveElasticsearchOperations(ElasticsearchConverter elasticsearchConverter, ReactiveElasticsearchClient reactiveElasticsearchClient) {
        ReactiveElasticsearchTemplate template = new ReactiveElasticsearchTemplate(reactiveElasticsearchClient, elasticsearchConverter);
        template.setRefreshPolicy(this.refreshPolicy());
        return template;
    }

    @Bean
    public JsonpMapper jsonpMapper() {
        return new JacksonJsonpMapper();
    }

    public TransportOptions transportOptions() {
        return new RestClientOptions(RequestOptions.DEFAULT).toBuilder().build();
    }
}

