/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.geo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.elasticsearch.core.geo.GeoJson;
import org.springframework.data.elasticsearch.core.geo.GeoJsonPolygon;
import org.springframework.util.Assert;

public class GeoJsonMultiPolygon
implements GeoJson<Iterable<GeoJsonPolygon>> {
    public static final String TYPE = "MultiPolygon";
    private List<GeoJsonPolygon> coordinates = new ArrayList<GeoJsonPolygon>();

    private GeoJsonMultiPolygon(List<GeoJsonPolygon> polygons) {
        this.coordinates.addAll(polygons);
    }

    public static GeoJsonMultiPolygon of(List<GeoJsonPolygon> polygons) {
        Assert.notNull(polygons, (String)"Polygons for MultiPolygon must not be null!");
        return new GeoJsonMultiPolygon(polygons);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public List<GeoJsonPolygon> getCoordinates() {
        return Collections.unmodifiableList(this.coordinates);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoJsonMultiPolygon that = (GeoJsonMultiPolygon)o;
        return this.coordinates.equals(that.coordinates);
    }

    public int hashCode() {
        return this.coordinates.hashCode();
    }

    public String toString() {
        return "GeoJsonMultiPolygon{coordinates=" + this.coordinates + "}";
    }
}

