/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.elasticsearch.client.RestClientBuilder;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.support.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.function.client.WebClient;

class DefaultClientConfiguration
implements ClientConfiguration {
    private final List<InetSocketAddress> hosts;
    private final HttpHeaders headers;
    private final boolean useSsl;
    @Nullable
    private final SSLContext sslContext;
    private final Duration soTimeout;
    private final Duration connectTimeout;
    @Nullable
    private final String pathPrefix;
    @Nullable
    private final HostnameVerifier hostnameVerifier;
    @Nullable
    private final String proxy;
    private final Function<WebClient, WebClient> webClientConfigurer;
    private final RestClientBuilder.HttpClientConfigCallback httpClientConfigurer;
    private final Supplier<HttpHeaders> headersSupplier;
    private final List<ClientConfiguration.ClientConfigurationCallback<?>> clientConfigurers;

    DefaultClientConfiguration(List<InetSocketAddress> hosts, HttpHeaders headers, boolean useSsl, @Nullable SSLContext sslContext, Duration soTimeout, Duration connectTimeout, @Nullable String pathPrefix, @Nullable HostnameVerifier hostnameVerifier, @Nullable String proxy, Function<WebClient, WebClient> webClientConfigurer, RestClientBuilder.HttpClientConfigCallback httpClientConfigurer, List<ClientConfiguration.ClientConfigurationCallback<?>> clientConfigurers, Supplier<HttpHeaders> headersSupplier) {
        this.hosts = List.copyOf(hosts);
        this.headers = headers;
        this.useSsl = useSsl;
        this.sslContext = sslContext;
        this.soTimeout = soTimeout;
        this.connectTimeout = connectTimeout;
        this.pathPrefix = pathPrefix;
        this.hostnameVerifier = hostnameVerifier;
        this.proxy = proxy;
        this.webClientConfigurer = webClientConfigurer;
        this.httpClientConfigurer = httpClientConfigurer;
        this.clientConfigurers = clientConfigurers;
        this.headersSupplier = headersSupplier;
    }

    @Override
    public List<InetSocketAddress> getEndpoints() {
        return this.hosts;
    }

    @Override
    public HttpHeaders getDefaultHeaders() {
        return this.headers;
    }

    @Override
    public boolean useSsl() {
        return this.useSsl;
    }

    @Override
    public Optional<SSLContext> getSslContext() {
        return Optional.ofNullable(this.sslContext);
    }

    @Override
    public Optional<HostnameVerifier> getHostNameVerifier() {
        return Optional.ofNullable(this.hostnameVerifier);
    }

    @Override
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public Duration getSocketTimeout() {
        return this.soTimeout;
    }

    @Override
    @Nullable
    public String getPathPrefix() {
        return this.pathPrefix;
    }

    @Override
    public Optional<String> getProxy() {
        return Optional.ofNullable(this.proxy);
    }

    @Override
    public Function<WebClient, WebClient> getWebClientConfigurer() {
        return this.webClientConfigurer;
    }

    @Override
    public <T> List<ClientConfiguration.ClientConfigurationCallback<?>> getClientConfigurers() {
        return this.clientConfigurers;
    }

    @Override
    public Supplier<HttpHeaders> getHeadersSupplier() {
        return this.headersSupplier;
    }
}

