/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import java.util.Collections;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchHitsImpl;
import org.springframework.data.elasticsearch.core.TotalHitsRelation;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchQueryMethod;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.util.StreamUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractElasticsearchRepositoryQuery
implements RepositoryQuery {
    protected static final int DEFAULT_STREAM_BATCH_SIZE = 500;
    protected ElasticsearchQueryMethod queryMethod;
    protected ElasticsearchOperations elasticsearchOperations;
    protected final ElasticsearchConverter elasticsearchConverter;

    public AbstractElasticsearchRepositoryQuery(ElasticsearchQueryMethod queryMethod, ElasticsearchOperations elasticsearchOperations) {
        this.queryMethod = queryMethod;
        this.elasticsearchOperations = elasticsearchOperations;
        this.elasticsearchConverter = elasticsearchOperations.getElasticsearchConverter();
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    public abstract boolean isCountQuery();

    protected abstract boolean isDeleteQuery();

    protected abstract boolean isExistsQuery();

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor parameterAccessor = this.getParameterAccessor(parameters);
        Class<?> clazz = this.getResultClass();
        Query query = this.createQuery(parameters);
        IndexCoordinates index = this.elasticsearchOperations.getIndexCoordinatesFor(clazz);
        Object result = null;
        if (this.isDeleteQuery()) {
            result = this.countOrGetDocumentsForDelete(query, parameterAccessor);
            this.elasticsearchOperations.delete(query, clazz, index);
            this.elasticsearchOperations.indexOps(index).refresh();
        } else if (this.isCountQuery()) {
            result = this.elasticsearchOperations.count(query, clazz, index);
        } else if (this.isExistsQuery()) {
            result = this.elasticsearchOperations.count(query, clazz, index) > 0L;
        } else if (this.queryMethod.isPageQuery()) {
            query.setPageable(parameterAccessor.getPageable());
            SearchHits<?> searchHits = this.elasticsearchOperations.search(query, clazz, index);
            result = this.queryMethod.isSearchPageMethod() ? SearchHitSupport.searchPageFor(searchHits, query.getPageable()) : SearchHitSupport.unwrapSearchHits(SearchHitSupport.searchPageFor(searchHits, query.getPageable()));
        } else if (this.queryMethod.isStreamQuery()) {
            query.setPageable((Pageable)(parameterAccessor.getPageable().isPaged() ? parameterAccessor.getPageable() : PageRequest.of((int)0, (int)500)));
            result = StreamUtils.createStreamFromIterator(this.elasticsearchOperations.searchForStream(query, clazz, index));
        } else if (this.queryMethod.isCollectionQuery()) {
            if (parameterAccessor.getPageable().isUnpaged()) {
                int itemCount = (int)this.elasticsearchOperations.count(query, clazz, index);
                if (itemCount == 0) {
                    result = new SearchHitsImpl(0L, TotalHitsRelation.EQUAL_TO, Float.NaN, null, Collections.emptyList(), null, null);
                } else {
                    query.setPageable((Pageable)PageRequest.of((int)0, (int)Math.max(1, itemCount)));
                }
            } else {
                query.setPageable(parameterAccessor.getPageable());
            }
            if (result == null) {
                result = this.elasticsearchOperations.search(query, clazz, index);
            }
        } else {
            result = this.elasticsearchOperations.searchOne(query, clazz, index);
        }
        return this.queryMethod.isNotSearchHitMethod() && this.queryMethod.isNotSearchPageMethod() ? SearchHitSupport.unwrapSearchHits(result) : result;
    }

    public Query createQuery(Object[] parameters) {
        Class<?> clazz = this.getResultClass();
        ParametersParameterAccessor parameterAccessor = this.getParameterAccessor(parameters);
        Query query = this.createQuery(parameterAccessor);
        Assert.notNull((Object)query, (String)"unsupported query");
        if (this.queryMethod.hasAnnotatedHighlight()) {
            query.setHighlightQuery(this.queryMethod.getAnnotatedHighlightQuery());
        }
        return query;
    }

    private Class<?> getResultClass() {
        return this.queryMethod.getResultProcessor().getReturnedType().getDomainType();
    }

    private ParametersParameterAccessor getParameterAccessor(Object[] parameters) {
        return new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
    }

    @Nullable
    private Object countOrGetDocumentsForDelete(Query query, ParametersParameterAccessor accessor) {
        Object result = null;
        Class entityClass = this.queryMethod.getEntityInformation().getJavaType();
        IndexCoordinates index = this.elasticsearchOperations.getIndexCoordinatesFor(entityClass);
        if (this.queryMethod.isCollectionQuery()) {
            if (accessor.getPageable().isUnpaged()) {
                int itemCount = (int)this.elasticsearchOperations.count(query, entityClass, index);
                query.setPageable((Pageable)PageRequest.of((int)0, (int)Math.max(1, itemCount)));
            } else {
                query.setPageable(accessor.getPageable());
            }
            result = this.elasticsearchOperations.search(query, entityClass, index);
        }
        if (ClassUtils.isAssignable(Number.class, (Class)this.queryMethod.getReturnedObjectType())) {
            result = this.elasticsearchOperations.count(query, entityClass, index);
        }
        return result;
    }

    protected abstract Query createQuery(ParametersParameterAccessor var1);
}

