/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.document;

import java.util.List;
import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Explanation {
    @Nullable
    private final Boolean match;
    private final Double value;
    @Nullable
    private final String description;
    private final List<Explanation> details;

    public Explanation(@Nullable Boolean match, Double value, @Nullable String description, List<Explanation> details) {
        Assert.notNull((Object)value, (String)"value must not be null");
        Assert.notNull(details, (String)"details must not be null");
        this.match = match;
        this.value = value;
        this.description = description;
        this.details = details;
    }

    public boolean isMatch() {
        return this.match != null && this.match != false;
    }

    public Double getValue() {
        return this.value;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public List<Explanation> getDetails() {
        return this.details;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Explanation that = (Explanation)o;
        if (this.match != that.match) {
            return false;
        }
        if (!this.value.equals(that.value)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        return this.details.equals(that.details);
    }

    public int hashCode() {
        int result = this.match != false ? 1 : 0;
        result = 31 * result + this.value.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + this.details.hashCode();
        return result;
    }

    public String toString() {
        return "Explanation{match=" + this.match + ", value=" + this.value + ", description='" + this.description + '\'' + ", details=" + this.details + '}';
    }
}

