/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseOperations;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.query.AbstractReactiveCouchbaseQuery;
import org.springframework.data.couchbase.repository.query.ReactiveCouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.StringN1qlQueryCreator;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class ReactiveStringBasedCouchbaseQuery
extends AbstractReactiveCouchbaseQuery {
    private static final String COUNT_EXISTS_AND_DELETE = "Manually defined query for %s cannot be a count and exists or delete query at the same time!";
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveStringBasedCouchbaseQuery.class);
    private final SpelExpressionParser expressionParser;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final NamedQueries namedQueries;

    public ReactiveStringBasedCouchbaseQuery(ReactiveCouchbaseQueryMethod method, ReactiveCouchbaseOperations couchbaseOperations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider, NamedQueries namedQueries) {
        super(method, couchbaseOperations, expressionParser, evaluationContextProvider);
        Assert.notNull((Object)expressionParser, (String)"SpelExpressionParser must not be null!");
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
        if (ReactiveStringBasedCouchbaseQuery.hasAmbiguousProjectionFlags(this.isCountQuery(), this.isExistsQuery(), this.isDeleteQuery())) {
            throw new IllegalArgumentException(String.format(COUNT_EXISTS_AND_DELETE, new Object[]{method}));
        }
        this.namedQueries = namedQueries;
    }

    @Override
    protected Query createQuery(ParametersParameterAccessor accessor) {
        StringN1qlQueryCreator creator = new StringN1qlQueryCreator((ParameterAccessor)accessor, this.getQueryMethod(), ((ReactiveCouchbaseOperations)this.getOperations()).getConverter(), this.expressionParser, this.evaluationContextProvider, this.namedQueries);
        Query query = creator.createQuery();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created query " + query.export(new int[0][]));
        }
        return query;
    }

    @Override
    protected Query createCountQuery(ParametersParameterAccessor accessor) {
        return this.applyQueryMetaAttributesIfPresent(this.createQuery(accessor), null);
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }
}

