/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.codec.RawJsonTranscoder;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.kv.GetAnyReplicaOptions;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveFindFromReplicasByIdOperation;
import org.springframework.data.couchbase.core.ReactiveTemplateSupport;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveFindFromReplicasByIdOperationSupport
implements ReactiveFindFromReplicasByIdOperation {
    private final ReactiveCouchbaseTemplate template;
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveFindFromReplicasByIdOperationSupport.class);

    ReactiveFindFromReplicasByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveFindFromReplicasByIdOperation.ReactiveFindFromReplicasById<T> findFromReplicasById(Class<T> domainType) {
        return new ReactiveFindFromReplicasByIdSupport<T>(this.template, domainType, domainType, null, null, null, this.template.support());
    }

    static class ReactiveFindFromReplicasByIdSupport<T>
    implements ReactiveFindFromReplicasByIdOperation.ReactiveFindFromReplicasById<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        private final String scope;
        private final String collection;
        private final GetAnyReplicaOptions options;
        private final ReactiveTemplateSupport support;

        ReactiveFindFromReplicasByIdSupport(ReactiveCouchbaseTemplate template, Class<?> domainType, Class<T> returnType, String scope, String collection, GetAnyReplicaOptions options, ReactiveTemplateSupport support) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.support = support;
        }

        @Override
        public Mono<T> any(String id) {
            GetAnyReplicaOptions garOptions;
            GetAnyReplicaOptions getAnyReplicaOptions = garOptions = this.options != null ? this.options : GetAnyReplicaOptions.getAnyReplicaOptions();
            if (garOptions.build().transcoder() == null) {
                garOptions.transcoder((Transcoder)RawJsonTranscoder.INSTANCE);
            }
            PseudoArgs<GetAnyReplicaOptions> pArgs = new PseudoArgs<GetAnyReplicaOptions>(this.template, this.scope, this.collection, garOptions, this.domainType);
            LOG.trace("getAnyReplica {}", pArgs);
            return Mono.just((Object)id).flatMap(docId -> this.template.getCouchbaseClientFactory().withScope(pArgs.getScope()).getCollection(pArgs.getCollection()).reactive().getAnyReplica(docId, (GetAnyReplicaOptions)pArgs.getOptions())).flatMap(result -> this.support.decodeEntity(id, (String)result.contentAs(String.class), result.cas(), this.returnType, pArgs.getScope(), pArgs.getCollection())).onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        @Override
        public Flux<? extends T> any(Collection<String> ids) {
            return Flux.fromIterable(ids).flatMap(this::any);
        }

        @Override
        public ReactiveFindFromReplicasByIdOperation.TerminatingFindFromReplicasById<T> withOptions(GetAnyReplicaOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ReactiveFindFromReplicasByIdSupport<T>(this.template, this.domainType, this.returnType, this.scope, this.collection, options, this.support);
        }

        @Override
        public ReactiveFindFromReplicasByIdOperation.FindFromReplicasByIdWithOptions<T> inCollection(String collection) {
            return new ReactiveFindFromReplicasByIdSupport<T>(this.template, this.domainType, this.returnType, this.scope, collection, this.options, this.support);
        }

        @Override
        public ReactiveFindFromReplicasByIdOperation.FindFromReplicasByIdInCollection<T> inScope(String scope) {
            return new ReactiveFindFromReplicasByIdSupport<T>(this.template, this.domainType, this.returnType, scope, this.collection, this.options, this.support);
        }
    }
}

