/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jspecify.annotations.Nullable;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.annotation.PersistenceCreator;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.util.KotlinReflectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public interface PreferredConstructorDiscoverer {
    public static <T, P extends PersistentProperty<P>> @Nullable PreferredConstructor<T, P> discover(Class<T> type) {
        Assert.notNull(type, (String)"Type must not be null");
        return Discoverers.findDiscoverer(type).discover(TypeInformation.of(type), null);
    }

    public static <T, P extends PersistentProperty<P>> @Nullable PreferredConstructor<T, P> discover(PersistentEntity<T, P> entity) {
        Assert.notNull(entity, (String)"PersistentEntity must not be null");
        return Discoverers.findDiscoverer(entity.getType()).discover(entity.getTypeInformation(), entity);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Discoverers {
        DEFAULT{

            @Override
            <T, P extends PersistentProperty<P>> @Nullable PreferredConstructor<T, P> discover(TypeInformation<T> type, @Nullable PersistentEntity<T, P> entity) {
                Class<T> rawOwningType = type.getType();
                ArrayList candidates = new ArrayList();
                Constructor<?> noArg = null;
                for (Constructor<?> candidate : rawOwningType.getDeclaredConstructors()) {
                    if (candidate.isSynthetic()) continue;
                    if (AnnotationUtils.findAnnotation(candidate, PersistenceCreator.class) != null) {
                        return Discoverers.buildPreferredConstructor(candidate, type, entity);
                    }
                    if (candidate.getParameterCount() == 0) {
                        noArg = candidate;
                        continue;
                    }
                    candidates.add(candidate);
                }
                if (rawOwningType.isRecord() && (candidates.size() > 1 || noArg != null && !candidates.isEmpty())) {
                    return RECORD.discover(type, entity);
                }
                if (noArg != null) {
                    return Discoverers.buildPreferredConstructor(noArg, type, entity);
                }
                if (candidates.size() == 1) {
                    return Discoverers.buildPreferredConstructor((Constructor)candidates.iterator().next(), type, entity);
                }
                return null;
            }
        }
        ,
        RECORD{

            @Override
            <T, P extends PersistentProperty<P>> @Nullable PreferredConstructor<T, P> discover(TypeInformation<T> type, @Nullable PersistentEntity<T, P> entity) {
                Class<T> rawOwningType = type.getType();
                if (!rawOwningType.isRecord()) {
                    return null;
                }
                Class[] paramTypes = (Class[])Arrays.stream(rawOwningType.getRecordComponents()).map(RecordComponent::getType).toArray(Class[]::new);
                Constructor canonicalConstructor = ClassUtils.getConstructorIfAvailable(rawOwningType, (Class[])paramTypes);
                return canonicalConstructor != null ? Discoverers.buildPreferredConstructor(canonicalConstructor, type, entity) : null;
            }
        }
        ,
        KOTLIN{

            @Override
            <T, P extends PersistentProperty<P>> @Nullable PreferredConstructor<T, P> discover(TypeInformation<T> type, @Nullable PersistentEntity<T, P> entity) {
                Class<T> rawOwningType = type.getType();
                Optional<PreferredConstructor> first = Arrays.stream(rawOwningType.getDeclaredConstructors()).filter(it -> it.isSynthetic() && AnnotationUtils.findAnnotation((AnnotatedElement)it, PersistenceCreator.class) != null).map(it -> Discoverers.buildPreferredConstructor(it, type, entity)).findFirst();
                if (first.isPresent()) {
                    return first.get();
                }
                return Arrays.stream(rawOwningType.getDeclaredConstructors()).filter(it -> !it.isSynthetic()).filter(it -> AnnotationUtils.findAnnotation((AnnotatedElement)it, PersistenceCreator.class) != null).map(it -> Discoverers.buildPreferredConstructor(it, type, entity)).findFirst().orElseGet(() -> {
                    KFunction primaryConstructor = KClasses.getPrimaryConstructor((KClass)JvmClassMappingKt.getKotlinClass(type.getType()));
                    if (primaryConstructor == null) {
                        return DEFAULT.discover(type, entity);
                    }
                    Constructor javaConstructor = ReflectJvmMapping.getJavaConstructor((KFunction)primaryConstructor);
                    return javaConstructor != null ? Discoverers.buildPreferredConstructor(javaConstructor, type, entity) : null;
                });
            }
        };

        private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER;

        private static Discoverers findDiscoverer(Class<?> type) {
            if (!KotlinDetector.isKotlinPresent()) {
                return DEFAULT;
            }
            return KotlinReflectionUtils.isSupportedKotlinClass(type) ? KOTLIN : DEFAULT;
        }

        abstract <T, P extends PersistentProperty<P>> @Nullable PreferredConstructor<T, P> discover(TypeInformation<T> var1, @Nullable PersistentEntity<T, P> var2);

        private static <T, P extends PersistentProperty<P>> PreferredConstructor<T, P> buildPreferredConstructor(Constructor<?> constructor, TypeInformation<T> typeInformation, @Nullable PersistentEntity<T, P> entity) {
            if (constructor.getParameterCount() == 0) {
                return new PreferredConstructor(constructor, new Parameter[0]);
            }
            List<TypeInformation<?>> parameterTypes = typeInformation.getParameterTypes(constructor);
            String[] parameterNames = PARAMETER_NAME_DISCOVERER.getParameterNames(constructor);
            Parameter[] parameters = new Parameter[parameterTypes.size()];
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            for (int i = 0; i < parameterTypes.size(); ++i) {
                String name = parameterNames == null || parameterNames.length <= i ? null : parameterNames[i];
                TypeInformation<?> type = parameterTypes.get(i);
                Annotation[] annotations = parameterAnnotations[i];
                parameters[i] = new Parameter(name, type, annotations, entity);
            }
            return new PreferredConstructor(constructor, parameters);
        }

        static {
            PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
        }
    }
}

