/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.List;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Chunk;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;

public class SliceImpl<T>
extends Chunk<T> {
    private static final long serialVersionUID = 867755909294344406L;
    private final boolean hasNext;
    private final Pageable pageable;

    public SliceImpl(List<T> content, Pageable pageable, boolean hasNext) {
        super(content, pageable);
        this.hasNext = hasNext;
        this.pageable = pageable;
    }

    public SliceImpl(List<T> content) {
        this(content, Pageable.unpaged(), false);
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public <U> Slice<U> map(Function<? super T, ? extends U> converter) {
        return new SliceImpl<U>(this.getConvertedContent(converter), this.pageable, this.hasNext);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SliceImpl)) {
            return false;
        }
        SliceImpl that = (SliceImpl)obj;
        return this.hasNext == that.hasNext && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (this.hasNext ? 1 : 0);
    }

    public String toString() {
        String contentType = "UNKNOWN";
        List content = this.getContent();
        if (!content.isEmpty()) {
            contentType = content.get(0).getClass().getName();
        }
        return String.format("Slice %d containing %s instances", this.getNumber(), contentType);
    }
}

