/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.session.lookup;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.cql.session.lookup.SessionFactoryLookup;
import org.springframework.data.cassandra.core.cql.session.lookup.SessionFactoryLookupFailureException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MapSessionFactoryLookup
implements SessionFactoryLookup {
    private final Map<String, SessionFactory> sessionFactories = new ConcurrentHashMap<String, SessionFactory>(4);

    public MapSessionFactoryLookup() {
    }

    public MapSessionFactoryLookup(Map<String, SessionFactory> sessionFactories) {
        this.setSessionFactories(sessionFactories);
    }

    public MapSessionFactoryLookup(String sessionFactoryName, SessionFactory sessionFactory) {
        this.addSessionFactory(sessionFactoryName, sessionFactory);
    }

    public void setSessionFactories(@Nullable Map<String, SessionFactory> sessionFactories) {
        if (sessionFactories != null) {
            this.sessionFactories.putAll(sessionFactories);
        }
    }

    public Map<String, SessionFactory> getSessionFactories() {
        return Collections.unmodifiableMap(this.sessionFactories);
    }

    public void addSessionFactory(String sessionFactoryName, SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactoryName, (String)"SessionFactory name must not be null");
        Assert.notNull((Object)sessionFactory, (String)"SessionFactory must not be null");
        this.sessionFactories.put(sessionFactoryName, sessionFactory);
    }

    @Override
    public SessionFactory getSessionFactory(String sessionFactoryName) throws SessionFactoryLookupFailureException {
        Assert.notNull((Object)sessionFactoryName, (String)"SessionFactory name must not be null");
        SessionFactory sessionFactory = this.sessionFactories.get(sessionFactoryName);
        if (sessionFactory == null) {
            throw new SessionFactoryLookupFailureException(String.format("No SessionFactory with name [%s] registered", sessionFactoryName));
        }
        return sessionFactory;
    }
}

