/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.Environment;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.core.convert.AbstractCassandraConverter;
import org.springframework.data.cassandra.core.convert.CassandraColumnType;
import org.springframework.data.cassandra.core.convert.CassandraConversionContext;
import org.springframework.data.cassandra.core.convert.CassandraCustomConversions;
import org.springframework.data.cassandra.core.convert.CassandraValueProvider;
import org.springframework.data.cassandra.core.convert.ColumnType;
import org.springframework.data.cassandra.core.convert.ColumnTypeResolver;
import org.springframework.data.cassandra.core.convert.DefaultColumnTypeResolver;
import org.springframework.data.cassandra.core.convert.RowReaderPropertyAccessor;
import org.springframework.data.cassandra.core.convert.RowValueProvider;
import org.springframework.data.cassandra.core.convert.TupleValueProvider;
import org.springframework.data.cassandra.core.convert.UdtValueProvider;
import org.springframework.data.cassandra.core.convert.Where;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.BasicMapId;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.Embedded;
import org.springframework.data.cassandra.core.mapping.EmbeddedEntityOperations;
import org.springframework.data.cassandra.core.mapping.MapId;
import org.springframework.data.cassandra.core.mapping.MapIdentifiable;
import org.springframework.data.cassandra.core.mapping.PersistentPropertyTranslator;
import org.springframework.data.cassandra.core.mapping.UserTypeResolver;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.mapping.InstanceCreatorMetadata;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.CachingValueExpressionEvaluatorFactory;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.mapping.model.ValueExpressionParameterValueProvider;
import org.springframework.data.projection.EntityProjection;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.Predicates;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class MappingCassandraConverter
extends AbstractCassandraConverter
implements ApplicationContextAware,
EnvironmentAware,
EnvironmentCapable,
BeanClassLoaderAware {
    private final Log log = LogFactory.getLog(this.getClass());
    private final CassandraMappingContext mappingContext;
    private Supplier<CodecRegistry> codecRegistry;
    @Nullable
    private UserTypeResolver userTypeResolver;
    @Nullable
    private ClassLoader beanClassLoader;
    @Nullable
    private Environment environment;
    private SpELContext spELContext;
    private final DefaultColumnTypeResolver cassandraTypeResolver;
    private final EmbeddedEntityOperations embeddedEntityOperations;
    private final SpelExpressionParser expressionParser = new SpelExpressionParser();
    private final SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory((ExpressionParser)this.expressionParser);
    private final CachingValueExpressionEvaluatorFactory expressionEvaluatorFactory = new CachingValueExpressionEvaluatorFactory((ExpressionParser)this.expressionParser, (EnvironmentCapable)this, o -> this.spELContext.getEvaluationContext(o));

    public MappingCassandraConverter() {
        this(MappingCassandraConverter.newDefaultMappingContext());
    }

    public MappingCassandraConverter(CassandraMappingContext mappingContext) {
        super(MappingCassandraConverter.newConversionService());
        Assert.notNull((Object)((Object)mappingContext), (String)"CassandraMappingContext must not be null");
        UserTypeResolver userTypeResolver = new UserTypeResolver(){

            @Override
            @Nullable
            public UserDefinedType resolveType(CqlIdentifier typeName) {
                return MappingCassandraConverter.this.getUserTypeResolver().resolveType(typeName);
            }

            @Override
            @Nullable
            public UserDefinedType resolveType(CqlIdentifier keyspace, CqlIdentifier typeName) {
                return MappingCassandraConverter.this.getUserTypeResolver().resolveType(keyspace, typeName);
            }
        };
        this.mappingContext = mappingContext;
        this.setCodecRegistry(mappingContext.getCodecRegistry());
        this.setCustomConversions(mappingContext.getCustomConversions());
        this.cassandraTypeResolver = new DefaultColumnTypeResolver((MappingContext<? extends CassandraPersistentEntity<?>, ? extends CassandraPersistentProperty>)mappingContext, userTypeResolver, this::getCodecRegistry, this::getCustomConversions);
        this.embeddedEntityOperations = new EmbeddedEntityOperations((MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty>)mappingContext);
        this.spELContext = new SpELContext((PropertyAccessor)RowReaderPropertyAccessor.INSTANCE);
    }

    protected ConversionContext getConversionContext() {
        return new ConversionContext(this.getCustomConversions(), this::doReadRow, this::doReadTupleValue, this::doReadUdtValue, this::readCollectionOrArray, this::readMap, this::getPotentiallyConvertedSimpleRead);
    }

    private static ConversionService newConversionService() {
        return new DefaultConversionService();
    }

    private static CassandraMappingContext newDefaultMappingContext() {
        CassandraMappingContext mappingContext = new CassandraMappingContext();
        mappingContext.setCustomConversions(new CassandraCustomConversions(Collections.emptyList()));
        mappingContext.afterPropertiesSet();
        return mappingContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.spELContext = new SpELContext(this.spELContext, (BeanFactory)applicationContext);
        this.environment = applicationContext.getEnvironment();
        this.projectionFactory.setBeanFactory((BeanFactory)applicationContext);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = new StandardEnvironment();
        }
        return this.environment;
    }

    public void setSpELContext(SpELContext spELContext) {
        this.spELContext = spELContext;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
        this.projectionFactory.setBeanClassLoader(classLoader);
    }

    private TypeCodec<Object> getCodec(CassandraPersistentProperty property) {
        return this.getCodecRegistry().codecFor(this.cassandraTypeResolver.resolve(property).getDataType());
    }

    @Override
    public ProjectionFactory getProjectionFactory() {
        return this.projectionFactory;
    }

    public void setCodecRegistry(CodecRegistry codecRegistry) {
        Assert.notNull((Object)codecRegistry, (String)"CodecRegistry must not be null");
        this.setCodecRegistry(() -> codecRegistry);
    }

    public void setCodecRegistry(Supplier<CodecRegistry> codecRegistry) {
        Assert.notNull(codecRegistry, (String)"CodecRegistry provider must not be null");
        this.codecRegistry = Lazy.of(codecRegistry);
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        CodecRegistry registry = this.codecRegistry != null ? this.codecRegistry.get() : null;
        return registry != null ? registry : this.getMappingContext().getCodecRegistry();
    }

    public void setUserTypeResolver(UserTypeResolver userTypeResolver) {
        Assert.notNull((Object)userTypeResolver, (String)"UserTypeResolver must not be null");
        this.userTypeResolver = userTypeResolver;
    }

    public UserTypeResolver getUserTypeResolver() {
        return this.userTypeResolver != null ? this.userTypeResolver : this.getMappingContext().getUserTypeResolver();
    }

    @Override
    public CassandraMappingContext getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public ColumnTypeResolver getColumnTypeResolver() {
        return this.cassandraTypeResolver;
    }

    private <S> ConvertingPropertyAccessor<S> newConvertingPropertyAccessor(S source, CassandraPersistentEntity<?> entity) {
        return new ConvertingPropertyAccessor(entity.getPropertyAccessor(source), this.getConversionService());
    }

    private <S> CassandraPersistentEntityParameterValueProvider newParameterValueProvider(ConversionContext context, CassandraPersistentEntity<S> entity, CassandraValueProvider valueProvider) {
        return new CassandraPersistentEntityParameterValueProvider(entity, valueProvider, context, null);
    }

    private <T> Class<T> transformClassToBeanClassLoaderClass(Class<T> entity) {
        try {
            return ClassUtils.forName((String)entity.getName(), (ClassLoader)this.beanClassLoader);
        }
        catch (ClassNotFoundException | LinkageError ignore) {
            return entity;
        }
    }

    @Override
    public <R> R project(EntityProjection<R, ?> projection, Row row) {
        if (!projection.isProjection()) {
            TypeInformation typeToRead = projection.getMappedType().getType().isInterface() ? projection.getDomainType() : projection.getMappedType();
            return this.read(typeToRead.getType(), row);
        }
        ProjectingConversionContext context = new ProjectingConversionContext(this.getCustomConversions(), this::doReadRow, this::doReadTupleValue, this::doReadUdtValue, this::readCollectionOrArray, this::readMap, this::getPotentiallyConvertedSimpleRead, projection);
        return this.doReadProjection(context, new RowValueProvider(row, this.expressionEvaluatorFactory.create((Object)row)), projection);
    }

    private <R> R doReadProjection(ConversionContext context, CassandraValueProvider valueProvider, EntityProjection<R, ?> projection) {
        Object provider;
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(projection.getActualDomainType());
        TypeInformation mappedType = projection.getActualMappedType();
        CassandraPersistentEntity mappedEntity = (CassandraPersistentEntity)this.getMappingContext().getPersistentEntity(mappedType);
        boolean isInterfaceProjection = mappedType.getType().isInterface();
        if (isInterfaceProjection) {
            PersistentPropertyTranslator propertyTranslator = PersistentPropertyTranslator.create(mappedEntity);
            PersistentPropertyAccessor<Map<String, Object>> accessor = PropertyTranslatingPropertyAccessor.create(new MapPersistentPropertyAccessor(), propertyTranslator);
            this.readProperties(context, entity, valueProvider, accessor, Predicates.isTrue());
            return (R)this.projectionFactory.createProjection(mappedType.getType(), accessor.getBean());
        }
        if (mappedEntity == null) {
            throw new MappingException(String.format("No mapping metadata found for %s", mappedType.getType().getName()));
        }
        PersistentPropertyTranslator propertyTranslator = PersistentPropertyTranslator.create(entity, Predicates.negate(CassandraPersistentProperty::hasExplicitColumnName));
        TranslatingCassandraValueProvider valueProviderToUse = new TranslatingCassandraValueProvider(propertyTranslator, valueProvider);
        InstanceCreatorMetadata persistenceCreator = mappedEntity.getInstanceCreatorMetadata();
        if (persistenceCreator != null && persistenceCreator.hasParameters()) {
            ValueExpressionEvaluator evaluator = this.expressionEvaluatorFactory.create(valueProviderToUse.getSource());
            CassandraPersistentEntityParameterValueProvider parameterValueProvider = this.newParameterValueProvider(context, entity, valueProviderToUse);
            provider = new ConverterAwareValueExpressionParameterValueProvider(evaluator, this.getConversionService(), parameterValueProvider, context);
        } else {
            provider = NoOpParameterValueProvider.INSTANCE;
        }
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor((PersistentEntity)mappedEntity);
        Object instance = instantiator.createInstance((PersistentEntity)mappedEntity, (ParameterValueProvider)provider);
        if (mappedEntity.requiresPropertyPopulation()) {
            PersistentPropertyAccessor accessor = mappedEntity.getPropertyAccessor(instance);
            this.readProperties(context, mappedEntity, valueProviderToUse, accessor, MappingCassandraConverter.isConstructorArgument(mappedEntity).negate());
            return (R)accessor.getBean();
        }
        return (R)instance;
    }

    private Object doReadOrProject(ConversionContext context, Row row, TypeInformation<?> typeHint, EntityProjection<?, ?> typeDescriptor) {
        if (typeDescriptor.isProjection()) {
            RowValueProvider valueProvider = new RowValueProvider(row, this.expressionEvaluatorFactory.create((Object)row));
            return this.doReadProjection(context, valueProvider, typeDescriptor);
        }
        return this.doReadRow(context, row, typeHint);
    }

    private Object doReadOrProject(ConversionContext context, UdtValue udtValue, TypeInformation<?> typeHint, EntityProjection<?, ?> typeDescriptor) {
        if (typeDescriptor.isProjection()) {
            UdtValueProvider valueProvider = new UdtValueProvider(udtValue, this.expressionEvaluatorFactory.create((Object)udtValue));
            return this.doReadProjection(context, valueProvider, typeDescriptor);
        }
        return this.doReadUdtValue(context, udtValue, typeHint);
    }

    private Object doReadOrProject(ConversionContext context, TupleValue tupleValue, TypeInformation<?> typeHint, EntityProjection<?, ?> typeDescriptor) {
        if (typeDescriptor.isProjection()) {
            TupleValueProvider valueProvider = new TupleValueProvider(tupleValue, this.expressionEvaluatorFactory.create((Object)tupleValue));
            return this.doReadProjection(context, valueProvider, typeDescriptor);
        }
        return this.doReadTupleValue(context, tupleValue, typeHint);
    }

    public <R> R read(Class<R> type, Object row) {
        if (row instanceof Row) {
            return this.readRow(type, (Row)row);
        }
        throw new MappingException(String.format("Unknown row object [%s]", ObjectUtils.nullSafeClassName((Object)row)));
    }

    public <R> R readRow(Class<R> type, Row row) {
        Class<R> beanClassLoaderClass = this.transformClassToBeanClassLoaderClass(type);
        TypeInformation typeInfo = TypeInformation.of(beanClassLoaderClass);
        return (R)this.doReadRow(this.getConversionContext(), row, typeInfo);
    }

    <S> S doReadRow(ConversionContext context, Row row, TypeInformation<? extends S> typeHint) {
        return this.doReadEntity(context, row, expressionEvaluator -> new RowValueProvider(row, (ValueExpressionEvaluator)expressionEvaluator), typeHint);
    }

    <S> S doReadTupleValue(ConversionContext context, TupleValue tupleValue, TypeInformation<? extends S> typeHint) {
        return this.doReadEntity(context, tupleValue, expressionEvaluator -> new TupleValueProvider(tupleValue, (ValueExpressionEvaluator)expressionEvaluator), typeHint);
    }

    <S> S doReadUdtValue(ConversionContext context, UdtValue udtValue, TypeInformation<? extends S> typeHint) {
        return this.doReadEntity(context, udtValue, expressionEvaluator -> new UdtValueProvider(udtValue, (ValueExpressionEvaluator)expressionEvaluator), typeHint);
    }

    private <S> S doReadEntity(ConversionContext context, Object value, Function<ValueExpressionEvaluator, CassandraValueProvider> valueProviderSupplier, TypeInformation<? extends S> typeHint) {
        ValueExpressionEvaluator expressionEvaluator = this.expressionEvaluatorFactory.create(value);
        CassandraValueProvider valueProvider = valueProviderSupplier.apply(expressionEvaluator);
        return this.doReadEntity(context, valueProvider, typeHint);
    }

    protected <S> S doReadEntity(ConversionContext context, CassandraValueProvider valueProvider, TypeInformation<? extends S> typeHint) {
        Class rawType = typeHint.getType();
        Class<?> rawSourceType = MappingCassandraConverter.getRawSourceType(valueProvider);
        if (rawSourceType.isAssignableFrom(rawType) && rawSourceType.isInstance(valueProvider.getSource())) {
            return (S)valueProvider.getSource();
        }
        if (this.getCustomConversions().hasCustomReadTarget(rawSourceType, rawType) || this.getConversionService().canConvert(rawSourceType, rawType)) {
            return (S)this.getConversionService().convert(valueProvider.getSource(), rawType);
        }
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getMappingContext().getPersistentEntity(typeHint);
        if (entity == null) {
            throw new MappingException(String.format("Expected to read %s into type %s but didn't find a PersistentEntity for the latter", rawSourceType.getSimpleName(), rawType.getName()));
        }
        return this.doReadEntity(context, valueProvider, entity);
    }

    private static Class<?> getRawSourceType(CassandraValueProvider valueProvider) {
        if (valueProvider.getSource() instanceof Row) {
            return Row.class;
        }
        if (valueProvider.getSource() instanceof TupleValue) {
            return TupleValue.class;
        }
        if (valueProvider.getSource() instanceof UdtValue) {
            return UdtValue.class;
        }
        throw new InvalidDataAccessApiUsageException(String.format("Unsupported source type: %s", ClassUtils.getDescriptiveType((Object)valueProvider.getSource())));
    }

    private <S> S doReadEntity(ConversionContext context, CassandraValueProvider valueProvider, CassandraPersistentEntity<S> entity) {
        Object provider;
        InstanceCreatorMetadata persistenceCreator = entity.getInstanceCreatorMetadata();
        if (persistenceCreator != null && persistenceCreator.hasParameters()) {
            ValueExpressionEvaluator evaluator = this.expressionEvaluatorFactory.create(valueProvider.getSource());
            CassandraPersistentEntityParameterValueProvider parameterValueProvider = this.newParameterValueProvider(context, entity, valueProvider);
            provider = new ConverterAwareValueExpressionParameterValueProvider(evaluator, this.getConversionService(), parameterValueProvider, context);
        } else {
            provider = NoOpParameterValueProvider.INSTANCE;
        }
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, (ParameterValueProvider)provider);
        return (S)this.populateProperties(context, entity, valueProvider, instance);
    }

    private <S> S populateProperties(ConversionContext context, CassandraPersistentEntity<?> entity, CassandraValueProvider valueProvider, S instance) {
        if (!entity.requiresPropertyPopulation()) {
            return instance;
        }
        ConvertingPropertyAccessor<S> propertyAccessor = this.newConvertingPropertyAccessor(instance, entity);
        this.readProperties(context, entity, valueProvider, (PersistentPropertyAccessor<?>)propertyAccessor, MappingCassandraConverter.isConstructorArgument(entity).negate());
        return (S)propertyAccessor.getBean();
    }

    private void readProperties(ConversionContext context, CassandraPersistentEntity<?> entity, CassandraValueProvider valueProvider, PersistentPropertyAccessor<?> propertyAccessor, Predicate<CassandraPersistentProperty> propertyFilter) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (!propertyFilter.test(property)) continue;
            ConversionContext contextToUse = context.forProperty(property.getName());
            if (!property.isCompositePrimaryKey() && !valueProvider.hasProperty(property) && !property.isEmbedded()) continue;
            propertyAccessor.setProperty((PersistentProperty)property, this.getReadValue(contextToUse, valueProvider, property));
        }
    }

    @Override
    public Object convertToColumnType(Object obj) {
        return this.convertToColumnType(obj, TypeInformation.of(obj.getClass()));
    }

    @Override
    public Object convertToColumnType(Object value, ColumnType columnType) {
        return value.getClass().isArray() ? value : this.getWriteValue(value, columnType);
    }

    public void write(Object source, Object sink) {
        Assert.notNull((Object)source, (String)"Value must not be null");
        Class<?> beanClassLoaderClass = this.transformClassToBeanClassLoaderClass(source.getClass());
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(beanClassLoaderClass);
        this.write(source, sink, entity);
    }

    @Override
    public void write(Object source, Object sink, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)source, (String)"Value must not be null");
        if (entity == null) {
            throw new MappingException("No mapping metadata found for " + source.getClass());
        }
        if (sink instanceof Where) {
            this.writeWhereFromObject(source, (Where)sink, entity);
        } else if (sink instanceof Map) {
            this.writeInternal(this.newConvertingPropertyAccessor(source, entity), (Map)sink, entity);
        } else if (sink instanceof TupleValue) {
            this.writeTupleValue(this.newConvertingPropertyAccessor(source, entity), (TupleValue)sink, entity);
        } else if (sink instanceof UdtValue) {
            this.writeUDTValue(this.newConvertingPropertyAccessor(source, entity), (UdtValue)sink, entity);
        } else {
            throw new MappingException(String.format("Unknown write target [%s]", ObjectUtils.nullSafeClassName((Object)sink)));
        }
    }

    private void writeInternal(ConvertingPropertyAccessor<?> accessor, Map<CqlIdentifier, Object> sink, CassandraPersistentEntity<?> entity) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            Object value;
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (property.isCompositePrimaryKey()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Property is a compositeKey");
                }
                if ((value = accessor.getProperty((PersistentProperty)property)) == null) continue;
                CassandraPersistentEntity compositePrimaryKey = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(property);
                this.writeInternal(this.newConvertingPropertyAccessor(value, compositePrimaryKey), sink, compositePrimaryKey);
                continue;
            }
            value = this.getWriteValue(property, accessor);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("doWithProperties Property.type %s, Property.value %s", property.getType().getName(), value));
            }
            if (!property.isWritable()) continue;
            if (value != null && property.isEmbedded()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("Mapping embedded property [%s] - [%s]", property.getRequiredColumnName(), value));
                }
                this.write(value, sink, this.embeddedEntityOperations.getEntity(property));
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Adding map.entry [%s] - [%s]", property.getRequiredColumnName(), value));
            }
            sink.put(property.getRequiredColumnName(), value);
        }
    }

    private void writeWhereFromObject(Object source, Where sink, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)source, (String)"Id source must not be null");
        Object id = this.extractId(source, entity);
        Assert.notNull((Object)id, () -> String.format("No Id value found in object %s", source));
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        CassandraPersistentProperty compositeIdProperty = null;
        if (idProperty != null && idProperty.isCompositePrimaryKey()) {
            compositeIdProperty = idProperty;
        }
        if (id instanceof MapId) {
            CassandraPersistentEntity whereEntity = compositeIdProperty != null ? (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(compositeIdProperty) : entity;
            this.writeWhere((MapId)id, sink, whereEntity);
            return;
        }
        if (idProperty == null) {
            throw new InvalidDataAccessApiUsageException(String.format("Cannot obtain where clauses for entity [%s] using [%s]", entity.getName(), source));
        }
        if (compositeIdProperty != null) {
            if (!ClassUtils.isAssignableValue((Class)compositeIdProperty.getType(), (Object)id)) {
                throw new InvalidDataAccessApiUsageException(String.format("Cannot use [%s] as composite Id for [%s]", id, entity.getName()));
            }
            CassandraPersistentEntity compositePrimaryKey = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(compositeIdProperty);
            this.writeInternal(this.newConvertingPropertyAccessor(id, compositePrimaryKey), sink, compositePrimaryKey);
            return;
        }
        Class<?> targetType = this.getTargetType(idProperty);
        sink.put(idProperty.getRequiredColumnName(), this.getPotentiallyConvertedSimpleValue(id, targetType));
    }

    @Nullable
    private Object extractId(Object source, CassandraPersistentEntity<?> entity) {
        if (ClassUtils.isAssignableValue((Class)entity.getType(), (Object)source)) {
            return this.getId(source, entity);
        }
        if (source instanceof MapId) {
            return source;
        }
        if (source instanceof MapIdentifiable) {
            return ((MapIdentifiable)source).getMapId();
        }
        return source;
    }

    private void writeWhere(MapId id, Where sink, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)id, (String)"MapId must not be null");
        for (Map.Entry entry : id.entrySet()) {
            CassandraPersistentProperty persistentProperty = (CassandraPersistentProperty)entity.getPersistentProperty((String)entry.getKey());
            if (persistentProperty == null) {
                throw new IllegalArgumentException(String.format("MapId contains references [%s] that is an unknown property of [%s]", entry.getKey(), entity.getName()));
            }
            Object writeValue = this.getWriteValue(entry.getValue(), this.cassandraTypeResolver.resolve(persistentProperty));
            sink.put(persistentProperty.getRequiredColumnName(), writeValue);
        }
    }

    private void writeTupleValue(ConvertingPropertyAccessor<?> propertyAccessor, TupleValue tupleValue, CassandraPersistentEntity<?> entity) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            Object value = this.getWriteValue(property, propertyAccessor);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("writeTupleValue Property.type %s, Property.value %s", property.getType().getName(), value));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Adding tuple value [%s] - [%s]", property.getOrdinal(), value));
            }
            TypeCodec<Object> typeCodec = this.getCodec(property);
            tupleValue.set(property.getRequiredOrdinal(), value, typeCodec);
        }
    }

    private void writeUDTValue(ConvertingPropertyAccessor<?> propertyAccessor, UdtValue udtValue, CassandraPersistentEntity<?> entity) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (!property.isWritable()) continue;
            Object value = this.getWriteValue(property, propertyAccessor);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("writeUDTValueWhereFromObject Property.type %s, Property.value %s", property.getType().getName(), value));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Adding udt.value [%s] - [%s]", property.getRequiredColumnName(), value));
            }
            if (property.isEmbedded()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("Mapping embedded property [%s] - [%s]", property.getRequiredColumnName(), value));
                }
                if (value == null) continue;
                CassandraPersistentEntity<?> targetEntity = this.embeddedEntityOperations.getEntity(property);
                this.writeUDTValue(new ConvertingPropertyAccessor(targetEntity.getPropertyAccessor(value), this.getConversionService()), udtValue, targetEntity);
                continue;
            }
            TypeCodec<Object> typeCodec = this.getCodec(property);
            udtValue.set(property.getRequiredColumnName().toString(), value, typeCodec);
        }
    }

    @Override
    public Object getId(Object object, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)object, (String)"Object instance must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        ConvertingPropertyAccessor<Object> propertyAccessor = this.newConvertingPropertyAccessor(object, entity);
        Assert.isTrue((boolean)entity.getType().isAssignableFrom(object.getClass()), () -> String.format("Given instance of type [%s] is not compatible with expected type [%s]", object.getClass().getName(), entity.getType().getName()));
        if (object instanceof MapIdentifiable) {
            return ((MapIdentifiable)object).getMapId();
        }
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            return propertyAccessor.getProperty((PersistentProperty)idProperty, idProperty.isCompositePrimaryKey() ? idProperty.getType() : this.getTargetType(idProperty));
        }
        MapId id = BasicMapId.id();
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (!property.isPrimaryKeyColumn()) continue;
            id.with(property.getName(), this.getWriteValue(property, propertyAccessor));
        }
        return id;
    }

    private Class<?> getTargetType(CassandraPersistentProperty property) {
        return this.getCustomConversions().getCustomWriteTarget(property.getType()).orElseGet(() -> this.cassandraTypeResolver.resolve(property).getType());
    }

    @Nullable
    private <T> T getWriteValue(CassandraPersistentProperty property, final ConvertingPropertyAccessor<?> propertyAccessor) {
        CassandraColumnType cassandraTypeDescriptor = this.cassandraTypeResolver.resolve(property);
        Object value = propertyAccessor.getProperty((PersistentProperty)property, cassandraTypeDescriptor.getType());
        if (this.getCustomConversions().hasValueConverter((PersistentProperty)property)) {
            return (T)this.getCustomConversions().getPropertyValueConversions().getValueConverter((PersistentProperty)property).write(value, (ValueConversionContext)new CassandraConversionContext(new PropertyValueProvider<CassandraPersistentProperty>(){

                @Nullable
                public <T> T getPropertyValue(CassandraPersistentProperty property) {
                    return (T)propertyAccessor.getProperty((PersistentProperty)property);
                }
            }, property, this, this.spELContext));
        }
        return (T)this.getWriteValue(value, cassandraTypeDescriptor);
    }

    @Nullable
    private Object getWriteValue(@Nullable Object value, ColumnType columnType) {
        if (value == null) {
            return null;
        }
        Class<?> requestedTargetType = columnType.getType();
        if (this.getCustomConversions().hasCustomWriteTarget(value.getClass(), requestedTargetType)) {
            Class<?> resolvedTargetType = this.getCustomConversions().getCustomWriteTarget(value.getClass(), requestedTargetType).orElse(requestedTargetType);
            return this.getConversionService().convert(value, resolvedTargetType);
        }
        if (this.getCustomConversions().hasCustomWriteTarget(value.getClass())) {
            Class resolvedTargetType = (Class)this.getCustomConversions().getCustomWriteTarget(value.getClass()).orElseThrow(() -> new IllegalStateException(String.format("Unable to determined custom write target for value type [%s]", value.getClass().getName())));
            return this.getConversionService().convert(value, resolvedTargetType);
        }
        if (value instanceof Collection) {
            return this.writeCollectionInternal((Collection)value, columnType);
        }
        if (value instanceof Map) {
            return this.writeMapInternal((Map)value, columnType);
        }
        TypeInformation type = TypeInformation.of(value.getClass());
        TypeInformation actualType = type.getRequiredActualType();
        BasicCassandraPersistentEntity entity = (BasicCassandraPersistentEntity)this.getMappingContext().getPersistentEntity(actualType.getType());
        if (columnType instanceof CassandraColumnType) {
            CassandraColumnType cassandraType = (CassandraColumnType)columnType;
            if (cassandraType.isTupleType()) {
                if (entity != null && entity.isTupleType()) {
                    TupleValue tupleValue = ((TupleType)cassandraType.getDataType()).newValue();
                    this.write(value, tupleValue, entity);
                    return tupleValue;
                }
                if (value instanceof TupleValue) {
                    return value;
                }
            }
            if (cassandraType.isUserDefinedType()) {
                if (entity != null && entity.isUserDefinedType()) {
                    UdtValue udtValue = ((UserDefinedType)cassandraType.getDataType()).newValue();
                    this.write(value, udtValue, entity);
                    return udtValue;
                }
                if (value instanceof UdtValue) {
                    return value;
                }
            }
        }
        if (this.getCustomConversions().isSimpleType(value.getClass())) {
            return this.getPotentiallyConvertedSimpleValue(value, requestedTargetType);
        }
        return value;
    }

    private Object writeCollectionInternal(Collection<Object> source, ColumnType type) {
        Collection converted = CollectionFactory.createCollection(MappingCassandraConverter.getCollectionType(type), (int)source.size());
        ColumnType componentType = type.getRequiredComponentType();
        for (Object element : source) {
            ColumnType elementType = componentType;
            if (elementType.getType() == Object.class) {
                elementType = this.getColumnTypeResolver().resolve(element);
            }
            converted.add(this.getWriteValue(element, elementType));
        }
        return converted;
    }

    private Object writeMapInternal(Map<Object, Object> source, ColumnType type) {
        Map converted = CollectionFactory.createMap(type.getType(), (int)source.size());
        ColumnType keyType = type.getRequiredComponentType();
        ColumnType valueType = type.getRequiredMapValueType();
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            ColumnType elementValueType;
            ColumnType elementKeyType = keyType;
            if (elementKeyType.getType() == Object.class) {
                elementKeyType = this.getColumnTypeResolver().resolve(entry.getKey());
            }
            if ((elementValueType = valueType).getType() == Object.class) {
                elementValueType = this.getColumnTypeResolver().resolve(entry.getValue());
            }
            converted.put(this.getWriteValue(entry.getKey(), elementKeyType), this.getWriteValue(entry.getValue(), elementValueType));
        }
        return converted;
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleValue(@Nullable Object value, @Nullable Class<?> requestedTargetType) {
        if (value == null) {
            return null;
        }
        if (Enum.class.isAssignableFrom(value.getClass())) {
            if (requestedTargetType != null && !requestedTargetType.isEnum() && this.getConversionService().canConvert(value.getClass(), requestedTargetType)) {
                return this.getConversionService().convert(value, requestedTargetType);
            }
            return ((Enum)value).name();
        }
        if (requestedTargetType != null && !ClassUtils.isAssignableValue(requestedTargetType, (Object)value)) {
            return this.getConversionService().convert(value, requestedTargetType);
        }
        return value;
    }

    protected Object getPotentiallyConvertedSimpleRead(Object value, TypeInformation<?> target) {
        return this.getPotentiallyConvertedSimpleRead(value, target.getType());
    }

    private Object getPotentiallyConvertedSimpleRead(@Nullable Object value, @Nullable Class<?> target) {
        if (value == null || target == null || ClassUtils.isAssignableValue(target, (Object)value)) {
            return value;
        }
        if (this.getCustomConversions().hasCustomReadTarget(value.getClass(), target)) {
            return this.doConvert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            if (value instanceof Number) {
                int ordinal = ((Number)value).intValue();
                return target.getEnumConstants()[ordinal];
            }
            return Enum.valueOf(target, value.toString());
        }
        return this.doConvert(value, target);
    }

    private <T> T doConvert(Object value, Class<T> target) {
        return (T)this.getConversionService().convert(value, target);
    }

    private static Class<?> getCollectionType(ColumnType type) {
        return type.getType();
    }

    @Nullable
    private Object getReadValue(ConversionContext context, CassandraValueProvider valueProvider, CassandraPersistentProperty property) {
        if (property.isCompositePrimaryKey()) {
            return context.convert(valueProvider.getSource(), property.getTypeInformation());
        }
        if (property.isEmbedded()) {
            CassandraPersistentEntity<?> targetEntity = this.embeddedEntityOperations.getEntity(property);
            return this.isNullEmbedded(targetEntity, property, valueProvider) ? null : this.doReadEntity(context, valueProvider, targetEntity);
        }
        if (!valueProvider.hasProperty(property)) {
            return null;
        }
        Object value = valueProvider.getPropertyValue(property);
        if (this.getCustomConversions().hasValueConverter((PersistentProperty)property)) {
            return this.getCustomConversions().getPropertyValueConversions().getValueConverter((PersistentProperty)property).read(value, (ValueConversionContext)new CassandraConversionContext(valueProvider, property, this, this.spELContext));
        }
        return value == null ? null : context.convert(value, property.getTypeInformation());
    }

    private boolean isNullEmbedded(CassandraPersistentEntity<?> entity, CassandraPersistentProperty property, CassandraValueProvider valueProvider) {
        if (Embedded.OnEmpty.USE_EMPTY.equals((Object)((Embedded)property.getRequiredAnnotation(Embedded.class)).onEmpty())) {
            return false;
        }
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty embeddedProperty = (CassandraPersistentProperty)iterator.next();
            if (!valueProvider.hasProperty(embeddedProperty) || valueProvider.getPropertyValue(embeddedProperty) == null) continue;
            return false;
        }
        return true;
    }

    protected Object readCollectionOrArray(ConversionContext context, Collection<?> source, TypeInformation<?> targetType) {
        ArrayList collection;
        Assert.notNull(targetType, (String)"Target type must not be null");
        Class<?> collectionType = MappingCassandraConverter.resolveCollectionType(targetType);
        Class<?> elementType = MappingCassandraConverter.resolveElementType(targetType);
        Collection<Object> collection2 = collection = targetType.getType().isArray() ? new ArrayList() : CollectionFactory.createCollection(collectionType, elementType, (int)source.size());
        if (source.isEmpty()) {
            return this.getPotentiallyConvertedSimpleRead(collection, collectionType);
        }
        TypeInformation componentType = targetType.getComponentType();
        componentType = componentType == null ? TypeInformation.of(elementType) : componentType;
        for (Object element : source) {
            collection.add(context.convert(element, componentType));
        }
        return this.getPotentiallyConvertedSimpleRead(collection, targetType.getType());
    }

    private static Class<?> resolveCollectionType(TypeInformation<?> typeInformation) {
        Class<List> collectionType = typeInformation.getType();
        return Collection.class.isAssignableFrom(collectionType) ? collectionType : List.class;
    }

    private static Class<?> resolveElementType(TypeInformation<?> typeInformation) {
        TypeInformation componentType = typeInformation.getComponentType();
        return componentType != null ? componentType.getType() : Object.class;
    }

    protected Object readMap(ConversionContext context, Map<?, ?> source, TypeInformation<?> targetType) {
        Assert.notNull(targetType, (String)"Target type must not be null");
        TypeInformation keyType = targetType.getComponentType();
        TypeInformation valueType = targetType.getMapValueType();
        Class rawKeyType = keyType != null ? keyType.getType() : null;
        Map map = CollectionFactory.createMap(MappingCassandraConverter.resolveMapType(targetType), (Class)rawKeyType, (int)source.size());
        if (source.isEmpty()) {
            return map;
        }
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            Object key = entry.getKey();
            if (key != null && rawKeyType != null && !rawKeyType.isAssignableFrom(key.getClass())) {
                key = context.convert(key, keyType);
            }
            Object value = entry.getValue();
            map.put(key, context.convert(value, valueType == null ? TypeInformation.OBJECT : valueType));
        }
        return map;
    }

    private static Class<?> resolveMapType(TypeInformation<?> typeInformation) {
        Class<Map> mapType = typeInformation.getType();
        return Map.class.isAssignableFrom(mapType) ? mapType : Map.class;
    }

    static Predicate<CassandraPersistentProperty> isConstructorArgument(PersistentEntity<?, ?> entity) {
        return arg_0 -> entity.isConstructorArgument(arg_0);
    }

    protected static class ConversionContext {
        final CustomConversions conversions;
        final ContainerValueConverter<Row> rowConverter;
        final ContainerValueConverter<TupleValue> tupleConverter;
        final ContainerValueConverter<UdtValue> udtConverter;
        final ContainerValueConverter<Collection<?>> collectionConverter;
        final ContainerValueConverter<Map<?, ?>> mapConverter;
        final ValueConverter<Object> elementConverter;

        public ConversionContext(CustomConversions conversions, ContainerValueConverter<Row> rowConverter, ContainerValueConverter<TupleValue> tupleConverter, ContainerValueConverter<UdtValue> udtConverter, ContainerValueConverter<Collection<?>> collectionConverter, ContainerValueConverter<Map<?, ?>> mapConverter, ValueConverter<Object> elementConverter) {
            this.conversions = conversions;
            this.rowConverter = rowConverter;
            this.tupleConverter = tupleConverter;
            this.udtConverter = udtConverter;
            this.collectionConverter = collectionConverter;
            this.mapConverter = mapConverter;
            this.elementConverter = elementConverter;
        }

        ConversionContext forProperty(String name) {
            return this;
        }

        public <S> S convert(Object source, TypeInformation<? extends S> typeHint) {
            Assert.notNull(typeHint, (String)"TypeInformation must not be null");
            if (this.conversions.hasCustomReadTarget(source.getClass(), typeHint.getType())) {
                return (S)this.elementConverter.convert(source, typeHint);
            }
            if (source instanceof Collection) {
                Class rawType = typeHint.getType();
                if (!(Object.class.equals((Object)rawType) || rawType.isArray() || ClassUtils.isAssignable(Iterable.class, (Class)rawType))) {
                    throw new MappingException(String.format("Cannot convert %1$s of type %2$s into an instance of %3$s; Implement a custom Converter<%2$s, %3$s> and register it with the CustomConversions", source, source.getClass(), rawType));
                }
                if (typeHint.isCollectionLike() || typeHint.getType().isAssignableFrom(Collection.class)) {
                    return (S)this.collectionConverter.convert(this, (Collection)source, typeHint);
                }
            }
            if (typeHint.isMap()) {
                return (S)this.mapConverter.convert(this, (Map)source, typeHint);
            }
            if (source instanceof Row) {
                return (S)this.rowConverter.convert(this, (Row)source, typeHint);
            }
            if (source instanceof TupleValue) {
                return (S)this.tupleConverter.convert(this, (TupleValue)source, typeHint);
            }
            if (source instanceof UdtValue) {
                return (S)this.udtConverter.convert(this, (UdtValue)source, typeHint);
            }
            return (S)this.elementConverter.convert(source, typeHint);
        }

        static interface ContainerValueConverter<T> {
            public Object convert(ConversionContext var1, T var2, TypeInformation<?> var3);
        }

        static interface ValueConverter<T> {
            public Object convert(T var1, TypeInformation<?> var2);
        }
    }

    class CassandraPersistentEntityParameterValueProvider
    implements ParameterValueProvider<CassandraPersistentProperty> {
        private final CassandraPersistentEntity<?> entity;
        private final CassandraValueProvider provider;
        private final ConversionContext context;
        @Nullable
        private final Object parent;

        public CassandraPersistentEntityParameterValueProvider(CassandraPersistentEntity<?> entity, CassandraValueProvider provider, @Nullable ConversionContext context, Object parent) {
            this.entity = entity;
            this.provider = provider;
            this.context = context;
            this.parent = parent;
        }

        @Nullable
        public <T> T getParameterValue(Parameter<T, CassandraPersistentProperty> parameter) {
            InstanceCreatorMetadata creatorMetadata = this.entity.getInstanceCreatorMetadata();
            if (creatorMetadata != null && creatorMetadata.isParentParameter(parameter)) {
                return (T)this.parent;
            }
            String name = parameter.getName();
            if (name == null) {
                throw new MappingException(String.format("Parameter %s does not have a name", parameter));
            }
            CassandraPersistentProperty property = this.entity.getProperty(parameter);
            if (property == null) {
                throw new MappingException(String.format("No property %s found on entity %s to bind constructor parameter to", name, this.entity.getType()));
            }
            return (T)MappingCassandraConverter.this.getReadValue(this.context.forProperty(property.getName()), this.provider, property);
        }
    }

    class ProjectingConversionContext
    extends ConversionContext {
        private final EntityProjection<?, ?> projection;

        public ProjectingConversionContext(CustomConversions conversions, ConversionContext.ContainerValueConverter<Row> rowConverter, ConversionContext.ContainerValueConverter<TupleValue> tupleConverter, ConversionContext.ContainerValueConverter<UdtValue> udtConverter, ConversionContext.ContainerValueConverter<Collection<?>> collectionConverter, ConversionContext.ContainerValueConverter<Map<?, ?>> mapConverter, ConversionContext.ValueConverter<Object> elementConverter, EntityProjection<?, ?> projection) {
            super(conversions, (context, source, typeHint) -> MappingCassandraConverter.this.doReadOrProject(context, (Row)source, (TypeInformation<?>)typeHint, projection), (context, source, typeHint) -> MappingCassandraConverter.this.doReadOrProject(context, (TupleValue)source, (TypeInformation<?>)typeHint, projection), (context, source, typeHint) -> MappingCassandraConverter.this.doReadOrProject(context, (UdtValue)source, (TypeInformation<?>)typeHint, projection), collectionConverter, mapConverter, elementConverter);
            this.projection = projection;
        }

        @Override
        ConversionContext forProperty(String name) {
            EntityProjection property = this.projection.findProperty(name);
            if (property == null) {
                return new ConversionContext(this.conversions, MappingCassandraConverter.this::doReadRow, MappingCassandraConverter.this::doReadTupleValue, MappingCassandraConverter.this::doReadUdtValue, this.collectionConverter, this.mapConverter, this.elementConverter);
            }
            return new ProjectingConversionContext(this.conversions, this.rowConverter, this.tupleConverter, this.udtConverter, this.collectionConverter, this.mapConverter, this.elementConverter, property);
        }
    }

    static class MapPersistentPropertyAccessor
    implements PersistentPropertyAccessor<Map<String, Object>> {
        Map<String, Object> map = new LinkedHashMap<String, Object>();

        MapPersistentPropertyAccessor() {
        }

        public void setProperty(PersistentProperty<?> persistentProperty, @Nullable Object o) {
            this.map.put(persistentProperty.getName(), o);
        }

        public Object getProperty(PersistentProperty<?> persistentProperty) {
            return this.map.get(persistentProperty.getName());
        }

        public Map<String, Object> getBean() {
            return this.map;
        }
    }

    private record PropertyTranslatingPropertyAccessor<T>(PersistentPropertyAccessor<T> delegate, PersistentPropertyTranslator propertyTranslator) implements PersistentPropertyAccessor<T>
    {
        static <T> PersistentPropertyAccessor<T> create(PersistentPropertyAccessor<T> delegate, PersistentPropertyTranslator propertyTranslator) {
            return new PropertyTranslatingPropertyAccessor<T>(delegate, propertyTranslator);
        }

        public void setProperty(PersistentProperty property, @Nullable Object value) {
            this.delegate.setProperty((PersistentProperty)this.translate(property), value);
        }

        public Object getProperty(PersistentProperty<?> property) {
            return this.delegate.getProperty((PersistentProperty)this.translate(property));
        }

        public T getBean() {
            return (T)this.delegate.getBean();
        }

        private CassandraPersistentProperty translate(PersistentProperty<?> property) {
            return this.propertyTranslator.translate((CassandraPersistentProperty)property);
        }
    }

    static class TranslatingCassandraValueProvider
    implements CassandraValueProvider {
        private final PersistentPropertyTranslator translator;
        private final CassandraValueProvider delegate;

        public TranslatingCassandraValueProvider(PersistentPropertyTranslator translator, CassandraValueProvider delegate) {
            this.translator = translator;
            this.delegate = delegate;
        }

        @Override
        public boolean hasProperty(CassandraPersistentProperty property) {
            return this.delegate.hasProperty(this.translator.translate(property));
        }

        @Nullable
        public <T> T getPropertyValue(CassandraPersistentProperty property) {
            return (T)this.delegate.getPropertyValue(this.translator.translate(property));
        }

        @Override
        public Object getSource() {
            return this.delegate.getSource();
        }
    }

    private static class ConverterAwareValueExpressionParameterValueProvider
    extends ValueExpressionParameterValueProvider<CassandraPersistentProperty> {
        private final ConversionContext context;

        public ConverterAwareValueExpressionParameterValueProvider(ValueExpressionEvaluator evaluator, ConversionService conversionService, ParameterValueProvider<CassandraPersistentProperty> delegate, ConversionContext context) {
            super(evaluator, conversionService, delegate);
            this.context = context;
        }

        protected <T> T potentiallyConvertExpressionValue(Object object, Parameter<T, CassandraPersistentProperty> parameter) {
            return (T)this.context.convert(object, parameter.getType());
        }
    }

    static enum NoOpParameterValueProvider implements ParameterValueProvider<CassandraPersistentProperty>
    {
        INSTANCE;


        public <T> T getParameterValue(Parameter<T, CassandraPersistentProperty> parameter) {
            return null;
        }
    }
}

