/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.cassandra.core.convert.CassandraConverters;
import org.springframework.data.cassandra.core.convert.CassandraJsr310Converters;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.data.convert.PropertyValueConversions;
import org.springframework.data.convert.PropertyValueConverterFactory;
import org.springframework.data.convert.PropertyValueConverterRegistrar;
import org.springframework.data.convert.SimplePropertyValueConversions;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.util.Assert;

public class CassandraCustomConversions
extends CustomConversions {
    private static final List<Object> STORE_CONVERTERS;
    private static final CustomConversions.StoreConversions STORE_CONVERSIONS;

    public CassandraCustomConversions(List<?> converters) {
        super((CustomConversions.ConverterConfiguration)new CassandraConverterConfiguration(converters));
    }

    protected CassandraCustomConversions(CassandraConverterConfigurationAdapter conversionConfiguration) {
        super((CustomConversions.ConverterConfiguration)conversionConfiguration.createConverterConfiguration());
    }

    public static CassandraCustomConversions create(Consumer<CassandraConverterConfigurationAdapter> configurer) {
        CassandraConverterConfigurationAdapter adapter = new CassandraConverterConfigurationAdapter();
        configurer.accept(adapter);
        return new CassandraCustomConversions(adapter);
    }

    static {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.addAll(CassandraConverters.getConvertersToRegister());
        converters.addAll(CassandraJsr310Converters.getConvertersToRegister());
        STORE_CONVERTERS = Collections.unmodifiableList(converters);
        STORE_CONVERSIONS = CustomConversions.StoreConversions.of((SimpleTypeHolder)CassandraSimpleTypeHolder.HOLDER, STORE_CONVERTERS);
    }

    static class CassandraConverterConfiguration
    extends CustomConversions.ConverterConfiguration {
        CassandraConverterConfiguration(List<?> converters) {
            super(STORE_CONVERSIONS, converters, CassandraConverterConfiguration.getConverterFilter());
        }

        CassandraConverterConfiguration(List<?> userConverters, PropertyValueConversions propertyValueConversions) {
            super(STORE_CONVERSIONS, userConverters, CassandraConverterConfiguration.getConverterFilter(), propertyValueConversions);
        }

        static Predicate<GenericConverter.ConvertiblePair> getConverterFilter() {
            return convertiblePair -> !Jsr310Converters.supports((Class)convertiblePair.getSourceType()) || !Date.class.isAssignableFrom(convertiblePair.getTargetType());
        }
    }

    public static class CassandraConverterConfigurationAdapter {
        private final List<Object> customConverters = new ArrayList<Object>();
        private final PropertyValueConversions internalValueConversion;
        private PropertyValueConversions propertyValueConversions = this.internalValueConversion = PropertyValueConversions.simple(it -> {});

        public static CassandraConverterConfigurationAdapter from(List<?> converters) {
            Assert.notNull(converters, (String)"Converters must not be null");
            CassandraConverterConfigurationAdapter adapter = new CassandraConverterConfigurationAdapter();
            adapter.registerConverters(converters);
            return adapter;
        }

        public CassandraConverterConfigurationAdapter registerConverter(Converter<?, ?> converter) {
            Assert.notNull(converter, (String)"Converter must not be null");
            this.customConverters.add(converter);
            return this;
        }

        public CassandraConverterConfigurationAdapter registerConverterFactory(ConverterFactory<?, ?> converterFactory) {
            Assert.notNull(converterFactory, (String)"ConverterFactory must not be null");
            this.customConverters.add(converterFactory);
            return this;
        }

        public CassandraConverterConfigurationAdapter registerConverters(Object ... converters) {
            return this.registerConverters(Arrays.asList(converters));
        }

        public CassandraConverterConfigurationAdapter registerConverters(Collection<?> converters) {
            Assert.notNull(converters, (String)"Converters must not be null");
            Assert.noNullElements(converters, (String)"Converters must not be null nor contain null values");
            this.customConverters.addAll(converters);
            return this;
        }

        public CassandraConverterConfigurationAdapter registerPropertyValueConverterFactory(PropertyValueConverterFactory converterFactory) {
            Assert.state((boolean)(this.valueConversions() instanceof SimplePropertyValueConversions), (String)"Configured PropertyValueConversions does not allow setting custom ConverterRegistry");
            ((SimplePropertyValueConversions)this.valueConversions()).setConverterFactory(converterFactory);
            return this;
        }

        public CassandraConverterConfigurationAdapter configurePropertyConversions(Consumer<PropertyValueConverterRegistrar<CassandraPersistentProperty>> configurationAdapter) {
            Assert.state((boolean)(this.valueConversions() instanceof SimplePropertyValueConversions), (String)"Configured PropertyValueConversions does not allow setting custom ConverterRegistry");
            PropertyValueConverterRegistrar propertyValueConverterRegistrar = new PropertyValueConverterRegistrar();
            configurationAdapter.accept((PropertyValueConverterRegistrar<CassandraPersistentProperty>)propertyValueConverterRegistrar);
            ((SimplePropertyValueConversions)this.valueConversions()).setValueConverterRegistry(propertyValueConverterRegistrar.buildRegistry());
            return this;
        }

        public CassandraConverterConfigurationAdapter withPropertyValueConversions(PropertyValueConversions valueConversions) {
            Assert.notNull((Object)valueConversions, (String)"PropertyValueConversions must not be null");
            this.propertyValueConversions = valueConversions;
            return this;
        }

        PropertyValueConversions valueConversions() {
            if (this.propertyValueConversions == null) {
                this.propertyValueConversions = this.internalValueConversion;
            }
            return this.propertyValueConversions;
        }

        CassandraConverterConfiguration createConverterConfiguration() {
            PropertyValueConversions propertyValueConversions;
            if (this.hasDefaultPropertyValueConversions() && (propertyValueConversions = this.propertyValueConversions) instanceof SimplePropertyValueConversions) {
                SimplePropertyValueConversions svc = (SimplePropertyValueConversions)propertyValueConversions;
                svc.init();
            }
            return new CassandraConverterConfiguration(this.customConverters, this.propertyValueConversions);
        }

        private boolean hasDefaultPropertyValueConversions() {
            return this.propertyValueConversions == this.internalValueConversion;
        }
    }
}

