/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import java.util.Collections;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveCassandraBatchOperations {
    public Mono<WriteResult> execute();

    public ReactiveCassandraBatchOperations withTimestamp(long var1);

    public ReactiveCassandraBatchOperations withQueryOptions(QueryOptions var1);

    default public ReactiveCassandraBatchOperations addStatement(BatchableStatement<?> statement) {
        return this.addStatement(Mono.just(statement));
    }

    public ReactiveCassandraBatchOperations addStatement(Mono<? extends BatchableStatement<?>> var1);

    default public ReactiveCassandraBatchOperations addStatements(BatchableStatement<?> ... statements) {
        return this.addStatements(Flux.fromArray((Object[])statements).toIterable());
    }

    default public ReactiveCassandraBatchOperations addStatements(Iterable<? extends BatchableStatement<?>> statements) {
        return this.addStatements(Mono.just(statements));
    }

    public ReactiveCassandraBatchOperations addStatements(Mono<? extends Iterable<? extends BatchableStatement<?>>> var1);

    default public ReactiveCassandraBatchOperations insert(Object entity, WriteOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        return this.insert(Collections.singleton(entity), options);
    }

    public ReactiveCassandraBatchOperations insert(Object ... var1);

    public ReactiveCassandraBatchOperations insert(Iterable<?> var1);

    public ReactiveCassandraBatchOperations insert(Mono<? extends Iterable<?>> var1);

    public ReactiveCassandraBatchOperations insert(Iterable<?> var1, WriteOptions var2);

    public ReactiveCassandraBatchOperations insert(Mono<? extends Iterable<?>> var1, WriteOptions var2);

    default public ReactiveCassandraBatchOperations update(Object entity, WriteOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        return this.update(Collections.singleton(entity), options);
    }

    public ReactiveCassandraBatchOperations update(Object ... var1);

    public ReactiveCassandraBatchOperations update(Iterable<?> var1);

    public ReactiveCassandraBatchOperations update(Mono<? extends Iterable<?>> var1);

    public ReactiveCassandraBatchOperations update(Iterable<?> var1, WriteOptions var2);

    public ReactiveCassandraBatchOperations update(Mono<? extends Iterable<?>> var1, WriteOptions var2);

    default public ReactiveCassandraBatchOperations delete(Object entity, WriteOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        return this.delete(Collections.singleton(entity), options);
    }

    public ReactiveCassandraBatchOperations delete(Object ... var1);

    public ReactiveCassandraBatchOperations delete(Iterable<?> var1);

    public ReactiveCassandraBatchOperations delete(Mono<? extends Iterable<?>> var1);

    public ReactiveCassandraBatchOperations delete(Iterable<?> var1, WriteOptions var2);

    public ReactiveCassandraBatchOperations delete(Mono<? extends Iterable<?>> var1, WriteOptions var2);
}

