/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.session.lookup;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.cql.session.lookup.SessionFactoryLookup;
import org.springframework.data.cassandra.core.cql.session.lookup.SessionFactoryLookupFailureException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class BeanFactorySessionFactoryLookup
implements SessionFactoryLookup,
BeanFactoryAware {
    @Nullable
    private BeanFactory beanFactory;

    public BeanFactorySessionFactoryLookup() {
    }

    public BeanFactorySessionFactoryLookup(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public SessionFactory getSessionFactory(String sessionFactoryName) throws SessionFactoryLookupFailureException {
        Assert.notNull((Object)this.beanFactory, (String)"BeanFactory must not be null");
        try {
            return (SessionFactory)this.beanFactory.getBean(sessionFactoryName, SessionFactory.class);
        }
        catch (BeansException ex) {
            throw new SessionFactoryLookupFailureException(String.format("Failed to look up SessionFactory bean with name [%s]", sessionFactoryName), ex);
        }
    }
}

