/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import org.springframework.data.cassandra.core.convert.ColumnType;
import org.springframework.data.cassandra.core.convert.ColumnTypeResolver;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.EntityConverter;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface CassandraConverter
extends EntityConverter<CassandraPersistentEntity<?>, CassandraPersistentProperty, Object, Object> {
    public CustomConversions getCustomConversions();

    public CodecRegistry getCodecRegistry();

    public CassandraMappingContext getMappingContext();

    public ColumnTypeResolver getColumnTypeResolver();

    @Nullable
    public Object getId(Object var1, CassandraPersistentEntity<?> var2);

    public Object convertToColumnType(Object var1);

    default public Object convertToColumnType(Object value, TypeInformation<?> typeInformation) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        Assert.notNull(typeInformation, (String)"TypeInformation must not be null");
        return this.convertToColumnType(value, this.getColumnTypeResolver().resolve(typeInformation));
    }

    public Object convertToColumnType(Object var1, ColumnType var2);

    public void write(Object var1, Object var2, CassandraPersistentEntity<?> var3);
}

