/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.instrument.web.mvc.HandlerParser;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.filter.CommonsRequestLoggingFilter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.WebUtils;

@ContextConfiguration(classes={TestConfig.class})
public abstract class TraceCustomHandlerParserPostHandleWebIntegrationTests {
    @Autowired
    TestSpanHandler spans;
    @Autowired
    CurrentTraceContext currentTraceContext;
    @LocalServerPort
    int port;

    @Test
    void should_tag_payload() {
        new RestTemplate().postForEntity("http://localhost:" + this.port + "/user", (Object)new UserController.User("WuWen"), UserController.User.class, new Object[0]);
        BDDAssertions.then((Object)this.currentTraceContext.context()).isNull();
        FinishedSpan span = this.spans.takeRemoteSpan(Span.Kind.SERVER);
        BDDAssertions.then((Map)span.getTags()).containsEntry((Object)"preHandle.payload.isNull", (Object)"null");
        BDDAssertions.then((Map)span.getTags()).containsEntry((Object)"http.payload", (Object)"{\"name\":\"WuWen\"}");
    }

    @RestController
    public static class UserController {
        private static final Log log = LogFactory.getLog(UserController.class);

        @PostMapping(value={"/user"})
        public User user(@RequestBody User user) {
            log.info((Object)"Test request body.");
            return user;
        }

        public static class User {
            private String name;

            public User() {
            }

            public User(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String toString() {
                return "User{name='" + this.name + '\'' + '}';
            }
        }
    }

    @EnableAutoConfiguration(excludeName={"org.springframework.cloud.sleuth.autoconfig.instrument.web.client.TraceWebClientAutoConfiguration"})
    @Configuration(proxyBeanMethods=false)
    static class TestConfig {
        TestConfig() {
        }

        @Bean
        UserController goodController() {
            return new UserController();
        }

        @Bean
        CommonsRequestLoggingFilter commonsRequestLoggingFilter() {
            CommonsRequestLoggingFilter filter = new CommonsRequestLoggingFilter();
            filter.setIncludePayload(true);
            filter.setMaxPayloadLength(512);
            return filter;
        }

        @Bean
        public FilterRegistrationBean requestLoggingFilter(CommonsRequestLoggingFilter filter) {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.addUrlPatterns(new String[]{"/*"});
            registration.setFilter((Filter)filter);
            return registration;
        }

        @Bean
        HandlerParser handlerParser() {
            return new HandlerParser(){

                protected void preHandle(HttpServletRequest request, Object handler, SpanCustomizer customizer) {
                    customizer.tag("preHandle.payload.isNull", this.getMessagePayload(request));
                }

                protected void postHandle(HttpServletRequest request, Object handler, ModelAndView modelAndView, SpanCustomizer customizer) {
                    customizer.tag("http.payload", this.getMessagePayload(request));
                }

                protected String getMessagePayload(HttpServletRequest request) {
                    byte[] buf;
                    ContentCachingRequestWrapper wrapper = (ContentCachingRequestWrapper)WebUtils.getNativeRequest((ServletRequest)request, ContentCachingRequestWrapper.class);
                    if (wrapper != null && (buf = wrapper.getContentAsByteArray()).length > 0) {
                        int length = Math.min(buf.length, 512);
                        try {
                            return new String(buf, 0, length, wrapper.getCharacterEncoding());
                        }
                        catch (UnsupportedEncodingException ex) {
                            return "[unknown]";
                        }
                    }
                    return "null";
                }
            };
        }

        @Bean
        RestTemplate restTemplate() {
            RestTemplate restTemplate = new RestTemplate();
            restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

                public void handleError(ClientHttpResponse response) {
                }
            });
            return restTemplate;
        }
    }
}

