/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.r2dbc;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.instrument.r2dbc.ReactiveCustomerRepository;
import org.springframework.cloud.sleuth.instrument.r2dbc.ReactiveNestedTransactionService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Mono;

@Service
public class ReactiveContinuedTransactionService {
    private static final Logger log = LoggerFactory.getLogger(ReactiveContinuedTransactionService.class);
    private final ReactiveCustomerRepository repository;
    private final ReactiveNestedTransactionService reactiveNestedTransactionService;

    public ReactiveContinuedTransactionService(ReactiveCustomerRepository repository, ReactiveNestedTransactionService reactiveNestedTransactionService) {
        this.repository = repository;
        this.reactiveNestedTransactionService = reactiveNestedTransactionService;
    }

    @Transactional
    public Mono<Void> continuedTransaction() {
        return Mono.fromRunnable(() -> log.info("Hello from continued transaction")).then(this.repository.findById(1L)).doOnNext(customer -> {
            log.info("Customer found with findById(1L):");
            log.info("--------------------------------");
            log.info(customer.toString());
            log.info("");
        }).doOnNext(customer -> {
            log.info("Customer found with findByLastName('Bauer'):");
            log.info("--------------------------------------------");
        }).flatMapMany(customer -> this.repository.findByLastName("Bauer")).doOnNext(cust -> log.info(cust.toString())).then(this.reactiveNestedTransactionService.requiresNew());
    }
}

