/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.jdbc;

import javax.sql.DataSource;
import net.ttddyy.dsproxy.support.ProxyDataSourceBuilder;
import org.springframework.cloud.sleuth.instrument.jdbc.DataSourceDecorator;
import org.springframework.cloud.sleuth.instrument.jdbc.DataSourceNameResolver;
import org.springframework.cloud.sleuth.instrument.jdbc.DataSourceProxyBuilderCustomizer;
import org.springframework.core.Ordered;

public class DataSourceProxyDataSourceDecorator
implements DataSourceDecorator,
Ordered {
    private final DataSourceProxyBuilderCustomizer dataSourceProxyBuilderCustomizer;
    private final DataSourceNameResolver dataSourceNameResolver;

    public DataSourceProxyDataSourceDecorator(DataSourceProxyBuilderCustomizer dataSourceProxyBuilderCustomizer, DataSourceNameResolver dataSourceNameResolver) {
        this.dataSourceProxyBuilderCustomizer = dataSourceProxyBuilderCustomizer;
        this.dataSourceNameResolver = dataSourceNameResolver;
    }

    @Override
    public DataSource decorate(String beanName, DataSource dataSource) {
        ProxyDataSourceBuilder proxyDataSourceBuilder = ProxyDataSourceBuilder.create();
        proxyDataSourceBuilder = this.dataSourceProxyBuilderCustomizer.customize(proxyDataSourceBuilder);
        String dataSourceName = this.dataSourceNameResolver.resolveDataSourceName(dataSource);
        return proxyDataSourceBuilder.dataSource(dataSource).name(dataSourceName).build();
    }

    public int getOrder() {
        return 20;
    }
}

