/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.loadbalancer.RetryableFeignBlockingLoadBalancerClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.LazyTracingFeignClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignBlockingLoadBalancerClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignBuilderBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceRetryableFeignBlockingLoadBalancerClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TracingFeignClient;
import org.springframework.cloud.util.ProxyUtils;
import org.springframework.util.ClassUtils;

final class TraceFeignObjectWrapper {
    public static final String EXCEPTION_WARNING = "Exception occurred while trying to access the delegate's field. Will fallback to default instrumentation mechanism, which means that the delegate might not be instrumented";
    private static final Log log = LogFactory.getLog(TraceFeignObjectWrapper.class);
    private static final boolean loadBalancerPresent = ClassUtils.isPresent((String)"org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient", null) && ClassUtils.isPresent((String)"org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient", null) && ClassUtils.isPresent((String)"org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory", null);
    private static final String DELEGATE = "delegate";
    private final BeanFactory beanFactory;
    private Object loadBalancerClient;
    private LoadBalancerProperties loadBalancerProperties;
    private Object loadBalancerRetryFactory;
    private Object loadBalancerClientFactory;
    private final TraceFeignBuilderBeanPostProcessor traceFeignBuilderBeanPostProcessor;

    TraceFeignObjectWrapper(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.traceFeignBuilderBeanPostProcessor = new TraceFeignBuilderBeanPostProcessor(beanFactory);
    }

    Object wrap(Object bean) {
        if (bean instanceof Client && !(bean instanceof TracingFeignClient) && !(bean instanceof LazyTracingFeignClient)) {
            if (loadBalancerPresent && bean instanceof FeignBlockingLoadBalancerClient && !(bean instanceof TraceFeignBlockingLoadBalancerClient)) {
                return this.instrumentedFeignLoadBalancerClient(bean);
            }
            if (loadBalancerPresent && bean instanceof RetryableFeignBlockingLoadBalancerClient && !(bean instanceof TraceRetryableFeignBlockingLoadBalancerClient)) {
                return this.instrumentedRetryableFeignLoadBalancerClient(bean);
            }
            return new LazyTracingFeignClient(this.beanFactory, (Client)bean);
        }
        return this.traceFeignBuilderBeanPostProcessor.postProcessAfterInitialization(bean, null);
    }

    private Object instrumentedFeignLoadBalancerClient(Object bean) {
        if (AopUtils.getTargetClass((Object)bean).equals(FeignBlockingLoadBalancerClient.class)) {
            FeignBlockingLoadBalancerClient client = (FeignBlockingLoadBalancerClient)ProxyUtils.getTargetObject((Object)bean);
            return new TraceFeignBlockingLoadBalancerClient((Client)new TraceFeignObjectWrapper(this.beanFactory).wrap(client.getDelegate()), (LoadBalancerClient)this.loadBalancerClient(), this.loadBalancerProperties(), (LoadBalancerClientFactory)this.loadBalancerClientFactory(), this.beanFactory);
        }
        FeignBlockingLoadBalancerClient client = (FeignBlockingLoadBalancerClient)ProxyUtils.getTargetObject((Object)bean);
        try {
            Field delegate = FeignBlockingLoadBalancerClient.class.getDeclaredField(DELEGATE);
            delegate.setAccessible(true);
            delegate.set(client, new TraceFeignObjectWrapper(this.beanFactory).wrap(client.getDelegate()));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            log.warn((Object)EXCEPTION_WARNING, (Throwable)e);
        }
        return new TraceFeignBlockingLoadBalancerClient((Client)client, (LoadBalancerClient)this.loadBalancerClient(), this.loadBalancerProperties(), (LoadBalancerClientFactory)this.loadBalancerClientFactory(), this.beanFactory);
    }

    private Object instrumentedRetryableFeignLoadBalancerClient(Object bean) {
        if (AopUtils.getTargetClass((Object)bean).equals(RetryableFeignBlockingLoadBalancerClient.class)) {
            RetryableFeignBlockingLoadBalancerClient client = (RetryableFeignBlockingLoadBalancerClient)ProxyUtils.getTargetObject((Object)bean);
            return new TraceRetryableFeignBlockingLoadBalancerClient((Client)new TraceFeignObjectWrapper(this.beanFactory).wrap(client.getDelegate()), (BlockingLoadBalancerClient)this.loadBalancerClient(), (LoadBalancedRetryFactory)this.loadBalancerRetryFactory(), this.loadBalancerProperties(), (LoadBalancerClientFactory)this.loadBalancerClientFactory(), this.beanFactory);
        }
        RetryableFeignBlockingLoadBalancerClient client = (RetryableFeignBlockingLoadBalancerClient)bean;
        try {
            Field delegate = RetryableFeignBlockingLoadBalancerClient.class.getDeclaredField(DELEGATE);
            delegate.setAccessible(true);
            delegate.set(client, new TraceFeignObjectWrapper(this.beanFactory).wrap(client.getDelegate()));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            log.warn((Object)EXCEPTION_WARNING, (Throwable)e);
        }
        return new TraceRetryableFeignBlockingLoadBalancerClient((Client)client, (BlockingLoadBalancerClient)this.loadBalancerClient(), (LoadBalancedRetryFactory)this.loadBalancerRetryFactory(), this.loadBalancerProperties(), (LoadBalancerClientFactory)this.loadBalancerClientFactory(), this.beanFactory);
    }

    private Object loadBalancerClient() {
        if (this.loadBalancerClient == null) {
            this.loadBalancerClient = this.beanFactory.getBean(LoadBalancerClient.class);
        }
        return this.loadBalancerClient;
    }

    private LoadBalancerProperties loadBalancerProperties() {
        if (this.loadBalancerProperties == null) {
            this.loadBalancerProperties = (LoadBalancerProperties)this.beanFactory.getBean(LoadBalancerProperties.class);
        }
        return this.loadBalancerProperties;
    }

    private Object loadBalancerRetryFactory() {
        if (this.loadBalancerRetryFactory == null) {
            this.loadBalancerRetryFactory = this.beanFactory.getBean(LoadBalancedRetryFactory.class);
        }
        return this.loadBalancerRetryFactory;
    }

    private Object loadBalancerClientFactory() {
        if (this.loadBalancerClientFactory == null) {
            this.loadBalancerClientFactory = this.beanFactory.getBean(LoadBalancerClientFactory.class);
        }
        return this.loadBalancerClientFactory;
    }
}

