/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.messaging.support.NativeMessageHeaderAccessor;
import org.springframework.util.StringUtils;

public class MessageHeaderPropagatorGetter
implements Propagator.Getter<MessageHeaderAccessor> {
    private static final Log log = LogFactory.getLog(MessageHeaderPropagatorGetter.class);

    public String get(MessageHeaderAccessor accessor, String key) {
        block3: {
            try {
                String value = this.doGet(accessor, key);
                if (StringUtils.hasText((String)value)) {
                    return value;
                }
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("An exception happened when we tried to retrieve the [" + key + "] from message"), (Throwable)ex);
            }
        }
        return null;
    }

    private String doGet(MessageHeaderAccessor accessor, String key) {
        if (accessor instanceof NativeMessageHeaderAccessor) {
            NativeMessageHeaderAccessor nativeAccessor = (NativeMessageHeaderAccessor)accessor;
            Map nativeHeadersMap = nativeAccessor.toNativeHeaderMap();
            if (!nativeHeadersMap.isEmpty()) {
                return this.getFromNativeHeaders(nativeHeadersMap, key);
            }
        } else {
            Map nativeHeadersMap;
            Object nativeHeaders = accessor.getHeader("nativeHeaders");
            if (nativeHeaders instanceof Map && !(nativeHeadersMap = (Map)nativeHeaders).isEmpty()) {
                return this.getFromNativeHeaders(nativeHeadersMap, key);
            }
        }
        Set headerEntries = accessor.getMessageHeaders().entrySet();
        return this.getFromHeaders(headerEntries, key);
    }

    private String getFromHeaders(Set<Map.Entry<String, Object>> headerEntries, String key) {
        for (Map.Entry<String, Object> entry : headerEntries) {
            Object result;
            if (!entry.getKey().equalsIgnoreCase(key) || (result = entry.getValue()) == null) continue;
            if (result instanceof byte[]) {
                return new String((byte[])result, StandardCharsets.UTF_8);
            }
            return result.toString();
        }
        return null;
    }

    private String getFromNativeHeaders(Map nativeHeaders, String key) {
        Set entrySet = nativeHeaders.entrySet();
        for (Map.Entry entries : entrySet) {
            Object result;
            String headersKey;
            if (!(entries.getKey() instanceof String) || !(headersKey = (String)entries.getKey()).equalsIgnoreCase(key) || !((result = entries.getValue()) instanceof List) || ((List)result).isEmpty()) continue;
            return String.valueOf(((List)result).get(0));
        }
        return null;
    }

    public String toString() {
        return "MessageHeaderPropagatorGetter{}";
    }
}

