/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.util.ArrayList;
import org.springframework.cloud.sleuth.instrument.web.client.LazyTraceClientHttpRequestInterceptor;
import org.springframework.cloud.sleuth.instrument.web.mvc.TracingClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

class RestTemplateInterceptorInjector {
    private final ClientHttpRequestInterceptor interceptor;

    RestTemplateInterceptorInjector(ClientHttpRequestInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    void inject(RestTemplate restTemplate) {
        if (this.hasTraceInterceptor(restTemplate)) {
            return;
        }
        ArrayList<ClientHttpRequestInterceptor> interceptors = new ArrayList<ClientHttpRequestInterceptor>(restTemplate.getInterceptors());
        interceptors.add(0, this.interceptor);
        restTemplate.setInterceptors(interceptors);
    }

    private boolean hasTraceInterceptor(RestTemplate restTemplate) {
        for (ClientHttpRequestInterceptor interceptor : restTemplate.getInterceptors()) {
            if (!(interceptor instanceof TracingClientHttpRequestInterceptor) && !(interceptor instanceof LazyTraceClientHttpRequestInterceptor)) continue;
            return true;
        }
        return false;
    }
}

