/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.function.Supplier;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.async.ExecutorMethodInterceptor;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceAsyncTaskExecutor;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceExecutor;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceScheduledThreadPoolExecutor;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceThreadPoolTaskExecutor;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceThreadPoolTaskScheduler;
import org.springframework.cloud.sleuth.instrument.async.TraceableExecutorService;
import org.springframework.cloud.sleuth.instrument.async.TraceableScheduledExecutorService;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.ReflectionUtils;

public class ExecutorInstrumentor {
    private static final Log log = LogFactory.getLog(ExecutorInstrumentor.class);
    private final Supplier<List<String>> ignoredBeans;
    private final BeanFactory beanFactory;

    public ExecutorInstrumentor(Supplier<List<String>> ignoredBeans, BeanFactory beanFactory) {
        this.ignoredBeans = ignoredBeans;
        this.beanFactory = beanFactory;
    }

    public static boolean isApplicableForInstrumentation(Object bean) {
        return bean instanceof Executor && !(bean instanceof LazyTraceThreadPoolTaskExecutor) && !(bean instanceof TraceableScheduledExecutorService) && !(bean instanceof TraceableExecutorService) && !(bean instanceof LazyTraceAsyncTaskExecutor) && !(bean instanceof LazyTraceExecutor);
    }

    public Object instrument(Object bean, String beanName) {
        if (!ExecutorInstrumentor.isApplicableForInstrumentation(bean)) {
            log.info((Object)("Bean is already instrumented or is not applicable for instrumentation " + beanName));
            return bean;
        }
        if (bean instanceof ThreadPoolTaskExecutor) {
            if (this.isProxyNeeded(beanName)) {
                return this.wrapThreadPoolTaskExecutor(bean, beanName);
            }
            log.info((Object)("Not instrumenting bean " + beanName));
        } else if (bean instanceof ScheduledExecutorService) {
            if (this.isProxyNeeded(beanName)) {
                return this.wrapScheduledExecutorService(bean, beanName);
            }
            log.info((Object)("Not instrumenting bean " + beanName));
        } else if (bean instanceof ExecutorService) {
            if (this.isProxyNeeded(beanName)) {
                return this.wrapExecutorService(bean, beanName);
            }
            log.info((Object)("Not instrumenting bean " + beanName));
        } else if (bean instanceof AsyncTaskExecutor) {
            if (this.isProxyNeeded(beanName)) {
                return this.wrapAsyncTaskExecutor(bean, beanName);
            }
            log.info((Object)("Not instrumenting bean " + beanName));
        } else if (bean instanceof Executor) {
            return this.wrapExecutor(bean, beanName);
        }
        return bean;
    }

    private Object wrapExecutor(Object bean, String beanName) {
        Executor executor = (Executor)bean;
        boolean methodFinal = ExecutorInstrumentor.anyFinalMethods(executor);
        boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
        boolean cglibProxy = !methodFinal && !classFinal;
        try {
            return this.createProxy(bean, cglibProxy, (Advice)new ExecutorMethodInterceptor<Executor>(executor, this.beanFactory, beanName));
        }
        catch (AopConfigException ex) {
            if (cglibProxy) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exception occurred while trying to create a proxy, falling back to JDK proxy", (Throwable)ex);
                }
                return this.createProxy(bean, false, (Advice)new ExecutorMethodInterceptor<Executor>(executor, this.beanFactory, beanName));
            }
            throw ex;
        }
    }

    private Object wrapThreadPoolTaskExecutor(Object bean, String beanName) {
        ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)bean;
        boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
        boolean methodsFinal = ExecutorInstrumentor.anyFinalMethods(executor);
        boolean cglibProxy = !classFinal && !methodsFinal;
        return this.createThreadPoolTaskExecutorProxy(bean, cglibProxy, executor, beanName);
    }

    private Object wrapExecutorService(Object bean, String beanName) {
        ExecutorService executor = (ExecutorService)bean;
        boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
        boolean methodFinal = ExecutorInstrumentor.anyFinalMethods(executor);
        boolean cglibProxy = !classFinal && !methodFinal;
        return this.createExecutorServiceProxy(bean, cglibProxy, executor, beanName);
    }

    private Object wrapScheduledExecutorService(Object bean, String beanName) {
        ScheduledExecutorService executor = (ScheduledExecutorService)bean;
        boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
        boolean methodFinal = ExecutorInstrumentor.anyFinalMethods(executor);
        boolean cglibProxy = !classFinal && !methodFinal;
        return this.createScheduledExecutorServiceProxy(bean, cglibProxy, executor, beanName);
    }

    private Object wrapAsyncTaskExecutor(Object bean, String beanName) {
        AsyncTaskExecutor executor = (AsyncTaskExecutor)bean;
        boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
        boolean methodsFinal = ExecutorInstrumentor.anyFinalMethods(executor);
        boolean cglibProxy = !classFinal && !methodsFinal;
        return this.createAsyncTaskExecutorProxy(bean, cglibProxy, executor, beanName);
    }

    boolean isProxyNeeded(String beanName) {
        return !this.ignoredBeans.get().contains(beanName);
    }

    Object createThreadPoolTaskExecutorProxy(Object bean, boolean cglibProxy, ThreadPoolTaskExecutor executor, String beanName) {
        if (!cglibProxy) {
            return new LazyTraceThreadPoolTaskExecutor(this.beanFactory, executor, beanName);
        }
        return this.getProxiedObject(bean, beanName, true, (Executor)executor, () -> new LazyTraceThreadPoolTaskExecutor(this.beanFactory, executor, beanName));
    }

    Supplier<Executor> createThreadPoolTaskSchedulerProxy(ThreadPoolTaskScheduler executor, String beanName) {
        return () -> new LazyTraceThreadPoolTaskScheduler(this.beanFactory, executor, beanName);
    }

    Supplier<Executor> createScheduledThreadPoolExecutorProxy(ScheduledThreadPoolExecutor executor, String beanName) {
        return () -> new LazyTraceScheduledThreadPoolExecutor(executor.getCorePoolSize(), executor.getThreadFactory(), executor.getRejectedExecutionHandler(), this.beanFactory, executor, beanName);
    }

    Object createExecutorServiceProxy(Object bean, boolean cglibProxy, ExecutorService executor, String beanName) {
        return this.getProxiedObject(bean, beanName, cglibProxy, executor, () -> {
            if (executor instanceof ScheduledExecutorService) {
                return new TraceableScheduledExecutorService(this.beanFactory, executor, beanName);
            }
            return new TraceableExecutorService(this.beanFactory, executor, beanName);
        });
    }

    Object createScheduledExecutorServiceProxy(Object bean, boolean cglibProxy, ScheduledExecutorService executor, String beanName) {
        return this.getProxiedObject(bean, beanName, cglibProxy, executor, () -> new TraceableScheduledExecutorService(this.beanFactory, executor, beanName));
    }

    Object createAsyncTaskExecutorProxy(Object bean, boolean cglibProxy, AsyncTaskExecutor executor, String beanName) {
        return this.getProxiedObject(bean, beanName, cglibProxy, (Executor)executor, () -> {
            if (bean instanceof ThreadPoolTaskScheduler) {
                return new LazyTraceThreadPoolTaskScheduler(this.beanFactory, (ThreadPoolTaskScheduler)executor, beanName);
            }
            return new LazyTraceAsyncTaskExecutor(this.beanFactory, executor, beanName);
        });
    }

    private Object getProxiedObject(Object bean, String beanName, boolean cglibProxy, Executor executor, Supplier<Executor> supplier) {
        ProxyFactoryBean factory = this.proxyFactoryBean(bean, beanName, cglibProxy, executor, supplier);
        try {
            return this.getObject(factory);
        }
        catch (Exception ex) {
            block9: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exception occurred while trying to get a proxy. Will fallback to a different implementation", (Throwable)ex);
                }
                try {
                    if (bean instanceof ThreadPoolTaskScheduler) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Will wrap ThreadPoolTaskScheduler in its tracing representation due to previous errors");
                        }
                        return this.createThreadPoolTaskSchedulerProxy((ThreadPoolTaskScheduler)bean, beanName).get();
                    }
                    if (bean instanceof ScheduledThreadPoolExecutor) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Will wrap ScheduledThreadPoolExecutor in its tracing representation due to previous errors");
                        }
                        return this.createScheduledThreadPoolExecutorProxy((ScheduledThreadPoolExecutor)bean, beanName).get();
                    }
                }
                catch (Exception ex2) {
                    if (!log.isDebugEnabled()) break block9;
                    log.debug((Object)"Fallback for special wrappers failed, will try the tracing representation instead", (Throwable)ex2);
                }
            }
            return supplier.get();
        }
    }

    private ProxyFactoryBean proxyFactoryBean(Object bean, String beanName, boolean cglibProxy, Executor executor, final Supplier<Executor> supplier) {
        ProxyFactoryBean factory = new ProxyFactoryBean();
        factory.setProxyTargetClass(cglibProxy);
        factory.addAdvice((Advice)new ExecutorMethodInterceptor<Executor>(executor, this.beanFactory, beanName){

            @Override
            Executor executor(BeanFactory beanFactory, Executor executor, String beanName) {
                return (Executor)supplier.get();
            }
        });
        factory.setTarget(bean);
        return factory;
    }

    Object getObject(ProxyFactoryBean factory) {
        return factory.getObject();
    }

    Object createProxy(Object bean, boolean cglibProxy, Advice advice) {
        ProxyFactoryBean factory = new ProxyFactoryBean();
        factory.setProxyTargetClass(cglibProxy);
        factory.addAdvice(advice);
        factory.setTarget(bean);
        return this.getObject(factory);
    }

    private static <T> boolean anyFinalMethods(T object) {
        try {
            for (Method method : ReflectionUtils.getAllDeclaredMethods(object.getClass())) {
                Method m;
                if (method.getDeclaringClass().equals(Object.class) || (m = ReflectionUtils.findMethod(object.getClass(), (String)method.getName(), (Class[])method.getParameterTypes())) == null || !Modifier.isPublic(m.getModifiers()) || !Modifier.isFinal(m.getModifiers())) continue;
                return true;
            }
        }
        catch (IllegalAccessError er) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error occurred while trying to access methods", (Throwable)er);
            }
            return false;
        }
        return false;
    }
}

