/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route.builder;

import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.cloud.gateway.handler.AsyncPredicate;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.builder.GatewayFilterSpec;
import org.springframework.cloud.gateway.route.builder.PredicateSpec;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.route.builder.UriSpec;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;

public class BooleanSpec
extends UriSpec {
    final AsyncPredicate<ServerWebExchange> predicate;

    public BooleanSpec(Route.AsyncBuilder routeBuilder, RouteLocatorBuilder.Builder builder) {
        super(routeBuilder, builder);
        this.predicate = routeBuilder.getPredicate();
    }

    public BooleanOpSpec and() {
        return new BooleanOpSpec(this.routeBuilder, this.builder, Operator.AND);
    }

    public BooleanOpSpec or() {
        return new BooleanOpSpec(this.routeBuilder, this.builder, Operator.OR);
    }

    public BooleanSpec negate() {
        this.routeBuilder.negate();
        return new BooleanSpec(this.routeBuilder, this.builder);
    }

    public UriSpec filters(Function<GatewayFilterSpec, UriSpec> fn) {
        return fn.apply(new GatewayFilterSpec(this.routeBuilder, this.builder));
    }

    public static class BooleanOpSpec
    extends PredicateSpec {
        private Operator operator;

        BooleanOpSpec(Route.AsyncBuilder routeBuilder, RouteLocatorBuilder.Builder builder, Operator operator) {
            super(routeBuilder, builder);
            Assert.notNull((Object)((Object)operator), (String)"operator may not be null");
            this.operator = operator;
        }

        @Override
        public BooleanSpec predicate(Predicate<ServerWebExchange> predicate) {
            return this.asyncPredicate(ServerWebExchangeUtils.toAsyncPredicate(predicate));
        }

        @Override
        public BooleanSpec asyncPredicate(AsyncPredicate<ServerWebExchange> predicate) {
            switch (this.operator.ordinal()) {
                case 0: {
                    this.routeBuilder.and(predicate);
                    break;
                }
                case 1: {
                    this.routeBuilder.or(predicate);
                    break;
                }
                case 2: {
                    this.routeBuilder.negate();
                }
            }
            return new BooleanSpec(this.routeBuilder, this.builder);
        }

        @Override
        public BooleanSpec not(Function<PredicateSpec, BooleanSpec> fn) {
            return fn.apply(new NotOpSpec(this.routeBuilder, this.builder, this.operator));
        }

        public BooleanSpec nested(Function<PredicateSpec, BooleanSpec> fn) {
            return fn.apply(new NestedOpSpec(this.routeBuilder, this.builder, this.operator));
        }
    }

    public static enum Operator {
        AND,
        OR,
        NEGATE;

    }

    public static class NestedOpSpec
    extends BooleanOpSpec {
        NestedOpSpec(Route.AsyncBuilder routeBuilder, RouteLocatorBuilder.Builder builder, Operator operator) {
            super(routeBuilder, builder, operator);
        }

        @Override
        public BooleanSpec asyncPredicate(AsyncPredicate<ServerWebExchange> predicate) {
            return super.asyncPredicate(predicate);
        }
    }

    public static class NotOpSpec
    extends BooleanOpSpec {
        NotOpSpec(Route.AsyncBuilder routeBuilder, RouteLocatorBuilder.Builder builder, Operator operator) {
            super(routeBuilder, builder, operator);
        }

        @Override
        public BooleanSpec asyncPredicate(AsyncPredicate<ServerWebExchange> predicate) {
            AsyncPredicate<ServerWebExchange> negated = this.routeBuilder.getPredicate().not(predicate);
            return super.asyncPredicate(negated);
        }
    }
}

