/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.message;

import java.util.Map;
import java.util.TreeMap;
import org.springframework.messaging.Message;

public abstract class MessageUtils {
    public static String MESSAGE_TYPE = "message-type";
    public static String TARGET_PROTOCOL = "target-protocol";
    public static String SOURCE_TYPE = "source-type";

    public static MessageStructureWithCaseInsensitiveHeaderKeys toCaseInsensitiveHeadersStructure(Message<?> message) {
        return new MessageStructureWithCaseInsensitiveHeaderKeys(message);
    }

    public static class MessageStructureWithCaseInsensitiveHeaderKeys {
        private final Object payload;
        private final Map headers;

        MessageStructureWithCaseInsensitiveHeaderKeys(Message message) {
            this.payload = message.getPayload();
            this.headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            this.headers.putAll(message.getHeaders());
        }

        public Object getPayload() {
            return this.payload;
        }

        public Map getHeaders() {
            return this.headers;
        }
    }
}

