/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.dsl.wiremock;

import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.List;
import java.util.Map;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.Assertions;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.dsl.wiremock.RequestMatcher;
import tools.jackson.databind.json.JsonMapper;

class GraphQlMatcher
implements RequestMatcher {
    static final String NAME = "graphql";
    private static final Log log = LogFactory.getLog(GraphQlMatcher.class);
    private final JsonMapper objectMapper = new JsonMapper();

    GraphQlMatcher() {
    }

    @Override
    public MatchResult match(List<YamlContract> contracts, Request request, Parameters parameters) {
        YamlContract contract = contracts.get(0);
        Map body = (Map)contract.request.body;
        try {
            Map jsonBodyFromContract = body;
            Map jsonBodyFromRequest = (Map)this.objectMapper.readerForMapOf(Object.class).readValue(request.getBody());
            String query = (String)jsonBodyFromContract.get("query");
            String queryFromRequest = (String)jsonBodyFromRequest.get("query");
            Map variables = (Map)jsonBodyFromContract.get("variables");
            Map variablesFromRequest = (Map)jsonBodyFromRequest.get("variables");
            String operationName = (String)jsonBodyFromContract.get("operationName");
            String operationNameFromRequest = (String)jsonBodyFromRequest.get("operationName");
            boolean queryMatches = this.assertThat(() -> Assertions.assertThat((String)query).isEqualToIgnoringWhitespace((CharSequence)queryFromRequest));
            boolean variablesMatch = this.assertThat(() -> JsonAssertions.assertThatJson((Object)variables).isEqualTo((Object)variablesFromRequest));
            boolean operationMatches = StringUtils.equals((CharSequence)operationName, (CharSequence)operationNameFromRequest);
            return MatchResult.of((queryMatches && variablesMatch && operationMatches ? 1 : 0) != 0, (SubEvent[])new SubEvent[0]);
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"An exception occurred while trying to parse the graphql entries", (Throwable)e);
            }
            return MatchResult.noMatch((SubEvent[])new SubEvent[0]);
        }
    }

    @Override
    public boolean isApplicable(String tool) {
        return NAME.equals(tool);
    }
}

