/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.spec.pact;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslRequestWithPath;
import au.com.dius.pact.consumer.dsl.PactDslResponse;
import au.com.dius.pact.consumer.dsl.PactDslWithProvider;
import au.com.dius.pact.consumer.dsl.PactDslWithState;
import au.com.dius.pact.core.model.RequestResponsePact;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.Body;
import org.springframework.cloud.contract.spec.internal.BodyMatchers;
import org.springframework.cloud.contract.spec.internal.Cookies;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.Header;
import org.springframework.cloud.contract.spec.internal.QueryParameters;
import org.springframework.cloud.contract.spec.internal.RegexProperty;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.spec.internal.Response;
import org.springframework.cloud.contract.verifier.spec.pact.BodyConverter;
import org.springframework.cloud.contract.verifier.spec.pact.MatchingRulesConverter;
import org.springframework.cloud.contract.verifier.spec.pact.Names;
import org.springframework.cloud.contract.verifier.spec.pact.NamingUtil;
import org.springframework.cloud.contract.verifier.spec.pact.PactMetaData;
import org.springframework.cloud.contract.verifier.spec.pact.ValueGeneratorConverter;
import org.springframework.util.CollectionUtils;

class RequestResponsePactCreator {
    RequestResponsePactCreator() {
    }

    RequestResponsePact createFromContract(List<Contract> contracts) {
        if (CollectionUtils.isEmpty(contracts)) {
            return null;
        }
        Names names = NamingUtil.name(contracts.get(0));
        PactDslWithProvider pactDslWithProvider = ConsumerPactBuilder.consumer((String)names.getConsumer()).hasPactWith(names.getProducer());
        PactDslResponse pactDslResponse = null;
        for (Contract contract : contracts) {
            this.assertNoExecutionProperty(contract);
            PactDslRequestWithPath pactDslRequest = pactDslResponse != null ? this.createPactDslRequestWithPath(contract, pactDslResponse) : this.createPactDslRequestWithPath(contract, pactDslWithProvider);
            pactDslResponse = this.createPactDslResponse(contract, pactDslRequest);
        }
        return pactDslResponse.toPact();
    }

    private void assertNoExecutionProperty(Contract contract) {
        this.assertNoExecutionPropertyInBody(contract.getRequest().getBody(), DslProperty::getServerValue);
        this.assertNoExecutionPropertyInBody(contract.getResponse().getBody(), DslProperty::getClientValue);
    }

    private void assertNoExecutionPropertyInBody(Body body, Function<DslProperty<?>, Object> dslPropertyValueExtractor) {
        this.traverseValues(body, dslPropertyValueExtractor, object -> {
            if (object instanceof ExecutionProperty) {
                throw new UnsupportedOperationException("We can't convert a contract that has execution property");
            }
            return object;
        });
    }

    private void traverseValues(Object value, Function<DslProperty<?>, Object> dslPropertyValueExtractor, Function<Object, Object> function) {
        if (value instanceof DslProperty) {
            this.traverseValues(dslPropertyValueExtractor.apply((DslProperty)value), dslPropertyValueExtractor, function);
        } else if (value instanceof Map) {
            ((Map)value).values().forEach(v -> this.traverseValues(v, dslPropertyValueExtractor, function));
        } else if (value instanceof Collection) {
            ((Collection)value).forEach(v -> this.traverseValues(v, dslPropertyValueExtractor, function));
        } else {
            function.apply(value);
        }
    }

    private PactDslRequestWithPath createPactDslRequestWithPath(Contract contract, PactDslResponse pactDslResponse) {
        PactDslRequestWithPath pactDslRequest = this.getPactDslRequest(contract, this.getPactDslWithStateFunction(pactDslResponse), this.getPactDslRequestWithPathBiFunction(pactDslResponse));
        Request request = contract.getRequest();
        PactDslRequestWithPath finalPactDslRequest = pactDslRequest;
        if (request.getHeaders() != null) {
            request.getHeaders().getEntries().forEach(h -> this.processHeader(finalPactDslRequest, (Header)h));
        }
        if (request.getCookies() != null) {
            pactDslRequest = this.processCookies(finalPactDslRequest, request.getCookies());
        }
        if (request.getBody() != null) {
            DslPart pactRequestBody = BodyConverter.toPactBody(request.getBody(), DslProperty::getClientValue);
            if (request.getBodyMatchers() != null) {
                pactRequestBody.setMatchers(MatchingRulesConverter.matchingRulesForBody(request.getBodyMatchers()));
            }
            pactRequestBody.setGenerators(ValueGeneratorConverter.extract(request.getBody(), DslProperty::getClientValue));
            pactDslRequest = pactDslRequest.body(pactRequestBody);
        }
        return pactDslRequest;
    }

    private Function<PactMetaData.ProviderStateMetadata, PactDslWithState> getPactDslWithStateFunction(PactDslResponse pactDslResponse) {
        return stateMetadata -> pactDslResponse.given(stateMetadata.getName(), stateMetadata.getParams());
    }

    private BiFunction<String, Request, PactDslRequestWithPath> getPactDslRequestWithPathBiFunction(PactDslResponse pactDslResponse) {
        return (description, request) -> pactDslResponse.uponReceiving(description).path(this.url((Request)request)).method(request.getMethod().getServerValue().toString());
    }

    private PactDslRequestWithPath createPactDslRequestWithPath(Contract contract, PactDslWithProvider pactDslWithProvider) {
        PactDslRequestWithPath pactDslRequest = this.getPactDslRequest(contract, this.getPactDslWithStateFunction(pactDslWithProvider), this.getPactDslRequestWithPathBiFunction(pactDslWithProvider));
        Request request = contract.getRequest();
        PactDslRequestWithPath finalPactDslRequest = pactDslRequest;
        if (request.getHeaders() != null) {
            request.getHeaders().getEntries().forEach(h -> this.processHeader(finalPactDslRequest, (Header)h));
        }
        if (request.getBody() != null) {
            DslPart pactRequestBody = BodyConverter.toPactBody(request.getBody(), DslProperty::getServerValue);
            if (request.getBodyMatchers() != null) {
                pactRequestBody.setMatchers(MatchingRulesConverter.matchingRulesForBody(request.getBodyMatchers()));
            }
            pactRequestBody.setGenerators(ValueGeneratorConverter.extract(request.getBody(), DslProperty::getClientValue));
            pactDslRequest = pactDslRequest.body(pactRequestBody);
        }
        return pactDslRequest;
    }

    private Function<PactMetaData.ProviderStateMetadata, PactDslWithState> getPactDslWithStateFunction(PactDslWithProvider pactDslWithProvider) {
        return stateMetadata -> pactDslWithProvider.given(stateMetadata.getName(), stateMetadata.getParams());
    }

    private BiFunction<String, Request, PactDslRequestWithPath> getPactDslRequestWithPathBiFunction(PactDslWithProvider pactDslWithProvider) {
        return (description, request) -> pactDslWithProvider.uponReceiving(description).path(this.url((Request)request)).method(request.getMethod().getServerValue().toString());
    }

    private PactDslRequestWithPath getPactDslRequest(Contract contract, Function<PactMetaData.ProviderStateMetadata, PactDslWithState> pactDslWithStateFunction, BiFunction<String, Request, PactDslRequestWithPath> pactDslRequestWithPathBiFunction) {
        PactDslWithState pactDslWithState = this.getPactDslWithState(contract, pactDslWithStateFunction);
        String description = StringUtils.isNotBlank((CharSequence)contract.getDescription()) ? contract.getDescription() : "";
        Request request = contract.getRequest();
        PactDslRequestWithPath pactDslRequest = pactDslWithState != null ? pactDslWithState.uponReceiving(description).path(this.url(request)).method(request.getMethod().getServerValue().toString()) : pactDslRequestWithPathBiFunction.apply(description, request);
        String query = this.query(request);
        if (StringUtils.isNotBlank((CharSequence)query)) {
            pactDslRequest = pactDslRequest.encodedQuery(query);
        }
        return pactDslRequest;
    }

    private PactDslWithState getPactDslWithState(Contract contract, Function<PactMetaData.ProviderStateMetadata, PactDslWithState> pactDslWithStateFunction) {
        PactMetaData metadata;
        PactDslWithState pactDslWithState = null;
        if (contract.getMetadata().containsKey("pact") && !(metadata = PactMetaData.fromMetadata(contract.getMetadata())).getProviderStates().isEmpty()) {
            for (PactMetaData.ProviderStateMetadata stateMetadata : metadata.getProviderStates()) {
                if (pactDslWithState == null) {
                    pactDslWithState = pactDslWithStateFunction.apply(stateMetadata);
                    continue;
                }
                pactDslWithState = pactDslWithState.given(stateMetadata.getName(), stateMetadata.getParams());
            }
        }
        return pactDslWithState;
    }

    private String url(Request request) {
        if (request.getUrlPath() != null) {
            return request.getUrlPath().getServerValue().toString();
        }
        if (request.getUrl() != null) {
            return request.getUrl().getServerValue().toString();
        }
        throw new IllegalStateException("No url provided");
    }

    private String query(Request request) {
        StringBuilder query = new StringBuilder();
        QueryParameters params = this.queryParams(request);
        if (params != null) {
            AtomicInteger index = new AtomicInteger();
            params.getParameters().forEach(p -> {
                query.append(p.getName()).append('=').append(p.getServerValue());
                if (index.incrementAndGet() < params.getParameters().size()) {
                    query.append('&');
                }
            });
        }
        return query.toString();
    }

    private QueryParameters queryParams(Request request) {
        if (request.getUrlPath() != null) {
            return request.getUrlPath().getQueryParameters();
        }
        if (request.getUrl() != null) {
            return request.getUrl().getQueryParameters();
        }
        throw new IllegalStateException("No url provided");
    }

    private PactDslRequestWithPath processHeader(PactDslRequestWithPath pactDslRequest, Header header) {
        if (header.isSingleValue()) {
            String value = this.getDslPropertyServerValue(header).toString();
            return pactDslRequest.headers(header.getName(), value, new String[0]);
        }
        String regex = this.getDslPropertyClientValue(header).toString();
        String example = this.getDslPropertyServerValue(header).toString();
        return pactDslRequest.matchHeader(header.getName(), regex, example);
    }

    private String stubSideCookieExample(Cookies cookies) {
        return cookies.asStubSideMap().entrySet().stream().map(Object::toString).collect(Collectors.joining(";"));
    }

    private Object getDslPropertyClientValue(Object o) {
        Object value = o;
        if (value instanceof DslProperty) {
            value = this.getDslPropertyClientValue(((DslProperty)value).getClientValue());
        }
        return value;
    }

    private Object getDslPropertyServerValue(Object o) {
        Object value = o;
        if (value instanceof DslProperty) {
            value = this.getDslPropertyServerValue(((DslProperty)value).getServerValue());
        }
        return value;
    }

    private PactDslRequestWithPath processCookies(PactDslRequestWithPath pactDslRequest, Cookies cookies) {
        Map stubSideCookies = cookies.asStubSideMap();
        Collection regexProperties = stubSideCookies.values().stream().filter(r -> r instanceof Pattern || r instanceof RegexProperty).map(RegexProperty::new).collect(Collectors.toList());
        if (!regexProperties.isEmpty()) {
            String regex = regexProperties.stream().map(RegexProperty::pattern).collect(Collectors.joining("|"));
            return pactDslRequest.matchHeader("Cookie", regex, this.testSideCookieExample(cookies));
        }
        return pactDslRequest.headers("Cookie", this.testSideCookieExample(cookies), new String[0]);
    }

    private String testSideCookieExample(Cookies cookies) {
        return cookies.asTestSideMap().entrySet().stream().map(Object::toString).collect(Collectors.joining(";"));
    }

    private PactDslResponse createPactDslResponse(Contract contract, PactDslRequestWithPath pactDslRequest) {
        PactDslResponse pactDslResponse;
        Response response = contract.getResponse();
        PactDslResponse finalPactDslResponse = pactDslResponse = pactDslRequest.willRespondWith().status(((Integer)response.getStatus().getClientValue()).intValue());
        if (response.getHeaders() != null) {
            response.getHeaders().getEntries().forEach(h -> this.processHeader(finalPactDslResponse, (Header)h));
        }
        if (response.getCookies() != null) {
            pactDslResponse = this.processCookies(pactDslResponse, response.getCookies());
        }
        if (response.getBody() != null) {
            DslPart pactResponseBody = BodyConverter.toPactBody(response.getBody(), DslProperty::getClientValue);
            if (response.getBodyMatchers() != null) {
                pactResponseBody.setMatchers(MatchingRulesConverter.matchingRulesForBody((BodyMatchers)response.getBodyMatchers()));
            }
            pactResponseBody.setGenerators(ValueGeneratorConverter.extract(response.getBody(), DslProperty::getServerValue));
            pactDslResponse = pactDslResponse.body(pactResponseBody);
        }
        return pactDslResponse;
    }

    private PactDslResponse processHeader(PactDslResponse pactDslResponse, Header header) {
        if (header.isSingleValue()) {
            String value = this.getDslPropertyClientValue(header).toString();
            return pactDslResponse.headers(Collections.singletonMap(header.getName(), value));
        }
        String regex = this.getDslPropertyServerValue(header).toString();
        String example = this.getDslPropertyClientValue(header).toString();
        return pactDslResponse.matchHeader(header.getName(), regex, example);
    }

    private PactDslResponse processCookies(PactDslResponse pactDslResponse, Cookies cookies) {
        Map testSideCookies = cookies.asTestSideMap();
        Collection regexProperties = testSideCookies.values().stream().filter(p -> p instanceof Pattern || p instanceof RegexProperty).map(RegexProperty::new).collect(Collectors.toList());
        if (!regexProperties.isEmpty()) {
            String regex = regexProperties.stream().map(RegexProperty::pattern).collect(Collectors.joining("|"));
            return pactDslResponse.matchHeader("Cookie", regex, this.stubSideCookieExample(cookies));
        }
        return pactDslResponse.headers(Collections.singletonMap("Cookie", this.stubSideCookieExample(cookies)));
    }
}

