/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.refresh;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.Lifecycle;

public class RefreshScopeLifecycle
implements Lifecycle {
    private static final Log LOG = LogFactory.getLog(RefreshScopeLifecycle.class);
    private final ContextRefresher contextRefresher;
    private final Object lifecycleMonitor = new Object();
    private volatile boolean running = true;

    public RefreshScopeLifecycle(ContextRefresher contextRefresher) {
        this.contextRefresher = contextRefresher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"Refreshing context on restart.");
                }
                Set<String> keys = this.contextRefresher.refresh();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Refreshed keys: " + keys));
                }
                this.running = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                this.running = false;
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }
}

