/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.util;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class TestPropertyValues {
    private static final TestPropertyValues EMPTY = new TestPropertyValues(Collections.emptyMap());
    private final Map<String, @Nullable Object> properties;

    private TestPropertyValues(Map<String, @Nullable Object> properties) {
        this.properties = Collections.unmodifiableMap(properties);
    }

    public TestPropertyValues and(String ... pairs) {
        return this.and(Arrays.stream(pairs), Pair::parse);
    }

    public TestPropertyValues and(@Nullable Iterable<String> pairs) {
        return pairs != null ? this.and(StreamSupport.stream(pairs.spliterator(), false)) : this;
    }

    public TestPropertyValues and(@Nullable Stream<String> pairs) {
        return pairs != null ? this.and(pairs, Pair::parse) : this;
    }

    public TestPropertyValues and(@Nullable Map<String, String> map) {
        return map != null ? this.and(map.entrySet().stream(), Pair::fromMapEntry) : this;
    }

    public <T> TestPropertyValues and(@Nullable Stream<T> stream, Function<T, @Nullable Pair> mapper) {
        if (stream == null) {
            return this;
        }
        LinkedHashMap<String, @Nullable Object> properties = new LinkedHashMap<String, Object>(this.properties);
        stream.map(mapper).filter(Objects::nonNull).forEach(pair -> pair.addTo(properties));
        return new TestPropertyValues(properties);
    }

    public void applyTo(ConfigurableApplicationContext context) {
        this.applyTo(context.getEnvironment());
    }

    public void applyTo(ConfigurableEnvironment environment) {
        this.applyTo(environment, Type.MAP);
    }

    public void applyTo(ConfigurableEnvironment environment, Type type) {
        this.applyTo(environment, type, type.applySuffix("test"));
    }

    public void applyTo(ConfigurableEnvironment environment, Type type, String name) {
        Assert.notNull((Object)environment, (String)"'environment' must not be null");
        Assert.notNull((Object)((Object)type), (String)"'type' must not be null");
        Assert.notNull((Object)name, (String)"'name' must not be null");
        MutablePropertySources sources = environment.getPropertySources();
        this.addToSources(sources, type, name);
        ConfigurationPropertySources.attach((Environment)environment);
    }

    public void applyToSystemProperties(Runnable action) {
        this.applyToSystemProperties(() -> {
            action.run();
            return new Object();
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T applyToSystemProperties(Callable<T> call) {
        try (SystemPropertiesHandler handler = new SystemPropertiesHandler();){
            T t = call.call();
            return t;
        }
        catch (Exception ex) {
            this.rethrow(ex);
            throw new IllegalStateException("Original cause not rethrown", ex);
        }
    }

    private <E extends Throwable> void rethrow(Throwable e) throws E {
        throw e;
    }

    private void addToSources(MutablePropertySources sources, Type type, String name) {
        PropertySource propertySource = sources.get(name);
        if (propertySource != null && propertySource.getClass() == type.getSourceClass()) {
            ((Map)propertySource.getSource()).putAll(this.properties);
            return;
        }
        LinkedHashMap<String, Object> source = new LinkedHashMap<String, Object>(this.properties);
        sources.addFirst((PropertySource)(type.equals((Object)Type.MAP) ? new MapPropertySource(name, source) : new SystemEnvironmentPropertySource(name, source)));
    }

    public static TestPropertyValues of(String ... pairs) {
        return TestPropertyValues.of(Stream.of(pairs));
    }

    public static TestPropertyValues of(@Nullable Iterable<String> pairs) {
        return pairs != null ? TestPropertyValues.of(StreamSupport.stream(pairs.spliterator(), false)) : TestPropertyValues.empty();
    }

    public static TestPropertyValues of(@Nullable Stream<String> pairs) {
        return pairs != null ? TestPropertyValues.of(pairs, Pair::parse) : TestPropertyValues.empty();
    }

    public static TestPropertyValues of(@Nullable Map<String, String> map) {
        return map != null ? TestPropertyValues.of(map.entrySet().stream(), Pair::fromMapEntry) : TestPropertyValues.empty();
    }

    public static <T> TestPropertyValues of(@Nullable Stream<T> stream, Function<T, @Nullable Pair> mapper) {
        return stream != null ? TestPropertyValues.empty().and(stream, mapper) : TestPropertyValues.empty();
    }

    public static TestPropertyValues empty() {
        return EMPTY;
    }

    public static enum Type {
        SYSTEM_ENVIRONMENT(SystemEnvironmentPropertySource.class, "systemEnvironment"),
        MAP(MapPropertySource.class, null);

        private final Class<? extends MapPropertySource> sourceClass;
        private final @Nullable String suffix;

        private Type(Class<? extends MapPropertySource> sourceClass, String suffix) {
            this.sourceClass = sourceClass;
            this.suffix = suffix;
        }

        public Class<? extends MapPropertySource> getSourceClass() {
            return this.sourceClass;
        }

        protected String applySuffix(String name) {
            return this.suffix != null ? name + "-" + this.suffix : name;
        }
    }

    private class SystemPropertiesHandler
    implements Closeable {
        private final Map<String, String> previous;

        SystemPropertiesHandler() {
            this.previous = this.apply(TestPropertyValues.this.properties);
        }

        private Map<String, String> apply(Map<String, ?> properties) {
            LinkedHashMap<String, String> previous = new LinkedHashMap<String, String>();
            properties.forEach((name, value) -> previous.put((String)name, this.setOrClear((String)name, (String)value)));
            return previous;
        }

        @Override
        public void close() {
            this.previous.forEach(this::setOrClear);
        }

        private String setOrClear(String name, String value) {
            Assert.notNull((Object)name, (String)"'name' must not be null");
            if (!StringUtils.hasLength((String)value)) {
                return (String)System.getProperties().remove(name);
            }
            return (String)System.getProperties().setProperty(name, value);
        }
    }

    public static final class Pair {
        private final String name;
        private final @Nullable String value;

        private Pair(String name, @Nullable String value) {
            Assert.hasLength((String)name, (String)"'name' must not be empty");
            this.name = name;
            this.value = value;
        }

        public void addTo(Map<String, @Nullable Object> properties) {
            properties.put(this.name, this.value);
        }

        public static @Nullable Pair parse(String pair) {
            int index = Pair.getSeparatorIndex(pair);
            String name = index > 0 ? pair.substring(0, index) : pair;
            String value = index > 0 ? pair.substring(index + 1) : "";
            return Pair.of(name.trim(), value.trim());
        }

        private static int getSeparatorIndex(String pair) {
            int colonIndex = pair.indexOf(58);
            int equalIndex = pair.indexOf(61);
            if (colonIndex == -1) {
                return equalIndex;
            }
            if (equalIndex == -1) {
                return colonIndex;
            }
            return Math.min(colonIndex, equalIndex);
        }

        @Contract(value="!null -> !null")
        public static @Nullable Pair fromMapEntry(@Nullable Map.Entry<String, String> entry) {
            return entry != null ? Pair.of(entry.getKey(), entry.getValue()) : null;
        }

        public static @Nullable Pair of(@Nullable String name, @Nullable String value) {
            if (StringUtils.hasLength((String)name)) {
                return new Pair(name, value);
            }
            return null;
        }
    }
}

