/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.restclient.autoconfigure.service;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.client.autoconfigure.AbstractHttpRequestFactoryProperties;
import org.springframework.boot.http.client.autoconfigure.ClientHttpRequestFactories;
import org.springframework.boot.restclient.autoconfigure.PropertiesRestClientCustomizer;
import org.springframework.boot.restclient.autoconfigure.service.HttpClientServiceProperties;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.ApiVersionFormatter;
import org.springframework.web.client.ApiVersionInserter;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.support.RestClientHttpServiceGroupConfigurer;
import org.springframework.web.service.registry.HttpServiceGroup;
import org.springframework.web.service.registry.HttpServiceGroupConfigurer;

class RestClientPropertiesHttpServiceGroupConfigurer
implements RestClientHttpServiceGroupConfigurer {
    private final ClassLoader classLoader;
    private final ObjectProvider<SslBundles> sslBundles;
    private final HttpClientServiceProperties serviceProperties;
    private final ObjectProvider<ClientHttpRequestFactoryBuilder<?>> requestFactoryBuilder;
    private final ObjectProvider<ClientHttpRequestFactorySettings> requestFactorySettings;
    private final @Nullable ApiVersionInserter apiVersionInserter;
    private final @Nullable ApiVersionFormatter apiVersionFormatter;

    RestClientPropertiesHttpServiceGroupConfigurer(ClassLoader classLoader, ObjectProvider<SslBundles> sslBundles, HttpClientServiceProperties serviceProperties, ObjectProvider<ClientHttpRequestFactoryBuilder<?>> requestFactoryBuilder, ObjectProvider<ClientHttpRequestFactorySettings> requestFactorySettings, ObjectProvider<ApiVersionInserter> apiVersionInserter, ObjectProvider<ApiVersionFormatter> apiVersionFormatter) {
        this.classLoader = classLoader;
        this.sslBundles = sslBundles;
        this.serviceProperties = serviceProperties;
        this.requestFactoryBuilder = requestFactoryBuilder;
        this.requestFactorySettings = requestFactorySettings;
        this.apiVersionInserter = (ApiVersionInserter)apiVersionInserter.getIfAvailable();
        this.apiVersionFormatter = (ApiVersionFormatter)apiVersionFormatter.getIfAvailable();
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void configureGroups(HttpServiceGroupConfigurer.Groups<RestClient.Builder> groups) {
        groups.forEachClient(this::configureClient);
    }

    private void configureClient(HttpServiceGroup group, RestClient.Builder builder) {
        HttpClientServiceProperties.Group groupProperties = this.serviceProperties.getGroup().get(group.name());
        builder.requestFactory(this.getRequestFactory(groupProperties));
        this.getPropertiesRestClientCustomizer(groupProperties).customize(builder);
    }

    private PropertiesRestClientCustomizer getPropertiesRestClientCustomizer(@Nullable HttpClientServiceProperties.Group groupProperties) {
        return new PropertiesRestClientCustomizer(this.apiVersionInserter, this.apiVersionFormatter, groupProperties, this.serviceProperties);
    }

    private ClientHttpRequestFactory getRequestFactory(@Nullable HttpClientServiceProperties.Group groupProperties) {
        ClientHttpRequestFactories factories = new ClientHttpRequestFactories((ClientHttpRequestFactoryBuilder)this.requestFactoryBuilder.getIfAvailable(), (ClientHttpRequestFactorySettings)this.requestFactorySettings.getIfAvailable(), this.sslBundles, new AbstractHttpRequestFactoryProperties[]{groupProperties, this.serviceProperties});
        ClientHttpRequestFactoryBuilder builder = factories.builder(this.classLoader);
        ClientHttpRequestFactorySettings settings = factories.settings();
        return builder.build(settings);
    }
}

