/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jooq.autoconfigure;

import org.jooq.Transaction;
import org.jooq.TransactionContext;
import org.jooq.TransactionProvider;
import org.springframework.boot.jooq.autoconfigure.SpringTransaction;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;

public class SpringTransactionProvider
implements TransactionProvider {
    private final PlatformTransactionManager transactionManager;

    public SpringTransactionProvider(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void begin(TransactionContext context) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition(6);
        TransactionStatus status = this.transactionManager.getTransaction((TransactionDefinition)definition);
        context.transaction((Transaction)new SpringTransaction(status));
    }

    public void commit(TransactionContext ctx) {
        this.transactionManager.commit(this.getTransactionStatus(ctx));
    }

    public void rollback(TransactionContext ctx) {
        this.transactionManager.rollback(this.getTransactionStatus(ctx));
    }

    private TransactionStatus getTransactionStatus(TransactionContext ctx) {
        SpringTransaction transaction = (SpringTransaction)ctx.transaction();
        Assert.state((transaction != null ? 1 : 0) != 0, (String)"'transaction' must not be null");
        return transaction.getTxStatus();
    }
}

