/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.reactive;

import java.time.Duration;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.http.client.HttpRedirects;
import org.springframework.boot.ssl.SslBundle;

public record ClientHttpConnectorSettings(HttpRedirects redirects, @Nullable Duration connectTimeout, @Nullable Duration readTimeout, @Nullable SslBundle sslBundle) {
    private static final ClientHttpConnectorSettings defaults = new ClientHttpConnectorSettings(null, null, null, null);

    public ClientHttpConnectorSettings(@Nullable HttpRedirects redirects, @Nullable Duration connectTimeout, @Nullable Duration readTimeout, @Nullable SslBundle sslBundle) {
        this.redirects = redirects != null ? redirects : HttpRedirects.FOLLOW_WHEN_POSSIBLE;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.sslBundle = sslBundle;
    }

    public ClientHttpConnectorSettings withConnectTimeout(@Nullable Duration connectTimeout) {
        return new ClientHttpConnectorSettings(this.redirects, connectTimeout, this.readTimeout, this.sslBundle);
    }

    public ClientHttpConnectorSettings withReadTimeout(@Nullable Duration readTimeout) {
        return new ClientHttpConnectorSettings(this.redirects, this.connectTimeout, readTimeout, this.sslBundle);
    }

    public ClientHttpConnectorSettings withTimeouts(@Nullable Duration connectTimeout, @Nullable Duration readTimeout) {
        return new ClientHttpConnectorSettings(this.redirects, connectTimeout, readTimeout, this.sslBundle);
    }

    public ClientHttpConnectorSettings withSslBundle(@Nullable SslBundle sslBundle) {
        return new ClientHttpConnectorSettings(this.redirects, this.connectTimeout, this.readTimeout, sslBundle);
    }

    public ClientHttpConnectorSettings withRedirects(@Nullable HttpRedirects redirects) {
        return new ClientHttpConnectorSettings(redirects, this.connectTimeout, this.readTimeout, this.sslBundle);
    }

    public static ClientHttpConnectorSettings ofSslBundle(@Nullable SslBundle sslBundle) {
        return ClientHttpConnectorSettings.defaults().withSslBundle(sslBundle);
    }

    public static ClientHttpConnectorSettings defaults() {
        return defaults;
    }
}

