/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.util.GradleVersion;
import org.springframework.boot.gradle.plugin.JarTypeFileSpec;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;
import org.springframework.boot.gradle.plugin.ResolveMainClassName;
import org.springframework.boot.gradle.plugin.SinglePublishedArtifact;
import org.springframework.boot.gradle.tasks.bundling.BootBuildImage;
import org.springframework.boot.gradle.tasks.bundling.BootJar;
import org.springframework.boot.gradle.tasks.run.BootRun;
import org.springframework.util.StringUtils;

final class JavaPluginAction
implements PluginApplicationAction {
    private static final String PARAMETERS_COMPILER_ARG = "-parameters";
    private final SinglePublishedArtifact singlePublishedArtifact;

    JavaPluginAction(SinglePublishedArtifact singlePublishedArtifact) {
        this.singlePublishedArtifact = singlePublishedArtifact;
    }

    @Override
    public Class<? extends Plugin<? extends Project>> getPluginClass() {
        return JavaPlugin.class;
    }

    public void execute(Project project) {
        this.classifyJarTask(project);
        this.configureBuildTask(project);
        this.configureDevelopmentOnlyConfiguration(project);
        TaskProvider<BootJar> bootJar = this.configureBootJarTask(project);
        this.configureBootBuildImageTask(project, bootJar);
        this.configureArtifactPublication(bootJar);
        this.configureBootRunTask(project);
        this.configureUtf8Encoding(project);
        this.configureParametersCompilerArg(project);
        this.configureAdditionalMetadataLocations(project);
    }

    private void classifyJarTask(Project project) {
        project.getTasks().named("jar", Jar.class).configure(task -> task.getArchiveClassifier().convention((Object)"plain"));
    }

    private void configureBuildTask(Project project) {
        project.getTasks().named("assemble").configure(task -> task.dependsOn(new Object[]{this.singlePublishedArtifact}));
    }

    private TaskProvider<BootJar> configureBootJarTask(Project project) {
        SourceSet mainSourceSet = (SourceSet)this.javaPluginConvention(project).getSourceSets().getByName("main");
        Configuration developmentOnly = project.getConfigurations().getByName("developmentOnly");
        Configuration productionRuntimeClasspath = project.getConfigurations().getByName("productionRuntimeClasspath");
        FileCollection classpath = mainSourceSet.getRuntimeClasspath().minus(developmentOnly.minus((FileCollection)productionRuntimeClasspath)).filter((Spec)new JarTypeFileSpec());
        TaskProvider<ResolveMainClassName> resolveMainClassName = ResolveMainClassName.registerForTask("bootJar", project, classpath);
        return project.getTasks().register("bootJar", BootJar.class, bootJar -> {
            bootJar.setDescription("Assembles an executable jar archive containing the main classes and their dependencies.");
            bootJar.setGroup("build");
            bootJar.classpath(classpath);
            Provider manifestStartClass = project.provider(() -> (String)bootJar.getManifest().getAttributes().get((Object)"Start-Class"));
            bootJar.getMainClass().convention(resolveMainClassName.flatMap(resolver -> manifestStartClass.isPresent() ? manifestStartClass : ((ResolveMainClassName)((Object)((Object)((Object)resolveMainClassName.get())))).readMainClassName()));
        });
    }

    private void configureBootBuildImageTask(Project project, TaskProvider<BootJar> bootJar) {
        project.getTasks().register("bootBuildImage", BootBuildImage.class, buildImage -> {
            buildImage.setDescription("Builds an OCI image of the application using the output of the bootJar task");
            buildImage.setGroup("build");
            buildImage.getArchiveFile().set(((BootJar)bootJar.get()).getArchiveFile());
            buildImage.getTargetJavaVersion().set(project.provider(() -> this.javaPluginConvention(project).getTargetCompatibility()));
        });
    }

    private void configureArtifactPublication(TaskProvider<BootJar> bootJar) {
        LazyPublishArtifact artifact = new LazyPublishArtifact(bootJar);
        this.singlePublishedArtifact.addCandidate((PublishArtifact)artifact);
    }

    private void configureBootRunTask(Project project) {
        FileCollection classpath = ((SourceSet)this.javaPluginConvention(project).getSourceSets().findByName("main")).getRuntimeClasspath().filter((Spec)new JarTypeFileSpec());
        TaskProvider<ResolveMainClassName> resolveProvider = ResolveMainClassName.registerForTask("bootRun", project, classpath);
        project.getTasks().register("bootRun", BootRun.class, run -> {
            run.setDescription("Runs this project as a Spring Boot application.");
            run.setGroup("application");
            run.classpath(new Object[]{classpath});
            run.getConventionMapping().map("jvmArgs", () -> {
                if (project.hasProperty("applicationDefaultJvmArgs")) {
                    return project.property("applicationDefaultJvmArgs");
                }
                return Collections.emptyList();
            });
            run.getMainClass().convention(resolveProvider.flatMap(ResolveMainClassName::readMainClassName));
            this.configureToolchainConvention(project, (BootRun)((Object)run));
        });
    }

    private void configureToolchainConvention(Project project, BootRun run) {
        if (this.isGradle67OrLater()) {
            JavaToolchainSpec toolchain = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getToolchain();
            JavaToolchainService toolchainService = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
            run.getJavaLauncher().convention(toolchainService.launcherFor(toolchain));
        }
    }

    private boolean isGradle67OrLater() {
        return GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"6.7")) >= 0;
    }

    private JavaPluginConvention javaPluginConvention(Project project) {
        return (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
    }

    private void configureUtf8Encoding(Project project) {
        project.afterEvaluate(evaluated -> evaluated.getTasks().withType(JavaCompile.class, compile -> {
            if (compile.getOptions().getEncoding() == null) {
                compile.getOptions().setEncoding("UTF-8");
            }
        }));
    }

    private void configureParametersCompilerArg(Project project) {
        project.getTasks().withType(JavaCompile.class, compile -> {
            List compilerArgs = compile.getOptions().getCompilerArgs();
            if (!compilerArgs.contains(PARAMETERS_COMPILER_ARG)) {
                compilerArgs.add(PARAMETERS_COMPILER_ARG);
            }
        });
    }

    private void configureAdditionalMetadataLocations(Project project) {
        project.afterEvaluate(evaluated -> evaluated.getTasks().withType(JavaCompile.class, this::configureAdditionalMetadataLocations));
    }

    private void configureAdditionalMetadataLocations(JavaCompile compile) {
        SourceSetContainer sourceSets = ((JavaPluginConvention)compile.getProject().getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        sourceSets.stream().filter(candidate -> candidate.getCompileJavaTaskName().equals(compile.getName())).map(match -> match.getResources().getSrcDirs()).findFirst().ifPresent(locations -> compile.doFirst((Action)new AdditionalMetadataLocationsConfigurer((Set)locations)));
    }

    private void configureDevelopmentOnlyConfiguration(Project project) {
        Configuration developmentOnly = (Configuration)project.getConfigurations().create("developmentOnly");
        developmentOnly.setDescription("Configuration for development-only dependencies such as Spring Boot's DevTools.");
        Configuration runtimeClasspath = project.getConfigurations().getByName("runtimeClasspath");
        Configuration productionRuntimeClasspath = (Configuration)project.getConfigurations().create("productionRuntimeClasspath");
        AttributeContainer attributes = productionRuntimeClasspath.getAttributes();
        ObjectFactory objectFactory = project.getObjects();
        attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "java-runtime"));
        attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)objectFactory.named(Bundling.class, "external"));
        attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)objectFactory.named(LibraryElements.class, "jar"));
        productionRuntimeClasspath.setVisible(false);
        productionRuntimeClasspath.setExtendsFrom((Iterable)runtimeClasspath.getExtendsFrom());
        productionRuntimeClasspath.setCanBeResolved(runtimeClasspath.isCanBeResolved());
        productionRuntimeClasspath.setCanBeConsumed(runtimeClasspath.isCanBeConsumed());
        runtimeClasspath.extendsFrom(new Configuration[]{developmentOnly});
    }

    private static final class AdditionalMetadataLocationsConfigurer
    implements Action<Task> {
        private final Set<File> locations;

        private AdditionalMetadataLocationsConfigurer(Set<File> locations) {
            this.locations = locations;
        }

        public void execute(Task task) {
            if (!(task instanceof JavaCompile)) {
                return;
            }
            JavaCompile compile = (JavaCompile)task;
            if (this.hasConfigurationProcessorOnClasspath(compile)) {
                this.configureAdditionalMetadataLocations(compile);
            }
        }

        private boolean hasConfigurationProcessorOnClasspath(JavaCompile compile) {
            Set files = compile.getOptions().getAnnotationProcessorPath() != null ? compile.getOptions().getAnnotationProcessorPath().getFiles() : compile.getClasspath().getFiles();
            return files.stream().map(File::getName).anyMatch(name -> name.startsWith("spring-boot-configuration-processor"));
        }

        private void configureAdditionalMetadataLocations(JavaCompile compile) {
            compile.getOptions().getCompilerArgs().add("-Aorg.springframework.boot.configurationprocessor.additionalMetadataLocations=" + StringUtils.collectionToCommaDelimitedString(this.locations));
        }
    }
}

