/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.classpath;

import java.net.URL;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.devtools.classpath.ClassPathDirectories;
import org.springframework.boot.devtools.classpath.ClassPathFileChangeListener;
import org.springframework.boot.devtools.classpath.ClassPathRestartStrategy;
import org.springframework.boot.devtools.filewatch.FileSystemWatcher;
import org.springframework.boot.devtools.filewatch.FileSystemWatcherFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.Assert;

public class ClassPathFileSystemWatcher
implements InitializingBean,
DisposableBean,
ApplicationContextAware {
    private final FileSystemWatcher fileSystemWatcher;
    private ClassPathRestartStrategy restartStrategy;
    private ApplicationContext applicationContext;
    private boolean stopWatcherOnRestart;

    public ClassPathFileSystemWatcher(FileSystemWatcherFactory fileSystemWatcherFactory, ClassPathRestartStrategy restartStrategy, URL[] urls) {
        Assert.notNull((Object)fileSystemWatcherFactory, (String)"FileSystemWatcherFactory must not be null");
        Assert.notNull((Object)urls, (String)"Urls must not be null");
        this.fileSystemWatcher = fileSystemWatcherFactory.getFileSystemWatcher();
        this.restartStrategy = restartStrategy;
        this.fileSystemWatcher.addSourceDirectories(new ClassPathDirectories(urls));
    }

    public void setStopWatcherOnRestart(boolean stopWatcherOnRestart) {
        this.stopWatcherOnRestart = stopWatcherOnRestart;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.restartStrategy != null) {
            FileSystemWatcher watcherToStop = null;
            if (this.stopWatcherOnRestart) {
                watcherToStop = this.fileSystemWatcher;
            }
            this.fileSystemWatcher.addListener(new ClassPathFileChangeListener((ApplicationEventPublisher)this.applicationContext, this.restartStrategy, watcherToStop));
        }
        this.fileSystemWatcher.start();
    }

    public void destroy() throws Exception {
        this.fileSystemWatcher.stop();
    }
}

