/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.activemq.testcontainers;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.activemq.autoconfigure.ActiveMQConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.Container;

class ActiveMQContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<Container<?>, ActiveMQConnectionDetails> {
    ActiveMQContainerConnectionDetailsFactory() {
        super("symptoma/activemq", new String[0]);
    }

    protected ActiveMQConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
        return new ActiveMQContainerConnectionDetails(source);
    }

    private static final class ActiveMQContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<Container<?>>
    implements ActiveMQConnectionDetails {
        private ActiveMQContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
            super(source);
        }

        @Override
        public String getBrokerUrl() {
            return "tcp://" + this.getContainer().getHost() + ":" + this.getContainer().getFirstMappedPort();
        }

        @Override
        public @Nullable String getUser() {
            return (String)this.getContainer().getEnvMap().get("ACTIVEMQ_USERNAME");
        }

        @Override
        public @Nullable String getPassword() {
            return (String)this.getContainer().getEnvMap().get("ACTIVEMQ_PASSWORD");
        }
    }
}

