/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.support;

import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.ItemReader;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class MessageChannelItemReader<T>
implements ItemReader<T> {
    private final MessagingTemplate messagingTemplate;
    private final Class<T> targetType;
    private MessageChannel messageChannel;

    public MessageChannelItemReader(MessagingTemplate messagingTemplate, Class<T> targetType) {
        this.targetType = targetType;
        this.messagingTemplate = messagingTemplate;
        MessageChannel defaultDestination = (MessageChannel)messagingTemplate.getDefaultDestination();
        Assert.notNull((Object)defaultDestination, (String)"MessagingTemplate must have a default destination configured");
        this.messageChannel = defaultDestination;
    }

    public MessageChannelItemReader(MessagingTemplate messagingTemplate, MessageChannel messageChannel, Class<T> targetType) {
        this.messagingTemplate = messagingTemplate;
        this.messageChannel = messageChannel;
        this.targetType = targetType;
    }

    public void setMessageChannel(MessageChannel messageChannel) {
        this.messageChannel = messageChannel;
    }

    public @Nullable T read() throws Exception {
        return (T)this.messagingTemplate.receiveAndConvert((Object)this.messageChannel, this.targetType);
    }
}

