/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.async;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamWriter;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class AsyncItemWriter<T>
implements ItemStreamWriter<Future<T>>,
InitializingBean {
    private static final Log logger = LogFactory.getLog(AsyncItemWriter.class);
    private ItemWriter<T> delegate;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.delegate, (String)"A delegate ItemWriter must be provided.");
    }

    public void setDelegate(ItemWriter<T> delegate) {
        this.delegate = delegate;
    }

    public void write(List<? extends Future<T>> items) throws Exception {
        ArrayList<T> list = new ArrayList<T>();
        for (Future<T> future : items) {
            try {
                T item = future.get();
                if (item == null) continue;
                list.add(future.get());
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof Exception) {
                    logger.debug((Object)"An exception was thrown while processing an item", (Throwable)e);
                    throw (Exception)cause;
                }
                throw e;
            }
        }
        this.delegate.write(list);
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        if (this.delegate instanceof ItemStream) {
            ((ItemStream)this.delegate).open(executionContext);
        }
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        if (this.delegate instanceof ItemStream) {
            ((ItemStream)this.delegate).update(executionContext);
        }
    }

    public void close() throws ItemStreamException {
        if (this.delegate instanceof ItemStream) {
            ((ItemStream)this.delegate).close();
        }
    }
}

