/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support.builder;

import java.util.Arrays;
import java.util.List;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.support.CompositeItemWriter;
import org.springframework.util.Assert;

public class CompositeItemWriterBuilder<T> {
    private List<ItemWriter<? super T>> delegates;
    private boolean ignoreItemStream = false;

    public CompositeItemWriterBuilder<T> ignoreItemStream(boolean ignoreItemStream) {
        this.ignoreItemStream = ignoreItemStream;
        return this;
    }

    public CompositeItemWriterBuilder<T> delegates(List<ItemWriter<? super T>> delegates) {
        this.delegates = delegates;
        return this;
    }

    @SafeVarargs
    public final CompositeItemWriterBuilder<T> delegates(ItemWriter<? super T> ... delegates) {
        return this.delegates(Arrays.asList(delegates));
    }

    public CompositeItemWriter<T> build() {
        Assert.notNull(this.delegates, (String)"A list of delegates is required.");
        Assert.notEmpty(this.delegates, (String)"The delegates list must have one or more delegates.");
        CompositeItemWriter<? super T> writer = new CompositeItemWriter<T>();
        writer.setDelegates(this.delegates);
        writer.setIgnoreItemStream(this.ignoreItemStream);
        return writer;
    }
}

