/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class SynchronizedItemStreamWriter<T>
implements ItemStreamWriter<T>,
InitializingBean {
    private ItemStreamWriter<T> delegate;

    public void setDelegate(ItemStreamWriter<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public synchronized void write(Chunk<? extends T> items) throws Exception {
        this.delegate.write(items);
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.delegate.open(executionContext);
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.delegate.update(executionContext);
    }

    @Override
    public void close() throws ItemStreamException {
        this.delegate.close();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.delegate != null ? 1 : 0) != 0, (String)"A delegate item writer is required");
    }
}

