/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;

public class CompositeItemStream
implements ItemStream {
    private final List<ItemStream> streams = new ArrayList<ItemStream>();

    public void setStreams(List<ItemStream> streams) {
        this.streams.addAll(streams);
    }

    public void setStreams(ItemStream[] streams) {
        this.streams.addAll(Arrays.asList(streams));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ItemStream stream) {
        List<ItemStream> list = this.streams;
        synchronized (list) {
            if (!this.streams.contains(stream)) {
                this.streams.add(stream);
            }
        }
    }

    public CompositeItemStream() {
    }

    public CompositeItemStream(List<ItemStream> streams) {
        this.setStreams(streams);
    }

    public CompositeItemStream(ItemStream ... streams) {
        this.setStreams(streams);
    }

    @Override
    public void update(ExecutionContext executionContext) {
        for (ItemStream itemStream : this.streams) {
            itemStream.update(executionContext);
        }
    }

    @Override
    public void close() throws ItemStreamException {
        for (ItemStream itemStream : this.streams) {
            itemStream.close();
        }
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        for (ItemStream itemStream : this.streams) {
            itemStream.open(executionContext);
        }
    }
}

