/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbitmq.client;

import com.rabbitmq.client.amqp.Message;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.utils.JavaUtils;
import org.springframework.util.StringUtils;

public final class RabbitAmqpUtils {
    public static org.springframework.amqp.core.Message fromAmqpMessage(Message amqpMessage, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Consumer.Context context) {
        MessageProperties messageProperties = new MessageProperties();
        JavaUtils.INSTANCE.acceptIfNotNull((Object)amqpMessage.messageIdAsString(), arg_0 -> ((MessageProperties)messageProperties).setMessageId(arg_0)).acceptIfNotNull((Object)amqpMessage.userId(), usr -> messageProperties.setUserId(new String((byte[])usr, StandardCharsets.UTF_8))).acceptIfNotNull((Object)amqpMessage.correlationIdAsString(), arg_0 -> ((MessageProperties)messageProperties).setCorrelationId(arg_0)).acceptIfNotNull((Object)amqpMessage.contentType(), arg_0 -> ((MessageProperties)messageProperties).setContentType(arg_0)).acceptIfNotNull((Object)amqpMessage.contentEncoding(), arg_0 -> ((MessageProperties)messageProperties).setContentEncoding(arg_0)).acceptIfNotNull((Object)amqpMessage.replyTo(), arg_0 -> ((MessageProperties)messageProperties).setReplyTo(arg_0));
        long creationTime = amqpMessage.creationTime();
        if (creationTime <= 0L) {
            creationTime = System.currentTimeMillis();
        }
        messageProperties.setTimestamp(new Date(creationTime));
        long absoluteExpiryTime = amqpMessage.absoluteExpiryTime();
        if (absoluteExpiryTime > creationTime) {
            messageProperties.setExpiration(Long.toString(absoluteExpiryTime - creationTime));
        }
        amqpMessage.forEachProperty((arg_0, arg_1) -> ((MessageProperties)messageProperties).setHeader(arg_0, arg_1));
        if (context != null) {
            messageProperties.setAmqpAcknowledgment(status -> {
                switch (status) {
                    case ACCEPT: {
                        context.accept();
                        break;
                    }
                    case REJECT: {
                        context.discard();
                        break;
                    }
                    case REQUEUE: {
                        context.requeue();
                    }
                }
            });
        }
        return new org.springframework.amqp.core.Message(amqpMessage.body(), messageProperties);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void toAmqpMessage(org.springframework.amqp.core.Message message, Message amqpMessage) {
        MessageProperties messageProperties = message.getMessageProperties();
        amqpMessage.body(message.getBody()).contentEncoding(messageProperties.getContentEncoding()).contentType(messageProperties.getContentType()).messageId(messageProperties.getMessageId()).priority(messageProperties.getPriority().byteValue());
        @Nullable Map headers = messageProperties.getHeaders();
        headers.forEach((key, val) -> RabbitAmqpUtils.mapProp(key, val, amqpMessage));
        JavaUtils.INSTANCE.acceptOrElseIfNotNull((Object)messageProperties.getCorrelationId(), (Object)messageProperties.getMessageId(), arg_0 -> ((Message)amqpMessage).correlationId(arg_0)).acceptOrElseIfNotNull((Object)messageProperties.getTimestamp(), (Object)new Date(), timestamp -> amqpMessage.creationTime(timestamp.getTime())).acceptIfNotNull((Object)messageProperties.getUserId(), userId -> amqpMessage.userId(userId.getBytes(StandardCharsets.UTF_8))).acceptIfNotNull((Object)messageProperties.getReplyTo(), arg_0 -> ((Message)amqpMessage).to(arg_0));
        String expiration = messageProperties.getExpiration();
        if (StringUtils.hasText((String)expiration)) {
            amqpMessage.absoluteExpiryTime(amqpMessage.creationTime() + Long.parseLong(expiration));
        }
    }

    private static void mapProp(String key, @Nullable Object val, Message amqpMessage) {
        if (val == null) {
            return;
        }
        if (val instanceof String) {
            String string = (String)val;
            amqpMessage.property(key, string);
        } else if (val instanceof Long) {
            Long longValue = (Long)val;
            amqpMessage.property(key, longValue.longValue());
        } else if (val instanceof Integer) {
            Integer intValue = (Integer)val;
            amqpMessage.property(key, intValue.intValue());
        } else if (val instanceof Short) {
            Short shortValue = (Short)val;
            amqpMessage.property(key, shortValue.shortValue());
        } else if (val instanceof Byte) {
            Byte byteValue = (Byte)val;
            amqpMessage.property(key, byteValue.byteValue());
        } else if (val instanceof Double) {
            Double doubleValue = (Double)val;
            amqpMessage.property(key, doubleValue.doubleValue());
        } else if (val instanceof Float) {
            Float floatValue = (Float)val;
            amqpMessage.property(key, floatValue.floatValue());
        } else if (val instanceof Character) {
            Character character = (Character)val;
            amqpMessage.property(key, character.charValue());
        } else if (val instanceof UUID) {
            UUID uuid = (UUID)val;
            amqpMessage.property(key, uuid);
        } else if (val instanceof byte[]) {
            byte[] bytes = (byte[])val;
            amqpMessage.property(key, bytes);
        } else if (val instanceof Boolean) {
            Boolean booleanValue = (Boolean)val;
            amqpMessage.property(key, booleanValue.booleanValue());
        }
    }

    private RabbitAmqpUtils() {
    }
}

