/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.BlockedListener;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.recovery.AutorecoveringChannel;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.AmqpApplicationContextClosedException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpTimeoutException;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.ChannelProxy;
import org.springframework.amqp.rabbit.connection.ClosingRecoveryListener;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.connection.ConnectionProxy;
import org.springframework.amqp.rabbit.connection.PublisherCallbackChannel;
import org.springframework.amqp.rabbit.connection.PublisherCallbackChannelFactory;
import org.springframework.amqp.rabbit.connection.PublisherCallbackChannelImpl;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.support.ActiveObjectCounter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@ManagedResource
public class CachingConnectionFactory
extends AbstractConnectionFactory
implements InitializingBean,
ShutdownListener,
SmartLifecycle {
    private static final String UNUSED = "unused";
    private static final int DEFAULT_CHANNEL_CACHE_SIZE = 25;
    private static final String DEFAULT_DEFERRED_POOL_PREFIX = "spring-rabbit-deferred-pool-";
    private static final int CHANNEL_EXEC_SHUTDOWN_TIMEOUT = 30;
    private static final AtomicInteger threadPoolId = new AtomicInteger();
    private static final Set<String> txStarts = Set.of("basicPublish", "basicAck", "basicNack", "basicReject");
    private static final Set<String> ackMethods = Set.of("basicAck", "basicNack", "basicReject");
    private static final Set<String> txEnds = Set.of("txCommit", "txRollback");
    private final ChannelCachingConnectionProxy connection = new ChannelCachingConnectionProxy(null);
    private final Set<ChannelCachingConnectionProxy> allocatedConnections = new HashSet<ChannelCachingConnectionProxy>();
    private final Map<ChannelCachingConnectionProxy, LinkedList<ChannelProxy>> allocatedConnectionNonTransactionalChannels = new HashMap<ChannelCachingConnectionProxy, LinkedList<ChannelProxy>>();
    private final Map<ChannelCachingConnectionProxy, LinkedList<ChannelProxy>> allocatedConnectionTransactionalChannels = new HashMap<ChannelCachingConnectionProxy, LinkedList<ChannelProxy>>();
    private final BlockingDeque<ChannelCachingConnectionProxy> idleConnections = new LinkedBlockingDeque<ChannelCachingConnectionProxy>();
    private final Deque<ChannelProxy> cachedChannelsNonTransactional = new LinkedList<ChannelProxy>();
    private final Deque<ChannelProxy> cachedChannelsTransactional = new LinkedList<ChannelProxy>();
    private final Map<Connection, Semaphore> checkoutPermits = new HashMap<Connection, Semaphore>();
    private final Map<String, AtomicInteger> channelHighWaterMarks = new HashMap<String, AtomicInteger>();
    private final AtomicInteger connectionHighWaterMark = new AtomicInteger();
    private final Lock connectionLock = new ReentrantLock();
    private final Condition connectionAvailableCondition = this.connectionLock.newCondition();
    private final ActiveObjectCounter<Channel> inFlightAsyncCloses = new ActiveObjectCounter();
    private final AtomicBoolean running = new AtomicBoolean();
    private long channelCheckoutTimeout = 0L;
    private CacheMode cacheMode = CacheMode.CHANNEL;
    private int channelCacheSize = 25;
    private int connectionCacheSize = 1;
    private int connectionLimit = Integer.MAX_VALUE;
    private ConfirmType confirmType = ConfirmType.NONE;
    private boolean publisherReturns;
    private PublisherCallbackChannelFactory publisherChannelFactory = PublisherCallbackChannelImpl.factory();
    private boolean defaultPublisherFactory = true;
    private volatile boolean active = true;
    private volatile boolean initialized;
    private volatile @Nullable ExecutorService channelsExecutor;
    private volatile boolean stopped;

    public CachingConnectionFactory() {
        this((String)null);
    }

    public CachingConnectionFactory(@Nullable String hostname) {
        this(hostname, 5672);
    }

    public CachingConnectionFactory(int port) {
        this(null, port);
    }

    public CachingConnectionFactory(@Nullable String hostNameArg, int port) {
        super(CachingConnectionFactory.newRabbitConnectionFactory());
        String hostname = hostNameArg;
        if (!StringUtils.hasText((String)hostname)) {
            hostname = this.getDefaultHostName();
        }
        this.setHost(hostname);
        this.setPort(port);
        this.doSetPublisherConnectionFactory(new CachingConnectionFactory(this.getRabbitConnectionFactory(), true));
    }

    public CachingConnectionFactory(URI uri) {
        super(CachingConnectionFactory.newRabbitConnectionFactory());
        this.setUri(uri);
        this.doSetPublisherConnectionFactory(new CachingConnectionFactory(this.getRabbitConnectionFactory(), true));
    }

    public CachingConnectionFactory(ConnectionFactory rabbitConnectionFactory) {
        this(rabbitConnectionFactory, false);
    }

    private CachingConnectionFactory(ConnectionFactory rabbitConnectionFactory, boolean isPublisherFactory) {
        super(rabbitConnectionFactory);
        if (!isPublisherFactory) {
            if (rabbitConnectionFactory.isAutomaticRecoveryEnabled()) {
                rabbitConnectionFactory.setAutomaticRecoveryEnabled(false);
                this.logger.warn((Object)"***\nAutomatic Recovery was Enabled in the provided connection factory;\nwhile Spring AMQP is generally compatible with this feature, there\nare some corner cases where problems arise. Spring AMQP\nprefers to use its own recovery mechanisms; when this option is true, you may receive\n'AutoRecoverConnectionNotCurrentlyOpenException's until the connection is recovered.\nIt has therefore been disabled; if you really wish to enable it, use\n'getRabbitConnectionFactory().setAutomaticRecoveryEnabled(true)',\nbut this is discouraged.");
            }
            super.setPublisherConnectionFactory(new CachingConnectionFactory(this.getRabbitConnectionFactory(), true));
        } else {
            super.setPublisherConnectionFactory(null);
            this.defaultPublisherFactory = false;
        }
    }

    private static ConnectionFactory newRabbitConnectionFactory() {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setAutomaticRecoveryEnabled(false);
        return connectionFactory;
    }

    @Override
    public void setPublisherConnectionFactory(@Nullable AbstractConnectionFactory publisherConnectionFactory) {
        super.setPublisherConnectionFactory(publisherConnectionFactory);
        this.defaultPublisherFactory = false;
    }

    public void setChannelCacheSize(int sessionCacheSize) {
        Assert.isTrue((sessionCacheSize >= 1 ? 1 : 0) != 0, (String)"Channel cache size must be 1 or higher");
        this.channelCacheSize = sessionCacheSize;
        if (this.defaultPublisherFactory) {
            ((CachingConnectionFactory)this.getPublisherConnectionFactory()).setChannelCacheSize(sessionCacheSize);
        }
    }

    public int getChannelCacheSize() {
        return this.channelCacheSize;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode cacheMode) {
        Assert.isTrue((!this.initialized ? 1 : 0) != 0, (String)"'cacheMode' cannot be changed after initialization.");
        Assert.notNull((Object)((Object)cacheMode), (String)"'cacheMode' must not be null.");
        this.cacheMode = cacheMode;
        if (this.defaultPublisherFactory) {
            ((CachingConnectionFactory)this.getPublisherConnectionFactory()).setCacheMode(cacheMode);
        }
    }

    public int getConnectionCacheSize() {
        return this.connectionCacheSize;
    }

    public void setConnectionCacheSize(int connectionCacheSize) {
        Assert.isTrue((connectionCacheSize >= 1 ? 1 : 0) != 0, (String)"Connection cache size must be 1 or higher.");
        this.connectionCacheSize = connectionCacheSize;
        if (this.defaultPublisherFactory) {
            ((CachingConnectionFactory)this.getPublisherConnectionFactory()).setConnectionCacheSize(connectionCacheSize);
        }
    }

    public void setConnectionLimit(int connectionLimit) {
        Assert.isTrue((connectionLimit >= 1 ? 1 : 0) != 0, (String)"Connection limit must be 1 or higher.");
        this.connectionLimit = connectionLimit;
        if (this.defaultPublisherFactory) {
            ((CachingConnectionFactory)this.getPublisherConnectionFactory()).setConnectionLimit(connectionLimit);
        }
    }

    @Override
    public boolean isPublisherConfirms() {
        return ConfirmType.CORRELATED.equals((Object)this.confirmType);
    }

    @Override
    public boolean isPublisherReturns() {
        return this.publisherReturns;
    }

    public void setPublisherReturns(boolean publisherReturns) {
        this.publisherReturns = publisherReturns;
        if (this.defaultPublisherFactory) {
            ((CachingConnectionFactory)this.getPublisherConnectionFactory()).setPublisherReturns(publisherReturns);
        }
    }

    @Override
    public boolean isSimplePublisherConfirms() {
        return this.confirmType.equals((Object)ConfirmType.SIMPLE);
    }

    public void setPublisherConfirmType(ConfirmType confirmType) {
        Assert.notNull((Object)((Object)confirmType), (String)"'confirmType' cannot be null");
        this.confirmType = confirmType;
        if (this.defaultPublisherFactory) {
            ((CachingConnectionFactory)this.getPublisherConnectionFactory()).setPublisherConfirmType(confirmType);
        }
    }

    public void setChannelCheckoutTimeout(long channelCheckoutTimeout) {
        this.channelCheckoutTimeout = channelCheckoutTimeout;
        if (this.defaultPublisherFactory) {
            ((CachingConnectionFactory)this.getPublisherConnectionFactory()).setChannelCheckoutTimeout(channelCheckoutTimeout);
        }
    }

    public void setPublisherChannelFactory(PublisherCallbackChannelFactory publisherChannelFactory) {
        Assert.notNull((Object)publisherChannelFactory, (String)"'publisherChannelFactory' cannot be null");
        this.publisherChannelFactory = publisherChannelFactory;
    }

    public int getPhase() {
        return Integer.MIN_VALUE;
    }

    public void afterPropertiesSet() {
        this.initialized = true;
        if (this.cacheMode == CacheMode.CHANNEL) {
            Assert.isTrue((this.connectionCacheSize == 1 ? 1 : 0) != 0, (String)"When the cache mode is 'CHANNEL', the connection cache size cannot be configured.");
        }
        this.initCacheWaterMarks();
        if (this.defaultPublisherFactory) {
            ((CachingConnectionFactory)this.getPublisherConnectionFactory()).afterPropertiesSet();
        }
    }

    public void start() {
        this.running.set(true);
    }

    public void stop() {
        this.running.set(false);
        this.resetConnection();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    private void initCacheWaterMarks() {
        this.channelHighWaterMarks.put(ObjectUtils.getIdentityHexString(this.cachedChannelsNonTransactional), new AtomicInteger());
        this.channelHighWaterMarks.put(ObjectUtils.getIdentityHexString(this.cachedChannelsTransactional), new AtomicInteger());
    }

    @Override
    public void setConnectionListeners(List<? extends ConnectionListener> listeners) {
        super.setConnectionListeners(listeners);
        if (this.connection.target != null) {
            this.getConnectionListener().onCreate(this.connection);
        }
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        super.addConnectionListener(listener);
        if (this.connection.target != null) {
            listener.onCreate(this.connection);
        }
    }

    private Channel getChannel(ChannelCachingConnectionProxy connection, boolean transactional) {
        Semaphore permits = null;
        if (this.channelCheckoutTimeout > 0L) {
            permits = this.obtainPermits(connection);
        }
        Deque<ChannelProxy> channelList = this.determineChannelList(connection, transactional);
        ChannelProxy channel = null;
        if (connection.isOpen() && (channel = this.findOpenChannel(channelList, connection.channelListLock)) != null && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Found cached Rabbit Channel: " + String.valueOf(channel)));
        }
        if (channel == null) {
            try {
                channel = this.getCachedChannelProxy(connection, channelList, transactional);
            }
            catch (RuntimeException e) {
                if (permits != null) {
                    permits.release();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Could not get channel; released permit for " + String.valueOf(connection) + ", remaining:" + permits.availablePermits()));
                    }
                }
                throw e;
            }
        }
        return channel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Semaphore obtainPermits(ChannelCachingConnectionProxy connection) {
        Semaphore permits = this.checkoutPermits.get(connection);
        if (permits == null) throw new IllegalStateException("No permits map entry for " + String.valueOf(connection));
        try {
            if (!permits.tryAcquire(this.channelCheckoutTimeout, TimeUnit.MILLISECONDS)) {
                throw new AmqpTimeoutException("No available channels");
            }
            if (!this.logger.isDebugEnabled()) return permits;
            this.logger.debug((Object)("Acquired permit for " + String.valueOf(connection) + ", remaining:" + permits.availablePermits()));
            return permits;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AmqpTimeoutException("Interrupted while acquiring a channel", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable ChannelProxy findOpenChannel(Deque<ChannelProxy> channelList, Lock channelListLock) {
        ChannelProxy channel = null;
        channelListLock.lock();
        try {
            while (!channelList.isEmpty()) {
                channel = channelList.removeFirst();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)(String.valueOf(channel) + " retrieved from cache"));
                }
                if (channel.isOpen()) {
                    break;
                }
                this.cleanUpClosedChannel(channel);
                channel = null;
            }
        }
        finally {
            channelListLock.unlock();
        }
        return channel;
    }

    private void cleanUpClosedChannel(ChannelProxy channel) {
        block7: {
            try {
                Channel target = channel.getTargetChannel();
                if (target != null) {
                    target.close();
                }
            }
            catch (AlreadyClosedException e) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)(String.valueOf(channel) + " is already closed"));
                }
            }
            catch (IOException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Unexpected Exception closing channel " + e.getMessage()));
                }
            }
            catch (TimeoutException e) {
                if (!this.logger.isWarnEnabled()) break block7;
                this.logger.warn((Object)("TimeoutException closing channel " + e.getMessage()));
            }
        }
    }

    private Deque<ChannelProxy> determineChannelList(ChannelCachingConnectionProxy connection, boolean transactional) {
        Deque<Object> channelList;
        if (this.cacheMode == CacheMode.CHANNEL) {
            channelList = transactional ? this.cachedChannelsTransactional : this.cachedChannelsNonTransactional;
        } else {
            Deque<Object> deque = channelList = transactional ? (Deque<Object>)this.allocatedConnectionTransactionalChannels.get(connection) : (Deque)this.allocatedConnectionNonTransactionalChannels.get(connection);
        }
        if (channelList == null) {
            throw new IllegalStateException("No channel list for connection " + String.valueOf(connection));
        }
        return channelList;
    }

    private ChannelProxy getCachedChannelProxy(ChannelCachingConnectionProxy connection, Deque<ChannelProxy> channelList, boolean transactional) {
        Channel targetChannel = this.createBareChannel(connection, transactional);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating cached Rabbit Channel from " + String.valueOf(targetChannel)));
        }
        this.getChannelListener().onCreate(targetChannel, transactional);
        Class[] interfaces = ConfirmType.CORRELATED.equals((Object)this.confirmType) || this.publisherReturns ? new Class[]{ChannelProxy.class, PublisherCallbackChannel.class} : new Class[]{ChannelProxy.class};
        return (ChannelProxy)Proxy.newProxyInstance(ChannelProxy.class.getClassLoader(), interfaces, (InvocationHandler)new CachedChannelInvocationHandler(connection, targetChannel, channelList, transactional));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel createBareChannel(ChannelCachingConnectionProxy connection, boolean transactional) {
        if (this.cacheMode == CacheMode.CHANNEL) {
            if (!this.connection.isOpen()) {
                this.connectionLock.lock();
                try {
                    if (!this.connection.isOpen()) {
                        this.connection.notifyCloseIfNecessary();
                    }
                    if (!this.connection.isOpen()) {
                        this.connection.target = null;
                        this.createConnection();
                    }
                }
                finally {
                    this.connectionLock.unlock();
                }
            }
            return this.doCreateBareChannel(this.connection, transactional);
        }
        if (!connection.isOpen()) {
            this.connectionLock.lock();
            try {
                LinkedList<ChannelProxy> channelProxies = this.allocatedConnectionNonTransactionalChannels.get(connection);
                if (channelProxies != null) {
                    channelProxies.clear();
                }
                if ((channelProxies = this.allocatedConnectionTransactionalChannels.get(connection)) != null) {
                    channelProxies.clear();
                }
                connection.notifyCloseIfNecessary();
                this.refreshProxyConnection(connection);
            }
            finally {
                this.connectionLock.unlock();
            }
        }
        return this.doCreateBareChannel(connection, transactional);
    }

    private Channel doCreateBareChannel(ChannelCachingConnectionProxy conn, boolean transactional) {
        Channel channel = conn.createBareChannel(transactional);
        if (!ConfirmType.NONE.equals((Object)this.confirmType)) {
            try {
                channel.confirmSelect();
            }
            catch (IOException e) {
                this.logger.error((Object)"Could not configure the channel to receive publisher confirms", (Throwable)e);
            }
        }
        if ((ConfirmType.CORRELATED.equals((Object)this.confirmType) || this.publisherReturns) && !(channel instanceof PublisherCallbackChannelImpl)) {
            channel = this.publisherChannelFactory.createChannel(channel, this.getChannelsExecutor());
        }
        channel.addShutdownListener((ShutdownListener)this);
        return channel;
    }

    @Override
    public final Connection createConnection() throws AmqpException {
        if (this.stopped) {
            throw new AmqpApplicationContextClosedException("The ApplicationContext is closed and the ConnectionFactory can no longer create connections.");
        }
        this.connectionLock.lock();
        try {
            if (this.cacheMode == CacheMode.CONNECTION) {
                Connection connection = this.connectionFromCache();
                return connection;
            }
            if (this.connection.target == null) {
                this.connection.target = super.createBareConnection();
                if (!this.checkoutPermits.containsKey(this.connection)) {
                    this.checkoutPermits.put(this.connection, new Semaphore(this.channelCacheSize));
                }
                this.connection.closeNotified.set(false);
                this.getConnectionListener().onCreate(this.connection);
            }
            ChannelCachingConnectionProxy channelCachingConnectionProxy = this.connection;
            return channelCachingConnectionProxy;
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    private Connection connectionFromCache() {
        ChannelCachingConnectionProxy cachedConnection = this.findIdleConnection();
        long now = System.currentTimeMillis();
        if (cachedConnection == null && this.countOpenConnections() >= this.connectionLimit) {
            cachedConnection = this.waitForConnection(now);
        }
        if (cachedConnection == null) {
            if (this.countOpenConnections() >= this.connectionLimit && System.currentTimeMillis() - now >= this.channelCheckoutTimeout) {
                throw new AmqpTimeoutException("Timed out attempting to get a connection");
            }
            cachedConnection = new ChannelCachingConnectionProxy(super.createBareConnection());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Adding new connection '" + String.valueOf(cachedConnection) + "'"));
            }
            this.allocatedConnections.add(cachedConnection);
            this.allocatedConnectionNonTransactionalChannels.put(cachedConnection, new LinkedList());
            this.channelHighWaterMarks.put(ObjectUtils.getIdentityHexString(this.allocatedConnectionNonTransactionalChannels.get(cachedConnection)), new AtomicInteger());
            this.allocatedConnectionTransactionalChannels.put(cachedConnection, new LinkedList());
            this.channelHighWaterMarks.put(ObjectUtils.getIdentityHexString(this.allocatedConnectionTransactionalChannels.get(cachedConnection)), new AtomicInteger());
            this.checkoutPermits.put(cachedConnection, new Semaphore(this.channelCacheSize));
            this.getConnectionListener().onCreate(cachedConnection);
        } else if (!cachedConnection.isOpen()) {
            try {
                this.refreshProxyConnection(cachedConnection);
            }
            catch (Exception e) {
                this.idleConnections.addLast(cachedConnection);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Obtained connection '" + String.valueOf(cachedConnection) + "' from cache"));
        }
        return cachedConnection;
    }

    private @Nullable ChannelCachingConnectionProxy waitForConnection(long now) {
        ChannelCachingConnectionProxy cachedConnection = null;
        while (cachedConnection == null && System.currentTimeMillis() - now < this.channelCheckoutTimeout) {
            if (this.countOpenConnections() < this.connectionLimit) continue;
            try {
                if (!this.connectionAvailableCondition.await(this.channelCheckoutTimeout, TimeUnit.MILLISECONDS)) continue;
                cachedConnection = this.findIdleConnection();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new AmqpException("Interrupted while waiting for a connection", (Throwable)e);
            }
        }
        return cachedConnection;
    }

    private @Nullable ChannelCachingConnectionProxy findIdleConnection() {
        ChannelCachingConnectionProxy cachedConnection = null;
        ChannelCachingConnectionProxy lastIdle = (ChannelCachingConnectionProxy)this.idleConnections.peekLast();
        while (cachedConnection == null && (cachedConnection = this.idleConnections.poll()) != null) {
            if (cachedConnection.isOpen()) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Skipping closed connection '" + String.valueOf(cachedConnection) + "'"));
            }
            cachedConnection.notifyCloseIfNecessary();
            this.idleConnections.addLast(cachedConnection);
            if (cachedConnection.equals(lastIdle)) {
                cachedConnection = this.idleConnections.poll();
                break;
            }
            cachedConnection = null;
        }
        return cachedConnection;
    }

    private void refreshProxyConnection(ChannelCachingConnectionProxy connection) {
        connection.destroy();
        connection.notifyCloseIfNecessary();
        connection.target = super.createBareConnection();
        connection.closeNotified.set(false);
        this.getConnectionListener().onCreate(connection);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Refreshed existing connection '" + String.valueOf(connection) + "'"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        block11: {
            if (this.getContextStopped()) {
                this.stopped = true;
                this.connectionLock.lock();
                try {
                    ExecutorService executorService = this.channelsExecutor;
                    if (executorService == null) break block11;
                    try {
                        if (!this.inFlightAsyncCloses.await(30L, TimeUnit.SECONDS)) {
                            this.logger.warn((Object)("Async closes are still in-flight: " + this.inFlightAsyncCloses.getCount()));
                        }
                        executorService.shutdown();
                        if (!executorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                            this.logger.warn((Object)"Channel executor failed to shut down");
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    finally {
                        this.channelsExecutor = null;
                    }
                }
                finally {
                    this.connectionLock.unlock();
                }
            }
        }
        super.destroy();
        this.resetConnection();
    }

    @Override
    public void resetConnection() {
        this.connectionLock.lock();
        try {
            if (this.connection.target != null) {
                this.connection.destroy();
            }
            this.allocatedConnections.forEach(ChannelCachingConnectionProxy::destroy);
            this.channelHighWaterMarks.values().forEach(count -> count.set(0));
            this.connectionHighWaterMark.set(0);
        }
        finally {
            this.connectionLock.unlock();
        }
        if (this.defaultPublisherFactory) {
            this.getPublisherConnectionFactory().resetConnection();
        }
    }

    protected void reset(Deque<ChannelProxy> channels, Deque<ChannelProxy> txChannels, Map<Channel, ChannelProxy> channelsAwaitingAcks) {
        this.active = false;
        this.closeAndClear(channels);
        this.closeAndClear(txChannels);
        this.closeChannels(channelsAwaitingAcks.values());
        channelsAwaitingAcks.clear();
        this.active = true;
    }

    protected void closeAndClear(Collection<ChannelProxy> theChannels) {
        this.closeChannels(theChannels);
        theChannels.clear();
    }

    protected void closeChannels(Collection<ChannelProxy> theChannels) {
        for (ChannelProxy channel : theChannels) {
            try {
                channel.close();
            }
            catch (Exception ex) {
                this.logger.trace((Object)"Could not close cached Rabbit Channel", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute
    public Properties getCacheProperties() {
        Properties props = new Properties();
        props.setProperty("cacheMode", this.cacheMode.name());
        this.connectionLock.lock();
        try {
            props.setProperty("channelCacheSize", Integer.toString(this.channelCacheSize));
            if (this.cacheMode.equals((Object)CacheMode.CONNECTION)) {
                LinkedList channelList;
                int port;
                props.setProperty("connectionCacheSize", Integer.toString(this.connectionCacheSize));
                props.setProperty("openConnections", Integer.toString(this.countOpenConnections()));
                props.setProperty("idleConnections", Integer.toString(this.idleConnections.size()));
                props.setProperty("idleConnectionsHighWater", Integer.toString(this.connectionHighWaterMark.get()));
                for (ChannelCachingConnectionProxy channelCachingConnectionProxy : this.allocatedConnections) {
                    this.putConnectionName(props, channelCachingConnectionProxy, ":" + channelCachingConnectionProxy.getLocalPort());
                }
                for (Map.Entry entry : this.allocatedConnectionTransactionalChannels.entrySet()) {
                    port = ((ChannelCachingConnectionProxy)entry.getKey()).getLocalPort();
                    if (port <= 0 || !((ChannelCachingConnectionProxy)entry.getKey()).isOpen()) continue;
                    channelList = (LinkedList)entry.getValue();
                    props.put("idleChannelsTx:" + port, Integer.toString(channelList.size()));
                    props.put("idleChannelsTxHighWater:" + port, Integer.toString(this.channelHighWaterMarks.get(ObjectUtils.getIdentityHexString((Object)channelList)).get()));
                }
                for (Map.Entry entry : this.allocatedConnectionNonTransactionalChannels.entrySet()) {
                    port = ((ChannelCachingConnectionProxy)entry.getKey()).getLocalPort();
                    if (port <= 0 || !((ChannelCachingConnectionProxy)entry.getKey()).isOpen()) continue;
                    channelList = (LinkedList)entry.getValue();
                    props.put("idleChannelsNotTx:" + port, Integer.toString(channelList.size()));
                    props.put("idleChannelsNotTxHighWater:" + port, Integer.toString(this.channelHighWaterMarks.get(ObjectUtils.getIdentityHexString((Object)channelList)).get()));
                }
            } else {
                props.setProperty("localPort", Integer.toString(this.connection.target == null ? 0 : this.connection.getLocalPort()));
                props.setProperty("idleChannelsTx", Integer.toString(this.cachedChannelsTransactional.size()));
                props.setProperty("idleChannelsNotTx", Integer.toString(this.cachedChannelsNonTransactional.size()));
                props.setProperty("idleChannelsTxHighWater", Integer.toString(this.channelHighWaterMarks.get(ObjectUtils.getIdentityHexString(this.cachedChannelsTransactional)).get()));
                props.setProperty("idleChannelsNotTxHighWater", Integer.toString(this.channelHighWaterMarks.get(ObjectUtils.getIdentityHexString(this.cachedChannelsNonTransactional)).get()));
                this.putConnectionName(props, this.connection, "");
            }
        }
        finally {
            this.connectionLock.unlock();
        }
        return props;
    }

    @ManagedAttribute
    public Properties getPublisherConnectionFactoryCacheProperties() {
        if (this.defaultPublisherFactory) {
            return ((CachingConnectionFactory)this.getPublisherConnectionFactory()).getCacheProperties();
        }
        return new Properties();
    }

    private void putConnectionName(Properties props, ConnectionProxy connection, String keySuffix) {
        com.rabbitmq.client.Connection delegate;
        String name;
        Connection targetConnection = connection.getTargetConnection();
        if (targetConnection != null && (name = (delegate = targetConnection.getDelegate()).getClientProvidedName()) != null) {
            props.put("connectionName" + keySuffix, name);
        }
    }

    private int countOpenConnections() {
        int n = 0;
        for (ChannelCachingConnectionProxy proxy : this.allocatedConnections) {
            if (!proxy.isOpen()) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecutorService getChannelsExecutor() {
        ExecutorService executorService = this.getExecutorService();
        if (executorService == null && (executorService = this.channelsExecutor) == null) {
            this.connectionLock.lock();
            try {
                executorService = this.channelsExecutor;
                if (executorService == null) {
                    Object threadPrefix = this.getBeanName() == null ? DEFAULT_DEFERRED_POOL_PREFIX + threadPoolId.incrementAndGet() : this.getBeanName();
                    CustomizableThreadFactory threadPoolFactory = new CustomizableThreadFactory((String)threadPrefix);
                    this.channelsExecutor = executorService = Executors.newCachedThreadPool((ThreadFactory)threadPoolFactory);
                }
            }
            finally {
                this.connectionLock.unlock();
            }
        }
        return executorService;
    }

    @Override
    public String toString() {
        Object host = this.getHost();
        int port = this.getPort();
        List<Address> addresses = null;
        try {
            addresses = this.getAddresses();
        }
        catch (IOException ex) {
            host = "AddressResolver threw exception: " + ex.getMessage();
        }
        return "CachingConnectionFactory [channelCacheSize=" + this.channelCacheSize + (addresses != null ? ", addresses=" + String.valueOf(addresses) : (String)(host != null ? ", host=" + (String)host : "") + (String)(port > 0 ? ", port=" + port : "")) + ", active=" + this.active + " " + super.toString() + "]";
    }

    private class ChannelCachingConnectionProxy
    implements ConnectionProxy {
        private final AtomicBoolean closeNotified = new AtomicBoolean(false);
        private final Lock channelListLock = new ReentrantLock();
        private final ConcurrentMap<Channel, ChannelProxy> channelsAwaitingAcks = new ConcurrentHashMap<Channel, ChannelProxy>();
        private volatile @Nullable Connection target;

        ChannelCachingConnectionProxy(Connection target) {
            this.target = target;
        }

        private Channel createBareChannel(boolean transactional) {
            Assert.state((this.target != null ? 1 : 0) != 0, (String)"Can't create channel - no target connection.");
            return this.target.createChannel(transactional);
        }

        @Override
        public Channel createChannel(boolean transactional) {
            return CachingConnectionFactory.this.getChannel(this, transactional);
        }

        @Override
        public void addBlockedListener(BlockedListener listener) {
            Assert.state((this.target != null ? 1 : 0) != 0, (String)"Can't add blocked listener - no target connection.");
            this.target.addBlockedListener(listener);
        }

        @Override
        public boolean removeBlockedListener(BlockedListener listener) {
            Assert.state((this.target != null ? 1 : 0) != 0, (String)"Can't remove blocked listener - no target connection.");
            return this.target.removeBlockedListener(listener);
        }

        @Override
        public void close() {
            if (CachingConnectionFactory.this.cacheMode == CacheMode.CONNECTION) {
                CachingConnectionFactory.this.connectionLock.lock();
                try {
                    if (!CachingConnectionFactory.this.idleConnections.contains(this)) {
                        if (!this.isOpen() || this.countOpenIdleConnections() >= CachingConnectionFactory.this.connectionCacheSize) {
                            if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                                CachingConnectionFactory.this.logger.debug((Object)("Completely closing connection '" + String.valueOf(this) + "'"));
                            }
                            this.destroy();
                        }
                        if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                            CachingConnectionFactory.this.logger.debug((Object)("Returning connection '" + String.valueOf(this) + "' to cache"));
                        }
                        CachingConnectionFactory.this.idleConnections.add(this);
                        if (CachingConnectionFactory.this.connectionHighWaterMark.get() < CachingConnectionFactory.this.idleConnections.size()) {
                            CachingConnectionFactory.this.connectionHighWaterMark.set(CachingConnectionFactory.this.idleConnections.size());
                        }
                        CachingConnectionFactory.this.connectionAvailableCondition.signalAll();
                    }
                }
                finally {
                    CachingConnectionFactory.this.connectionLock.unlock();
                }
            }
        }

        private int countOpenIdleConnections() {
            int n = 0;
            for (ChannelCachingConnectionProxy proxy : CachingConnectionFactory.this.idleConnections) {
                if (!proxy.isOpen()) continue;
                ++n;
            }
            return n;
        }

        public void destroy() {
            if (CachingConnectionFactory.this.cacheMode == CacheMode.CHANNEL) {
                CachingConnectionFactory.this.reset(CachingConnectionFactory.this.cachedChannelsNonTransactional, CachingConnectionFactory.this.cachedChannelsTransactional, this.channelsAwaitingAcks);
            } else {
                CachingConnectionFactory.this.reset((Deque<ChannelProxy>)CachingConnectionFactory.this.allocatedConnectionNonTransactionalChannels.get(this), (Deque<ChannelProxy>)CachingConnectionFactory.this.allocatedConnectionTransactionalChannels.get(this), this.channelsAwaitingAcks);
            }
            if (this.target != null) {
                RabbitUtils.closeConnection(this.target);
                this.notifyCloseIfNecessary();
            }
            this.target = null;
        }

        private void notifyCloseIfNecessary() {
            if (!this.closeNotified.getAndSet(true)) {
                CachingConnectionFactory.this.getConnectionListener().onClose(this);
            }
        }

        @Override
        public boolean isOpen() {
            Connection targetToCheck = this.target;
            return targetToCheck != null && targetToCheck.isOpen();
        }

        @Override
        public @Nullable Connection getTargetConnection() {
            return this.target;
        }

        @Override
        public com.rabbitmq.client.Connection getDelegate() {
            Connection targetConnection = this.target;
            if (targetConnection != null) {
                return targetConnection.getDelegate();
            }
            throw new IllegalStateException("Can't get delegate - no target connection.");
        }

        @Override
        public int getLocalPort() {
            Connection target = this.target;
            if (target != null) {
                return target.getLocalPort();
            }
            return 0;
        }

        public String toString() {
            return "Proxy@" + ObjectUtils.getIdentityHexString((Object)this) + " " + (CachingConnectionFactory.this.cacheMode == CacheMode.CHANNEL ? "Shared " : "Dedicated ") + "Rabbit Connection: " + String.valueOf(this.target);
        }
    }

    public static enum CacheMode {
        CHANNEL,
        CONNECTION;

    }

    public static enum ConfirmType {
        SIMPLE,
        CORRELATED,
        NONE;

    }

    private final class CachedChannelInvocationHandler
    implements InvocationHandler {
        private final ChannelCachingConnectionProxy theConnection;
        private final Deque<ChannelProxy> channelList;
        private final String channelListIdentity;
        private final Lock targetLock = new ReentrantLock();
        private final boolean transactional;
        private final boolean confirmSelected;
        private final boolean publisherConfirms;
        private volatile @Nullable Channel target;
        private volatile boolean txStarted;

        CachedChannelInvocationHandler(ChannelCachingConnectionProxy connection, Channel target, Deque<ChannelProxy> channelList, boolean transactional) {
            this.confirmSelected = ConfirmType.SIMPLE.equals((Object)CachingConnectionFactory.this.confirmType);
            this.publisherConfirms = ConfirmType.CORRELATED.equals((Object)CachingConnectionFactory.this.confirmType);
            this.theConnection = connection;
            this.target = target;
            this.channelList = channelList;
            this.channelListIdentity = ObjectUtils.getIdentityHexString(channelList);
            this.transactional = transactional;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public @Nullable Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName;
            ChannelProxy channelProxy = (ChannelProxy)proxy;
            if (CachingConnectionFactory.this.logger.isTraceEnabled() && !method.getName().equals("toString") && !method.getName().equals("hashCode") && !method.getName().equals("equals")) {
                try {
                    CachingConnectionFactory.this.logger.trace((Object)(String.valueOf(this.target) + " channel." + method.getName() + "(" + Arrays.toString(args) + ")"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((methodName = method.getName()).equals("txSelect") && !this.transactional) {
                throw new UnsupportedOperationException("Cannot start transaction on non-transactional channel");
            }
            switch (methodName) {
                case "equals": {
                    return channelProxy == args[0];
                }
                case "hashCode": {
                    return System.identityHashCode(channelProxy);
                }
                case "toString": {
                    return "Cached Rabbit Channel: " + String.valueOf(this.target) + ", conn: " + String.valueOf(this.theConnection);
                }
                case "close": {
                    if (CachingConnectionFactory.this.active && !RabbitUtils.isPhysicalCloseRequired()) {
                        this.logicalClose(channelProxy);
                    } else {
                        this.physicalClose();
                    }
                    return null;
                }
                case "getTargetChannel": {
                    return this.target;
                }
                case "isOpen": {
                    Channel targetToCheck = this.target;
                    return targetToCheck != null && targetToCheck.isOpen();
                }
                case "isTransactional": {
                    return this.transactional;
                }
                case "isConfirmSelected": {
                    return this.confirmSelected;
                }
                case "isPublisherConfirms": {
                    return this.publisherConfirms;
                }
            }
            Channel targetChannel = this.target;
            if (targetChannel == null || !targetChannel.isOpen()) {
                if (targetChannel instanceof PublisherCallbackChannel) {
                    targetChannel.close();
                    throw new InvocationTargetException((Throwable)new AmqpException("PublisherCallbackChannel is closed"));
                }
                if (this.txStarted) {
                    this.txStarted = false;
                    throw new InvocationTargetException(new IllegalStateException("Channel closed during transaction"));
                }
                if (ackMethods.contains(methodName)) {
                    throw new InvocationTargetException(new IllegalStateException("Channel closed; cannot ack/nack"));
                }
                this.target = null;
            }
            this.targetLock.lock();
            try {
                if (this.target == null) {
                    this.target = CachingConnectionFactory.this.createBareChannel(this.theConnection, this.transactional);
                }
                Object result = method.invoke((Object)this.target, args);
                if (this.transactional) {
                    if (txStarts.contains(methodName)) {
                        this.txStarted = true;
                    } else if (txEnds.contains(methodName)) {
                        this.txStarted = false;
                    }
                }
                Object object = result;
                this.targetLock.unlock();
                return object;
            }
            catch (Throwable throwable) {
                try {
                    this.targetLock.unlock();
                    throw throwable;
                }
                catch (InvocationTargetException ex) {
                    Channel targetChannel2 = this.target;
                    if (targetChannel2 == null || !targetChannel2.isOpen()) {
                        if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                            CachingConnectionFactory.this.logger.debug((Object)("Detected closed channel on exception.  Re-initializing: " + String.valueOf(this.target)));
                        }
                        this.target = null;
                        this.targetLock.lock();
                        try {
                            if (this.target == null) {
                                this.target = CachingConnectionFactory.this.createBareChannel(this.theConnection, this.transactional);
                            }
                        }
                        finally {
                            this.targetLock.unlock();
                        }
                    }
                    throw ex.getTargetException();
                }
            }
        }

        private void releasePermitIfNecessary() {
            if (CachingConnectionFactory.this.channelCheckoutTimeout > 0L) {
                Semaphore permits = CachingConnectionFactory.this.checkoutPermits.get(this.theConnection);
                if (permits != null) {
                    if (permits.availablePermits() < CachingConnectionFactory.this.channelCacheSize) {
                        permits.release();
                        if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                            CachingConnectionFactory.this.logger.debug((Object)("Released permit for '" + String.valueOf(this.theConnection) + "', remaining: " + permits.availablePermits()));
                        }
                    }
                } else {
                    CachingConnectionFactory.this.logger.error((Object)("LEAKAGE: No permits map entry for " + String.valueOf(this.theConnection)));
                }
            }
        }

        private void logicalClose(ChannelProxy proxy) throws IOException, TimeoutException {
            if (this.target == null) {
                return;
            }
            Channel targetChannel = this.target;
            if (targetChannel != null && !targetChannel.isOpen()) {
                this.targetLock.lock();
                try {
                    targetChannel = this.target;
                    if (targetChannel != null && !targetChannel.isOpen()) {
                        if (targetChannel instanceof PublisherCallbackChannel) {
                            targetChannel.close();
                        }
                        if (!this.channelList.remove(proxy)) {
                            this.releasePermitIfNecessary();
                        }
                        this.target = null;
                        return;
                    }
                }
                finally {
                    this.targetLock.unlock();
                }
            }
            this.returnToCache(proxy);
        }

        private void returnToCache(ChannelProxy proxy) {
            if (CachingConnectionFactory.this.active && this.publisherConfirms && proxy instanceof PublisherCallbackChannel) {
                PublisherCallbackChannel publisherCallbackChannel = (PublisherCallbackChannel)((Object)proxy);
                this.theConnection.channelsAwaitingAcks.put(this.target, proxy);
                AtomicBoolean ackCallbackCalledImmediately = new AtomicBoolean();
                publisherCallbackChannel.setAfterAckCallback(c -> {
                    ackCallbackCalledImmediately.set(true);
                    this.doReturnToCache((ChannelProxy)this.theConnection.channelsAwaitingAcks.remove(c));
                });
                if (!ackCallbackCalledImmediately.get()) {
                    CachingConnectionFactory.this.getChannelsExecutor().execute(() -> {
                        try {
                            publisherCallbackChannel.waitForConfirms(CachingConnectionFactory.this.getCloseTimeout());
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                        catch (ShutdownSignalException | TimeoutException ex) {
                            try {
                                this.physicalClose();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            } else {
                this.doReturnToCache(proxy);
            }
        }

        private void doReturnToCache(@Nullable ChannelProxy proxy) {
            if (proxy != null) {
                this.theConnection.channelListLock.lock();
                try {
                    if (CachingConnectionFactory.this.active) {
                        this.cacheOrClose(proxy);
                    } else if (proxy.isOpen()) {
                        try {
                            this.physicalClose();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    this.theConnection.channelListLock.unlock();
                }
            }
        }

        private void cacheOrClose(ChannelProxy proxy) {
            boolean alreadyCached = this.channelList.contains(proxy);
            if (this.channelList.size() >= CachingConnectionFactory.this.getChannelCacheSize() && !alreadyCached) {
                if (CachingConnectionFactory.this.logger.isTraceEnabled()) {
                    CachingConnectionFactory.this.logger.trace((Object)("Cache limit reached: " + String.valueOf(this.target)));
                }
                try {
                    this.physicalClose();
                }
                catch (Exception exception) {}
            } else if (!alreadyCached) {
                if (CachingConnectionFactory.this.logger.isTraceEnabled()) {
                    CachingConnectionFactory.this.logger.trace((Object)("Returning cached Channel: " + String.valueOf(this.target)));
                }
                this.channelList.addLast(proxy);
                this.releasePermitIfNecessary();
                this.setHighWaterMark();
            }
        }

        private void setHighWaterMark() {
            AtomicInteger hwm = CachingConnectionFactory.this.channelHighWaterMarks.get(this.channelListIdentity);
            if (hwm != null) {
                int prev = hwm.get();
                int size = this.channelList.size();
                if (size > prev) {
                    hwm.set(size);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void physicalClose() throws IOException, TimeoutException {
            if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                CachingConnectionFactory.this.logger.debug((Object)("Closing cached Channel: " + String.valueOf(this.target)));
            }
            RabbitUtils.clearPhysicalCloseRequired();
            if (this.target == null) {
                return;
            }
            boolean async = false;
            try {
                if (CachingConnectionFactory.this.active && (ConfirmType.CORRELATED.equals((Object)CachingConnectionFactory.this.confirmType) || CachingConnectionFactory.this.publisherReturns)) {
                    async = true;
                    this.asyncClose();
                } else {
                    this.target.close();
                    Channel channel = this.target;
                    if (channel instanceof AutorecoveringChannel) {
                        AutorecoveringChannel auto = (AutorecoveringChannel)channel;
                        ClosingRecoveryListener.removeChannel(auto);
                    }
                }
            }
            catch (AlreadyClosedException e) {
                if (CachingConnectionFactory.this.logger.isTraceEnabled()) {
                    CachingConnectionFactory.this.logger.trace((Object)(String.valueOf(this.target) + " is already closed"), (Throwable)e);
                }
            }
            finally {
                this.target = null;
                if (!async) {
                    this.releasePermitIfNecessary();
                }
            }
        }

        private void asyncClose() {
            ExecutorService executorService = CachingConnectionFactory.this.getChannelsExecutor();
            Channel channel = this.target;
            CachingConnectionFactory.this.inFlightAsyncCloses.add(channel);
            try {
                executorService.execute(() -> {
                    block31: {
                        if (ConfirmType.CORRELATED.equals((Object)CachingConnectionFactory.this.confirmType)) {
                            channel.waitForConfirmsOrDie((long)CachingConnectionFactory.this.getCloseTimeout());
                            break block31;
                        }
                        Thread.sleep(5000L);
                    }
                    try {
                        channel.close();
                        return;
                    }
                    catch (AlreadyClosedException | IOException | TimeoutException throwable) {
                        return;
                    }
                    catch (ShutdownSignalException e6) {
                        if (RabbitUtils.isNormalShutdown(e6)) return;
                        CachingConnectionFactory.this.logger.debug((Object)"Unexpected exception on deferred close", (Throwable)e6);
                        return;
                    }
                    finally {
                        CachingConnectionFactory.this.inFlightAsyncCloses.release(channel);
                        this.releasePermitIfNecessary();
                    }
                    catch (InterruptedException e12222222) {
                        Thread.currentThread().interrupt();
                        try {
                            channel.close();
                            return;
                        }
                        catch (AlreadyClosedException | IOException | TimeoutException e12222222) {
                            return;
                        }
                        catch (ShutdownSignalException e62222222) {
                            if (RabbitUtils.isNormalShutdown(e62222222)) return;
                            CachingConnectionFactory.this.logger.debug((Object)"Unexpected exception on deferred close", (Throwable)e62222222);
                            return;
                        }
                        finally {
                            CachingConnectionFactory.this.inFlightAsyncCloses.release(channel);
                            this.releasePermitIfNecessary();
                        }
                    }
                    catch (Exception e62222222) {
                        try {
                            channel.close();
                            return;
                        }
                        catch (AlreadyClosedException | IOException | TimeoutException e62222222) {
                            return;
                        }
                        catch (ShutdownSignalException e63) {
                            if (RabbitUtils.isNormalShutdown(e63)) return;
                            CachingConnectionFactory.this.logger.debug((Object)"Unexpected exception on deferred close", (Throwable)e63);
                            return;
                        }
                        finally {
                            CachingConnectionFactory.this.inFlightAsyncCloses.release(channel);
                            this.releasePermitIfNecessary();
                        }
                    }
                    {
                        catch (Throwable throwable) {
                            try {
                                channel.close();
                                throw throwable;
                            }
                            catch (AlreadyClosedException | IOException | TimeoutException throwable2) {
                                throw throwable;
                            }
                            catch (ShutdownSignalException e6) {
                                if (RabbitUtils.isNormalShutdown(e6)) throw throwable;
                                CachingConnectionFactory.this.logger.debug((Object)"Unexpected exception on deferred close", (Throwable)e6);
                                throw throwable;
                            }
                            finally {
                                CachingConnectionFactory.this.inFlightAsyncCloses.release(channel);
                                this.releasePermitIfNecessary();
                            }
                        }
                    }
                });
            }
            catch (RuntimeException e) {
                CachingConnectionFactory.this.inFlightAsyncCloses.release(channel);
            }
        }
    }
}

