/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.rabbit.listener.MethodRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.adapter.DelegatingInvocableHandler;
import org.springframework.amqp.rabbit.listener.adapter.HandlerAdapter;
import org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.validation.Validator;

public class MultiMethodRabbitListenerEndpoint
extends MethodRabbitListenerEndpoint {
    private final List<Method> methods;
    private final @Nullable Method defaultMethod;
    private @Nullable Validator validator;

    public MultiMethodRabbitListenerEndpoint(List<Method> methods, @Nullable Method defaultMethod, Object bean) {
        this.methods = methods;
        this.defaultMethod = defaultMethod;
        this.setBean(bean);
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    @Override
    protected HandlerAdapter configureListenerAdapter(MessagingMessageListenerAdapter messageListener) {
        ArrayList<InvocableHandlerMethod> invocableHandlerMethods = new ArrayList<InvocableHandlerMethod>();
        InvocableHandlerMethod defaultHandler = null;
        MessageHandlerMethodFactory messageHandlerMethodFactory = this.getMessageHandlerMethodFactory();
        Assert.state((messageHandlerMethodFactory != null ? 1 : 0) != 0, (String)"Could not create message listener - MessageHandlerMethodFactory not set");
        Object beanToUse = this.getBean();
        for (Method method : this.methods) {
            InvocableHandlerMethod handler = messageHandlerMethodFactory.createInvocableHandlerMethod(beanToUse, method);
            invocableHandlerMethods.add(handler);
            if (!method.equals(this.defaultMethod)) continue;
            defaultHandler = handler;
        }
        DelegatingInvocableHandler delegatingHandler = new DelegatingInvocableHandler(invocableHandlerMethods, defaultHandler, this.getBean(), this.getResolver(), this.getBeanExpressionContext(), this.validator);
        return new HandlerAdapter(delegatingHandler);
    }
}

