/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.test;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Envelope;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;
import org.springframework.amqp.rabbit.listener.adapter.AbstractAdaptableMessageListener;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareMessageListener;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.Assert;

public class TestRabbitTemplate
extends RabbitTemplate
implements ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent> {
    private static final String REPLY_QUEUE = "testRabbitTemplateReplyTo";
    private final Map<String, Listeners> listeners = new HashMap<String, Listeners>();
    private ApplicationContext applicationContext;
    @Autowired
    private RabbitListenerEndpointRegistry registry;

    public TestRabbitTemplate(ConnectionFactory connectionFactory) {
        super(connectionFactory);
        this.setReplyAddress(REPLY_QUEUE);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().equals((Object)this.applicationContext)) {
            Stream<AbstractMessageListenerContainer> registryListenerContainers = this.registry.getListenerContainers().stream().map(AbstractMessageListenerContainer.class::cast);
            Stream listenerContainerBeans = this.applicationContext.getBeansOfType(AbstractMessageListenerContainer.class).values().stream();
            Stream.concat(registryListenerContainers, listenerContainerBeans).forEach(container -> Arrays.stream(container.getQueueNames()).forEach(queue -> this.setupListener((AbstractMessageListenerContainer)container, (String)queue)));
        }
    }

    private void setupListener(AbstractMessageListenerContainer container, String queue) {
        MessageListener messageListener = container.getMessageListener();
        Assert.notNull((Object)messageListener, (String)"'container.getMessageListener()' must not be null");
        this.listeners.computeIfAbsent((String)queue, (Function<String, Listeners>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setupListener$0(java.lang.String ), (Ljava/lang/String;)Lorg/springframework/amqp/rabbit/test/TestRabbitTemplate$Listeners;)()).listeners.add(messageListener);
    }

    protected boolean useDirectReplyTo() {
        return false;
    }

    protected void sendToRabbit(Channel channel, String exchange, String routingKey, boolean mandatory, Message message) {
        Listeners listenersForRoute = this.listeners.get(routingKey);
        if (listenersForRoute == null) {
            throw new IllegalArgumentException("No listener for " + routingKey);
        }
        try {
            this.invoke(listenersForRoute.next(), message, channel);
        }
        catch (Exception e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException((Throwable)e);
        }
    }

    protected @Nullable Message doSendAndReceiveWithFixed(@Nullable String exchange, @Nullable String routingKey, Message message, @Nullable CorrelationData correlationData) {
        Listeners listenersForRoute = this.listeners.get(routingKey);
        if (listenersForRoute == null) {
            throw new IllegalArgumentException("No listener for " + routingKey);
        }
        Channel channel = (Channel)Mockito.mock(Channel.class);
        AtomicReference reply = new AtomicReference();
        Object listener = listenersForRoute.next();
        if (listener instanceof AbstractAdaptableMessageListener) {
            AbstractAdaptableMessageListener adapter = (AbstractAdaptableMessageListener)listener;
            try {
                ((Channel)BDDMockito.willAnswer(i -> {
                    Envelope envelope = new Envelope(1L, false, "", REPLY_QUEUE);
                    reply.set(MessageBuilder.withBody((byte[])((byte[])i.getArgument(4))).andProperties(this.getMessagePropertiesConverter().toMessageProperties((AMQP.BasicProperties)i.getArgument(3), envelope, adapter.getEncoding())).build());
                    return null;
                }).given((Object)channel)).basicPublish(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (AMQP.BasicProperties)ArgumentMatchers.any(AMQP.BasicProperties.class), (byte[])ArgumentMatchers.any(byte[].class));
                message.getMessageProperties().setReplyTo(REPLY_QUEUE);
                adapter.onMessage(message, channel);
            }
            catch (Exception e) {
                throw RabbitExceptionTranslator.convertRabbitAccessException((Throwable)e);
            }
        } else {
            throw new IllegalStateException("sendAndReceive not supported for " + String.valueOf(listener));
        }
        return (Message)reply.get();
    }

    private void invoke(Object listener, Message message, Channel channel) {
        if (listener instanceof ChannelAwareMessageListener) {
            ChannelAwareMessageListener channelAwareMessageListener = (ChannelAwareMessageListener)listener;
            try {
                channelAwareMessageListener.onMessage(message, channel);
            }
            catch (Exception e) {
                throw RabbitExceptionTranslator.convertRabbitAccessException((Throwable)e);
            }
        } else if (listener instanceof MessageListener) {
            MessageListener messageListener = (MessageListener)listener;
            messageListener.onMessage(message);
        } else {
            throw new IllegalStateException("Listener of type " + listener.getClass().getName() + " is not supported");
        }
    }

    private static /* synthetic */ Listeners lambda$setupListener$0(String v) {
        return new Listeners();
    }

    private static class Listeners {
        private final Lock lock = new ReentrantLock();
        private final List<Object> listeners = new ArrayList<Object>();
        private volatile @Nullable Iterator<Object> iterator;

        Listeners() {
        }

        private Object next() {
            this.lock.lock();
            try {
                Iterator<Object> iteratorToUse = this.iterator;
                if (iteratorToUse == null || !iteratorToUse.hasNext()) {
                    iteratorToUse = this.listeners.iterator();
                }
                this.iterator = iteratorToUse;
                Object object = iteratorToUse.next();
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

