/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.JacksonJavaTypeMapper;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.type.TypeFactory;

public class DefaultJacksonJavaTypeMapper
implements JacksonJavaTypeMapper,
BeanClassLoaderAware {
    private static final List<String> TRUSTED_PACKAGES = Arrays.asList("java.util", "java.lang");
    private final Set<String> trustedPackages = new LinkedHashSet<String>(TRUSTED_PACKAGES);
    private volatile JacksonJavaTypeMapper.TypePrecedence typePrecedence = JacksonJavaTypeMapper.TypePrecedence.INFERRED;
    public static final String DEFAULT_CLASSID_FIELD_NAME = "__TypeId__";
    public static final String DEFAULT_CONTENT_CLASSID_FIELD_NAME = "__ContentTypeId__";
    public static final String DEFAULT_KEY_CLASSID_FIELD_NAME = "__KeyTypeId__";
    private final Map<String, Class<?>> idClassMapping = new HashMap();
    private final Map<Class<?>, String> classIdMapping = new HashMap();
    private @Nullable ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
    private TypeFactory typeFactory = TypeFactory.createDefaultInstance();

    public String getClassIdFieldName() {
        return DEFAULT_CLASSID_FIELD_NAME;
    }

    public String getContentClassIdFieldName() {
        return DEFAULT_CONTENT_CLASSID_FIELD_NAME;
    }

    public String getKeyClassIdFieldName() {
        return DEFAULT_KEY_CLASSID_FIELD_NAME;
    }

    public void setIdClassMapping(Map<String, Class<?>> idClassMapping) {
        this.idClassMapping.putAll(idClassMapping);
        this.createReverseMap();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.typeFactory = this.typeFactory.withClassLoader(classLoader);
    }

    protected @Nullable ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected void addHeader(MessageProperties properties, String headerName, Class<?> clazz) {
        if (this.classIdMapping.containsKey(clazz)) {
            properties.getHeaders().put(headerName, this.classIdMapping.get(clazz));
        } else {
            properties.getHeaders().put(headerName, clazz.getName());
        }
    }

    protected String retrieveHeader(MessageProperties properties, String headerName) {
        String classId = this.retrieveHeaderAsString(properties, headerName);
        if (classId == null) {
            throw new MessageConversionException("failed to convert Message content. Could not resolve " + headerName + " in header");
        }
        return classId;
    }

    protected @Nullable String retrieveHeaderAsString(MessageProperties properties, String headerName) {
        Map<String, @Nullable Object> headers = properties.getHeaders();
        Object classIdFieldNameValue = headers.get(headerName);
        return classIdFieldNameValue != null ? classIdFieldNameValue.toString() : null;
    }

    private void createReverseMap() {
        this.classIdMapping.clear();
        for (Map.Entry<String, Class<?>> entry : this.idClassMapping.entrySet()) {
            String id = entry.getKey();
            Class<?> clazz = entry.getValue();
            this.classIdMapping.put(clazz, id);
        }
    }

    public Map<String, Class<?>> getIdClassMapping() {
        return Collections.unmodifiableMap(this.idClassMapping);
    }

    protected boolean hasInferredTypeHeader(MessageProperties properties) {
        return properties.getInferredArgumentType() != null;
    }

    protected JavaType fromInferredTypeHeader(MessageProperties properties) {
        return this.typeFactory.constructType(properties.getInferredArgumentType());
    }

    @Override
    public JacksonJavaTypeMapper.TypePrecedence getTypePrecedence() {
        return this.typePrecedence;
    }

    public void setTypePrecedence(JacksonJavaTypeMapper.TypePrecedence typePrecedence) {
        Assert.notNull((Object)((Object)typePrecedence), (String)"'typePrecedence' cannot be null");
        this.typePrecedence = typePrecedence;
    }

    public void setTrustedPackages(String ... trustedPackages) {
        if (trustedPackages != null) {
            for (String trusted : trustedPackages) {
                if ("*".equals(trusted)) {
                    this.trustedPackages.clear();
                    break;
                }
                this.trustedPackages.add(trusted);
            }
        }
    }

    @Override
    public void addTrustedPackages(String ... packages) {
        this.setTrustedPackages(packages);
    }

    @Override
    public JavaType toJavaType(MessageProperties properties) {
        JavaType inferredType = this.getInferredType(properties);
        if (inferredType != null && this.canConvert(inferredType)) {
            return inferredType;
        }
        String typeIdHeader = this.retrieveHeaderAsString(properties, this.getClassIdFieldName());
        if (typeIdHeader != null) {
            return this.fromTypeHeader(properties, typeIdHeader);
        }
        if (this.hasInferredTypeHeader(properties)) {
            return this.fromInferredTypeHeader(properties);
        }
        return this.typeFactory.constructType(Object.class);
    }

    private boolean canConvert(JavaType inferredType) {
        if (inferredType.isAbstract() && !inferredType.isContainerType()) {
            return false;
        }
        if (inferredType.isContainerType() && inferredType.getContentType().isAbstract()) {
            return false;
        }
        return inferredType.getKeyType() == null || !inferredType.getKeyType().isAbstract();
    }

    private JavaType fromTypeHeader(MessageProperties properties, String typeIdHeader) {
        JavaType classType = this.getClassIdType(typeIdHeader);
        if (!classType.isContainerType() || classType.isArrayType()) {
            return classType;
        }
        JavaType contentClassType = this.getClassIdType(this.retrieveHeader(properties, this.getContentClassIdFieldName()));
        if (classType.getKeyType() == null) {
            return this.typeFactory.constructCollectionLikeType(classType.getRawClass(), contentClassType);
        }
        JavaType keyClassType = this.getClassIdType(this.retrieveHeader(properties, this.getKeyClassIdFieldName()));
        return this.typeFactory.constructMapLikeType(classType.getRawClass(), keyClassType, contentClassType);
    }

    @Override
    public @Nullable JavaType getInferredType(MessageProperties properties) {
        if (this.typePrecedence.equals((Object)JacksonJavaTypeMapper.TypePrecedence.INFERRED) && this.hasInferredTypeHeader(properties)) {
            return this.fromInferredTypeHeader(properties);
        }
        return null;
    }

    private JavaType getClassIdType(String classId) {
        if (this.getIdClassMapping().containsKey(classId)) {
            return this.typeFactory.constructType((Type)this.getIdClassMapping().get(classId));
        }
        try {
            if (!this.isTrustedPackage(classId)) {
                throw new IllegalArgumentException("The class '" + classId + "' is not in the trusted packages: " + String.valueOf(this.trustedPackages) + ". If you believe this class is safe to deserialize, please provide its name. If the serialization is only done by a trusted source, you can also enable trust all (*).");
            }
            return this.typeFactory.constructType((Type)ClassUtils.forName((String)classId, (ClassLoader)this.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new MessageConversionException("failed to resolve class name. Class not found [" + classId + "]", e);
        }
        catch (LinkageError e) {
            throw new MessageConversionException("failed to resolve class name. Linkage error [" + classId + "]", e);
        }
    }

    private boolean isTrustedPackage(String requestedType) {
        if (!this.trustedPackages.isEmpty()) {
            String packageName = ClassUtils.getPackageName((String)requestedType).replaceFirst("\\[L", "");
            for (String trustedPackage : this.trustedPackages) {
                if (!packageName.equals(trustedPackage)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void fromJavaType(JavaType javaType, MessageProperties properties) {
        this.addHeader(properties, this.getClassIdFieldName(), javaType.getRawClass());
        if (javaType.isContainerType() && !javaType.isArrayType()) {
            this.addHeader(properties, this.getContentClassIdFieldName(), javaType.getContentType().getRawClass());
        }
        if (javaType.getKeyType() != null) {
            this.addHeader(properties, this.getKeyClassIdFieldName(), javaType.getKeyType().getRawClass());
        }
    }

    @Override
    public void fromClass(Class<?> clazz, MessageProperties properties) {
        this.fromJavaType(this.typeFactory.constructType(clazz), properties);
    }

    @Override
    public Class<?> toClass(MessageProperties properties) {
        return this.toJavaType(properties).getRawClass();
    }
}

