/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.utils;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.springframework.util.StringUtils;

public final class JavaUtils {
    public static final JavaUtils INSTANCE = new JavaUtils();

    private JavaUtils() {
    }

    public <T> JavaUtils acceptIfCondition(boolean condition, T value, Consumer<T> consumer) {
        if (condition) {
            consumer.accept(value);
        }
        return this;
    }

    public <T> JavaUtils acceptIfNotNull(T value, Consumer<T> consumer) {
        if (value != null) {
            consumer.accept(value);
        }
        return this;
    }

    public JavaUtils acceptIfHasText(String value, Consumer<String> consumer) {
        if (StringUtils.hasText((String)value)) {
            consumer.accept(value);
        }
        return this;
    }

    public <T1, T2> JavaUtils acceptIfCondition(boolean condition, T1 t1, T2 t2, BiConsumer<T1, T2> consumer) {
        if (condition) {
            consumer.accept(t1, t2);
        }
        return this;
    }

    public <T1, T2> JavaUtils acceptIfNotNull(T1 t1, T2 t2, BiConsumer<T1, T2> consumer) {
        if (t2 != null) {
            consumer.accept(t1, t2);
        }
        return this;
    }

    public <T> JavaUtils acceptIfHasText(T t1, String value, BiConsumer<T, String> consumer) {
        if (StringUtils.hasText((String)value)) {
            consumer.accept(t1, value);
        }
        return this;
    }
}

