/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.google.genai;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.genai.Client;
import com.google.genai.ResponseStream;
import com.google.genai.types.Candidate;
import com.google.genai.types.Content;
import com.google.genai.types.FinishReason;
import com.google.genai.types.FunctionCall;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.FunctionResponse;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.GenerateContentResponse;
import com.google.genai.types.GenerateContentResponseUsageMetadata;
import com.google.genai.types.GoogleSearch;
import com.google.genai.types.HarmBlockThreshold;
import com.google.genai.types.HarmCategory;
import com.google.genai.types.Part;
import com.google.genai.types.SafetySetting;
import com.google.genai.types.Schema;
import com.google.genai.types.ThinkingConfig;
import com.google.genai.types.Tool;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.content.Media;
import org.springframework.ai.google.genai.GoogleGenAiChatOptions;
import org.springframework.ai.google.genai.cache.GoogleGenAiCachedContentService;
import org.springframework.ai.google.genai.common.GoogleGenAiConstants;
import org.springframework.ai.google.genai.common.GoogleGenAiSafetySetting;
import org.springframework.ai.google.genai.metadata.GoogleGenAiUsage;
import org.springframework.ai.google.genai.schema.GoogleGenAiToolCallingManager;
import org.springframework.ai.model.ChatModelDescription;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.tool.DefaultToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolExecutionResult;
import org.springframework.ai.model.tool.internal.ToolCallReactiveContextHolder;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.ai.support.UsageCalculator;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.lang.NonNull;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.ContextView;

public class GoogleGenAiChatModel
implements org.springframework.ai.chat.model.ChatModel,
DisposableBean {
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultChatModelObservationConvention();
    private static final ToolCallingManager DEFAULT_TOOL_CALLING_MANAGER = ToolCallingManager.builder().build();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Client genAiClient;
    private final GoogleGenAiChatOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final GoogleGenAiCachedContentService cachedContentService;
    private final ObservationRegistry observationRegistry;
    private final ToolCallingManager toolCallingManager;
    private final ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public GoogleGenAiChatModel(Client genAiClient, GoogleGenAiChatOptions defaultOptions, ToolCallingManager toolCallingManager, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        this(genAiClient, defaultOptions, toolCallingManager, retryTemplate, observationRegistry, (ToolExecutionEligibilityPredicate)new DefaultToolExecutionEligibilityPredicate());
    }

    public GoogleGenAiChatModel(Client genAiClient, GoogleGenAiChatOptions defaultOptions, ToolCallingManager toolCallingManager, RetryTemplate retryTemplate, ObservationRegistry observationRegistry, ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate) {
        Assert.notNull((Object)genAiClient, (String)"GenAI Client must not be null");
        Assert.notNull((Object)defaultOptions, (String)"GoogleGenAiChatOptions must not be null");
        Assert.notNull((Object)defaultOptions.getModel(), (String)"GoogleGenAiChatOptions.modelName must not be null");
        Assert.notNull((Object)retryTemplate, (String)"RetryTemplate must not be null");
        Assert.notNull((Object)toolCallingManager, (String)"ToolCallingManager must not be null");
        Assert.notNull((Object)toolExecutionEligibilityPredicate, (String)"ToolExecutionEligibilityPredicate must not be null");
        this.genAiClient = genAiClient;
        this.defaultOptions = defaultOptions;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
        this.toolExecutionEligibilityPredicate = toolExecutionEligibilityPredicate;
        this.cachedContentService = genAiClient != null && genAiClient.caches != null && genAiClient.async != null && genAiClient.async.caches != null ? new GoogleGenAiCachedContentService(genAiClient) : null;
        this.toolCallingManager = toolCallingManager instanceof GoogleGenAiToolCallingManager ? toolCallingManager : new GoogleGenAiToolCallingManager(toolCallingManager);
    }

    private static GeminiMessageType toGeminiMessageType(@NonNull MessageType type) {
        Assert.notNull((Object)type, (String)"Message type must not be null");
        switch (type) {
            case SYSTEM: 
            case USER: 
            case TOOL: {
                return GeminiMessageType.USER;
            }
            case ASSISTANT: {
                return GeminiMessageType.MODEL;
            }
        }
        throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(type));
    }

    static List<Part> messageToGeminiParts(Message message) {
        if (message instanceof SystemMessage) {
            SystemMessage systemMessage = (SystemMessage)message;
            ArrayList<Part> parts = new ArrayList<Part>();
            if (systemMessage.getText() != null) {
                parts.add(Part.fromText((String)systemMessage.getText()));
            }
            return parts;
        }
        if (message instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)message;
            ArrayList<Part> parts = new ArrayList<Part>();
            if (userMessage.getText() != null) {
                parts.add(Part.fromText((String)userMessage.getText()));
            }
            parts.addAll(GoogleGenAiChatModel.mediaToParts(userMessage.getMedia()));
            return parts;
        }
        if (message instanceof AssistantMessage) {
            AssistantMessage assistantMessage = (AssistantMessage)message;
            ArrayList<Part> parts = new ArrayList<Part>();
            if (StringUtils.hasText((String)assistantMessage.getText())) {
                parts.add(Part.fromText((String)assistantMessage.getText()));
            }
            if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                parts.addAll(assistantMessage.getToolCalls().stream().map(toolCall -> Part.builder().functionCall(FunctionCall.builder().name(toolCall.name()).args(GoogleGenAiChatModel.parseJsonToMap(toolCall.arguments())).build()).build()).toList());
            }
            return parts;
        }
        if (message instanceof ToolResponseMessage) {
            ToolResponseMessage toolResponseMessage = (ToolResponseMessage)message;
            return toolResponseMessage.getResponses().stream().map(response -> Part.builder().functionResponse(FunctionResponse.builder().name(response.name()).response(GoogleGenAiChatModel.parseJsonToMap(response.responseData())).build()).build()).toList();
        }
        throw new IllegalArgumentException("Gemini doesn't support message type: " + String.valueOf(message.getClass()));
    }

    private static List<Part> mediaToParts(Collection<Media> media) {
        ArrayList<Part> parts = new ArrayList<Part>();
        List<Part> mediaParts = media.stream().map(mediaData -> {
            Object data = mediaData.getData();
            String mimeType = mediaData.getMimeType().toString();
            if (data instanceof byte[]) {
                return Part.fromBytes((byte[])((byte[])data), (String)mimeType);
            }
            if (data instanceof URI || data instanceof String) {
                String uri = data.toString();
                return Part.fromUri((String)uri, (String)mimeType);
            }
            throw new IllegalArgumentException("Unsupported media data type: " + String.valueOf(data.getClass()));
        }).toList();
        if (!CollectionUtils.isEmpty(mediaParts)) {
            parts.addAll(mediaParts);
        }
        return parts;
    }

    private static Map<String, Object> parseJsonToMap(String json) {
        try {
            Object parsed = ModelOptionsUtils.OBJECT_MAPPER.readValue(json, Object.class);
            if (parsed instanceof List) {
                HashMap<String, Object> wrapper = new HashMap<String, Object>();
                wrapper.put("result", parsed);
                return wrapper;
            }
            if (parsed instanceof Map) {
                return (Map)parsed;
            }
            HashMap<String, Object> wrapper = new HashMap<String, Object>();
            wrapper.put("result", parsed);
            return wrapper;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse JSON: " + json, e);
        }
    }

    private static String mapToJson(Map<String, Object> map) {
        try {
            return ModelOptionsUtils.OBJECT_MAPPER.writeValueAsString(map);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert map to JSON", e);
        }
    }

    private static Schema jsonToSchema(String json) {
        try {
            return (Schema)ModelOptionsUtils.OBJECT_MAPPER.readValue(json, Schema.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ChatResponse call(Prompt prompt) {
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalCall(requestPrompt, null);
    }

    private ChatResponse internalCall(Prompt prompt, ChatResponse previousChatResponse) {
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(GoogleGenAiConstants.PROVIDER_NAME).build();
        ChatResponse response = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> (ChatResponse)this.retryTemplate.execute(context -> {
            GeminiRequest geminiRequest = this.createGeminiRequest(prompt);
            GenerateContentResponse generateContentResponse = this.getContentResponse(geminiRequest);
            List generations = generateContentResponse.candidates().orElse(List.of()).stream().map(this::responseCandidateToGeneration).flatMap(Collection::stream).toList();
            Optional usage = generateContentResponse.usageMetadata();
            GoogleGenAiChatOptions options = (GoogleGenAiChatOptions)prompt.getOptions();
            Usage currentUsage = usage.isPresent() ? this.getDefaultUsage((GenerateContentResponseUsageMetadata)usage.get(), options) : this.getDefaultUsage(null, options);
            Usage cumulativeUsage = UsageCalculator.getCumulativeUsage((Usage)currentUsage, (ChatResponse)previousChatResponse);
            ChatResponse chatResponse = new ChatResponse(generations, this.toChatResponseMetadata(cumulativeUsage, (String)generateContentResponse.modelVersion().get()));
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        }));
        if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(prompt.getOptions(), response)) {
            ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, response);
            if (toolExecutionResult.returnDirect()) {
                return ChatResponse.builder().from(response).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build();
            }
            return this.internalCall(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), response);
        }
        return response;
    }

    Prompt buildRequestPrompt(Prompt prompt) {
        GoogleGenAiChatOptions runtimeOptions = null;
        if (prompt.getOptions() != null) {
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof ToolCallingChatOptions) {
                ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)chatOptions;
                runtimeOptions = (GoogleGenAiChatOptions)ModelOptionsUtils.copyToTarget((Object)toolCallingChatOptions, ToolCallingChatOptions.class, GoogleGenAiChatOptions.class);
            } else {
                runtimeOptions = (GoogleGenAiChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, GoogleGenAiChatOptions.class);
            }
        }
        GoogleGenAiChatOptions requestOptions = (GoogleGenAiChatOptions)ModelOptionsUtils.merge(runtimeOptions, (Object)this.defaultOptions, GoogleGenAiChatOptions.class);
        if (runtimeOptions != null) {
            requestOptions.setInternalToolExecutionEnabled((Boolean)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getInternalToolExecutionEnabled(), (Object)this.defaultOptions.getInternalToolExecutionEnabled()));
            requestOptions.setToolNames(ToolCallingChatOptions.mergeToolNames(runtimeOptions.getToolNames(), this.defaultOptions.getToolNames()));
            requestOptions.setToolCallbacks(ToolCallingChatOptions.mergeToolCallbacks(runtimeOptions.getToolCallbacks(), this.defaultOptions.getToolCallbacks()));
            requestOptions.setToolContext(ToolCallingChatOptions.mergeToolContext(runtimeOptions.getToolContext(), this.defaultOptions.getToolContext()));
            requestOptions.setGoogleSearchRetrieval((Boolean)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getGoogleSearchRetrieval(), (Object)this.defaultOptions.getGoogleSearchRetrieval()));
            requestOptions.setSafetySettings((List)ModelOptionsUtils.mergeOption(runtimeOptions.getSafetySettings(), this.defaultOptions.getSafetySettings()));
            requestOptions.setLabels((Map)ModelOptionsUtils.mergeOption(runtimeOptions.getLabels(), this.defaultOptions.getLabels()));
        } else {
            requestOptions.setInternalToolExecutionEnabled(this.defaultOptions.getInternalToolExecutionEnabled());
            requestOptions.setToolNames(this.defaultOptions.getToolNames());
            requestOptions.setToolCallbacks(this.defaultOptions.getToolCallbacks());
            requestOptions.setToolContext(this.defaultOptions.getToolContext());
            requestOptions.setGoogleSearchRetrieval(this.defaultOptions.getGoogleSearchRetrieval());
            requestOptions.setSafetySettings(this.defaultOptions.getSafetySettings());
            requestOptions.setLabels(this.defaultOptions.getLabels());
        }
        ToolCallingChatOptions.validateToolCallbacks(requestOptions.getToolCallbacks());
        return new Prompt(prompt.getInstructions(), (ChatOptions)requestOptions);
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalStream(requestPrompt, null);
    }

    public Flux<ChatResponse> internalStream(Prompt prompt, ChatResponse previousChatResponse) {
        return Flux.deferContextual(contextView -> {
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(GoogleGenAiConstants.PROVIDER_NAME).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            GeminiRequest request = this.createGeminiRequest(prompt);
            try {
                ResponseStream responseStream = this.genAiClient.models.generateContentStream(request.modelName, request.contents, request.config);
                Flux chatResponseFlux = Flux.fromIterable((Iterable)responseStream).switchMap(response -> {
                    List generations = response.candidates().orElse(List.of()).stream().map(this::responseCandidateToGeneration).flatMap(Collection::stream).toList();
                    Optional usage = response.usageMetadata();
                    GoogleGenAiChatOptions options = (GoogleGenAiChatOptions)prompt.getOptions();
                    Usage currentUsage = usage.isPresent() ? this.getDefaultUsage((GenerateContentResponseUsageMetadata)usage.get(), options) : this.getDefaultUsage(null, options);
                    Usage cumulativeUsage = UsageCalculator.getCumulativeUsage((Usage)currentUsage, (ChatResponse)previousChatResponse);
                    ChatResponse chatResponse = new ChatResponse(generations, this.toChatResponseMetadata(cumulativeUsage, (String)response.modelVersion().get()));
                    return Flux.just((Object)chatResponse);
                });
                Flux flux = chatResponseFlux.flatMap(response -> {
                    if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(prompt.getOptions(), response)) {
                        return Flux.deferContextual(ctx -> {
                            ToolExecutionResult toolExecutionResult;
                            try {
                                ToolCallReactiveContextHolder.setContext((ContextView)ctx);
                                toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, response);
                            }
                            finally {
                                ToolCallReactiveContextHolder.clearContext();
                            }
                            if (toolExecutionResult.returnDirect()) {
                                return Flux.just((Object)ChatResponse.builder().from(response).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build());
                            }
                            return this.internalStream(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), (ChatResponse)response);
                        }).subscribeOn(Schedulers.boundedElastic());
                    }
                    return Flux.just((Object)response);
                }).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
                return new MessageAggregator().aggregate(flux, arg_0 -> ((ChatModelObservationContext)observationContext).setResponse(arg_0));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to generate content", e);
            }
        });
    }

    protected List<Generation> responseCandidateToGeneration(Candidate candidate) {
        boolean isFunctionCall;
        int candidateIndex = candidate.index().orElse(0);
        FinishReason candidateFinishReason = candidate.finishReason().orElse(new FinishReason(FinishReason.Known.STOP));
        Map<String, FinishReason> messageMetadata = Map.of("candidateIndex", candidateIndex, "finishReason", candidateFinishReason);
        ChatGenerationMetadata chatGenerationMetadata = ChatGenerationMetadata.builder().finishReason(candidateFinishReason.toString()).build();
        boolean bl = isFunctionCall = candidate.content().isPresent() && ((Content)candidate.content().get()).parts().isPresent() && ((List)((Content)candidate.content().get()).parts().get()).stream().allMatch(part -> part.functionCall().isPresent());
        if (isFunctionCall) {
            List<AssistantMessage.ToolCall> assistantToolCalls = ((Content)candidate.content().get()).parts().orElse(List.of()).stream().filter(part -> part.functionCall().isPresent()).map(part -> {
                FunctionCall functionCall = (FunctionCall)part.functionCall().get();
                String functionName = functionCall.name().orElse("");
                String functionArguments = GoogleGenAiChatModel.mapToJson(functionCall.args().orElse(Map.of()));
                return new AssistantMessage.ToolCall("", "function", functionName, functionArguments);
            }).toList();
            AssistantMessage assistantMessage2 = AssistantMessage.builder().content("").properties(messageMetadata).toolCalls(assistantToolCalls).build();
            return List.of(new Generation(assistantMessage2, chatGenerationMetadata));
        }
        return ((Content)candidate.content().get()).parts().orElse(List.of()).stream().map(part -> AssistantMessage.builder().content(part.text().orElse("")).properties(messageMetadata).build()).map(assistantMessage -> new Generation(assistantMessage, chatGenerationMetadata)).toList();
    }

    private ChatResponseMetadata toChatResponseMetadata(Usage usage, String modelVersion) {
        return ChatResponseMetadata.builder().usage(usage).model(modelVersion).build();
    }

    private Usage getDefaultUsage(GenerateContentResponseUsageMetadata usageMetadata, GoogleGenAiChatOptions options) {
        boolean includeExtended = true;
        if (options != null && options.getIncludeExtendedUsageMetadata() != null) {
            includeExtended = options.getIncludeExtendedUsageMetadata();
        } else if (this.defaultOptions.getIncludeExtendedUsageMetadata() != null) {
            includeExtended = this.defaultOptions.getIncludeExtendedUsageMetadata();
        }
        if (includeExtended) {
            return GoogleGenAiUsage.from(usageMetadata);
        }
        return new DefaultUsage(usageMetadata.promptTokenCount().orElse(0), usageMetadata.candidatesTokenCount().orElse(0), usageMetadata.totalTokenCount().orElse(0));
    }

    GeminiRequest createGeminiRequest(Prompt prompt) {
        List<Content> systemContents;
        GoogleGenAiChatOptions options;
        ChatOptions chatOptions;
        String modelName;
        GoogleGenAiChatOptions requestOptions = (GoogleGenAiChatOptions)prompt.getOptions();
        GenerateContentConfig.Builder configBuilder = GenerateContentConfig.builder();
        String string = modelName = requestOptions.getModel() != null ? requestOptions.getModel() : this.defaultOptions.getModel();
        if (requestOptions.getTemperature() != null) {
            configBuilder.temperature(Float.valueOf(requestOptions.getTemperature().floatValue()));
        }
        if (requestOptions.getMaxOutputTokens() != null) {
            configBuilder.maxOutputTokens(requestOptions.getMaxOutputTokens());
        }
        if (requestOptions.getTopK() != null) {
            configBuilder.topK(Float.valueOf(requestOptions.getTopK().floatValue()));
        }
        if (requestOptions.getTopP() != null) {
            configBuilder.topP(Float.valueOf(requestOptions.getTopP().floatValue()));
        }
        if (requestOptions.getCandidateCount() != null) {
            configBuilder.candidateCount(requestOptions.getCandidateCount());
        }
        if (requestOptions.getStopSequences() != null) {
            configBuilder.stopSequences(requestOptions.getStopSequences());
        }
        if (requestOptions.getResponseMimeType() != null) {
            configBuilder.responseMimeType(requestOptions.getResponseMimeType());
        }
        if (requestOptions.getFrequencyPenalty() != null) {
            configBuilder.frequencyPenalty(Float.valueOf(requestOptions.getFrequencyPenalty().floatValue()));
        }
        if (requestOptions.getPresencePenalty() != null) {
            configBuilder.presencePenalty(Float.valueOf(requestOptions.getPresencePenalty().floatValue()));
        }
        if (requestOptions.getThinkingBudget() != null) {
            configBuilder.thinkingConfig(ThinkingConfig.builder().thinkingBudget(requestOptions.getThinkingBudget()).build());
        }
        if (requestOptions.getLabels() != null && !requestOptions.getLabels().isEmpty()) {
            configBuilder.labels(requestOptions.getLabels());
        }
        if (!CollectionUtils.isEmpty(requestOptions.getSafetySettings())) {
            configBuilder.safetySettings(this.toGeminiSafetySettings(requestOptions.getSafetySettings()));
        }
        ArrayList<Tool> tools = new ArrayList<Tool>();
        List toolDefinitions = this.toolCallingManager.resolveToolDefinitions((ToolCallingChatOptions)requestOptions);
        if (!CollectionUtils.isEmpty((Collection)toolDefinitions)) {
            List<FunctionDeclaration> functionDeclarations = toolDefinitions.stream().map(toolDefinition -> FunctionDeclaration.builder().name(toolDefinition.name()).description(toolDefinition.description()).parameters(GoogleGenAiChatModel.jsonToSchema(toolDefinition.inputSchema())).build()).toList();
            tools.add(Tool.builder().functionDeclarations(functionDeclarations).build());
        }
        if ((chatOptions = prompt.getOptions()) instanceof GoogleGenAiChatOptions && (options = (GoogleGenAiChatOptions)chatOptions).getGoogleSearchRetrieval().booleanValue()) {
            GoogleSearch googleSearch = GoogleSearch.builder().build();
            Tool googleSearchRetrievalTool = Tool.builder().googleSearch(googleSearch).build();
            tools.add(googleSearchRetrievalTool);
        }
        if (!CollectionUtils.isEmpty(tools)) {
            configBuilder.tools(tools);
        }
        if (requestOptions.getUseCachedContent() != null && requestOptions.getUseCachedContent().booleanValue() && requestOptions.getCachedContentName() != null) {
            configBuilder.cachedContent(requestOptions.getCachedContentName());
            this.logger.debug("Using cached content: {}", (Object)requestOptions.getCachedContentName());
        }
        if (!CollectionUtils.isEmpty(systemContents = this.toGeminiContent(prompt.getInstructions().stream().filter(m -> m.getMessageType() == MessageType.SYSTEM).toList()))) {
            Assert.isTrue((systemContents.size() <= 1 ? 1 : 0) != 0, (String)"Only one system message is allowed in the prompt");
            configBuilder.systemInstruction(systemContents.get(0));
        }
        GenerateContentConfig config = configBuilder.build();
        return new GeminiRequest(this.toGeminiContent(prompt.getInstructions().stream().filter(m -> m.getMessageType() != MessageType.SYSTEM).toList()), modelName, config);
    }

    private static HarmCategory mapToGenAiHarmCategory(GoogleGenAiSafetySetting.HarmCategory category) {
        switch (category) {
            case HARM_CATEGORY_UNSPECIFIED: {
                return new HarmCategory(HarmCategory.Known.HARM_CATEGORY_UNSPECIFIED);
            }
            case HARM_CATEGORY_HATE_SPEECH: {
                return new HarmCategory(HarmCategory.Known.HARM_CATEGORY_HATE_SPEECH);
            }
            case HARM_CATEGORY_DANGEROUS_CONTENT: {
                return new HarmCategory(HarmCategory.Known.HARM_CATEGORY_DANGEROUS_CONTENT);
            }
            case HARM_CATEGORY_HARASSMENT: {
                return new HarmCategory(HarmCategory.Known.HARM_CATEGORY_HARASSMENT);
            }
            case HARM_CATEGORY_SEXUALLY_EXPLICIT: {
                return new HarmCategory(HarmCategory.Known.HARM_CATEGORY_SEXUALLY_EXPLICIT);
            }
        }
        throw new IllegalArgumentException("Unknown HarmCategory: " + String.valueOf((Object)category));
    }

    private static HarmBlockThreshold mapToGenAiHarmBlockThreshold(GoogleGenAiSafetySetting.HarmBlockThreshold threshold) {
        switch (threshold) {
            case HARM_BLOCK_THRESHOLD_UNSPECIFIED: {
                return new HarmBlockThreshold(HarmBlockThreshold.Known.HARM_BLOCK_THRESHOLD_UNSPECIFIED);
            }
            case BLOCK_LOW_AND_ABOVE: {
                return new HarmBlockThreshold(HarmBlockThreshold.Known.BLOCK_LOW_AND_ABOVE);
            }
            case BLOCK_MEDIUM_AND_ABOVE: {
                return new HarmBlockThreshold(HarmBlockThreshold.Known.BLOCK_MEDIUM_AND_ABOVE);
            }
            case BLOCK_ONLY_HIGH: {
                return new HarmBlockThreshold(HarmBlockThreshold.Known.BLOCK_ONLY_HIGH);
            }
            case BLOCK_NONE: {
                return new HarmBlockThreshold(HarmBlockThreshold.Known.BLOCK_NONE);
            }
            case OFF: {
                return new HarmBlockThreshold(HarmBlockThreshold.Known.OFF);
            }
        }
        throw new IllegalArgumentException("Unknown HarmBlockThreshold: " + String.valueOf((Object)threshold));
    }

    private List<Content> toGeminiContent(List<Message> instructions) {
        List<Content> contents = instructions.stream().map(message -> Content.builder().role(GoogleGenAiChatModel.toGeminiMessageType(message.getMessageType()).getValue()).parts(GoogleGenAiChatModel.messageToGeminiParts(message)).build()).toList();
        return contents;
    }

    private List<SafetySetting> toGeminiSafetySettings(List<GoogleGenAiSafetySetting> safetySettings) {
        return safetySettings.stream().map(safetySetting -> SafetySetting.builder().category(GoogleGenAiChatModel.mapToGenAiHarmCategory(safetySetting.getCategory())).threshold(GoogleGenAiChatModel.mapToGenAiHarmBlockThreshold(safetySetting.getThreshold())).build()).toList();
    }

    GenerateContentResponse getContentResponse(GeminiRequest request) {
        try {
            return this.genAiClient.models.generateContent(request.modelName, request.contents, request.config);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate content", e);
        }
    }

    public ChatOptions getDefaultOptions() {
        return GoogleGenAiChatOptions.fromOptions(this.defaultOptions);
    }

    public GoogleGenAiCachedContentService getCachedContentService() {
        return this.cachedContentService;
    }

    public void destroy() throws Exception {
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum GeminiMessageType {
        USER("user"),
        MODEL("model");

        public final String value;

        private GeminiMessageType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record GeminiRequest(List<Content> contents, String modelName, GenerateContentConfig config) {
    }

    public static final class Builder {
        private Client genAiClient;
        private GoogleGenAiChatOptions defaultOptions = GoogleGenAiChatOptions.builder().temperature(0.7).topP(1.0).model(ChatModel.GEMINI_2_0_FLASH).build();
        private ToolCallingManager toolCallingManager;
        private ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate = new DefaultToolExecutionEligibilityPredicate();
        private RetryTemplate retryTemplate = RetryUtils.DEFAULT_RETRY_TEMPLATE;
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;

        private Builder() {
        }

        public Builder genAiClient(Client genAiClient) {
            this.genAiClient = genAiClient;
            return this;
        }

        public Builder defaultOptions(GoogleGenAiChatOptions defaultOptions) {
            this.defaultOptions = defaultOptions;
            return this;
        }

        public Builder toolCallingManager(ToolCallingManager toolCallingManager) {
            this.toolCallingManager = toolCallingManager;
            return this;
        }

        public Builder toolExecutionEligibilityPredicate(ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate) {
            this.toolExecutionEligibilityPredicate = toolExecutionEligibilityPredicate;
            return this;
        }

        public Builder retryTemplate(RetryTemplate retryTemplate) {
            this.retryTemplate = retryTemplate;
            return this;
        }

        public Builder observationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
            return this;
        }

        public GoogleGenAiChatModel build() {
            if (this.toolCallingManager != null) {
                return new GoogleGenAiChatModel(this.genAiClient, this.defaultOptions, this.toolCallingManager, this.retryTemplate, this.observationRegistry, this.toolExecutionEligibilityPredicate);
            }
            return new GoogleGenAiChatModel(this.genAiClient, this.defaultOptions, DEFAULT_TOOL_CALLING_MANAGER, this.retryTemplate, this.observationRegistry, this.toolExecutionEligibilityPredicate);
        }
    }

    public static enum ChatModel implements ChatModelDescription
    {
        GEMINI_1_5_PRO("gemini-1.5-pro-002"),
        GEMINI_1_5_FLASH("gemini-1.5-flash-002"),
        GEMINI_2_0_FLASH("gemini-2.0-flash-001"),
        GEMINI_2_0_FLASH_LIGHT("gemini-2.0-flash-lite-001"),
        GEMINI_2_5_PRO("gemini-2.5-pro"),
        GEMINI_2_5_FLASH("gemini-2.5-flash"),
        GEMINI_2_5_FLASH_LIGHT("gemini-2.5-flash-lite");

        public final String value;

        private ChatModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.value;
        }
    }
}

