/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.server.common.autoconfigure.annotations;

import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import java.util.List;
import org.springaicommunity.mcp.annotation.McpComplete;
import org.springaicommunity.mcp.annotation.McpPrompt;
import org.springaicommunity.mcp.annotation.McpResource;
import org.springaicommunity.mcp.annotation.McpTool;
import org.springframework.ai.mcp.annotation.spring.AsyncMcpAnnotationProviders;
import org.springframework.ai.mcp.annotation.spring.SyncMcpAnnotationProviders;
import org.springframework.ai.mcp.server.common.autoconfigure.McpServerStatelessAutoConfiguration;
import org.springframework.ai.mcp.server.common.autoconfigure.McpServerStdioDisabledCondition;
import org.springframework.ai.mcp.server.common.autoconfigure.StatelessToolCallbackConverterAutoConfiguration;
import org.springframework.ai.mcp.server.common.autoconfigure.annotations.McpServerAnnotationScannerAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration(after={McpServerAnnotationScannerAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.server.annotation-scanner", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Conditional(value={McpServerStdioDisabledCondition.class, McpServerStatelessAutoConfiguration.EnabledStatelessServerCondition.class, StatelessToolCallbackConverterAutoConfiguration.ToolCallbackConverterCondition.class})
public class StatelessServerSpecificationFactoryAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="ASYNC")
    static class AsyncStatelessServerSpecificationConfiguration {
        AsyncStatelessServerSpecificationConfiguration() {
        }

        @Bean
        public List<McpStatelessServerFeatures.AsyncResourceSpecification> resourceSpecs(McpServerAnnotationScannerAutoConfiguration.ServerMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return AsyncMcpAnnotationProviders.statelessResourceSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpResource.class));
        }

        @Bean
        public List<McpStatelessServerFeatures.AsyncPromptSpecification> promptSpecs(McpServerAnnotationScannerAutoConfiguration.ServerMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return AsyncMcpAnnotationProviders.statelessPromptSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpPrompt.class));
        }

        @Bean
        public List<McpStatelessServerFeatures.AsyncCompletionSpecification> completionSpecs(McpServerAnnotationScannerAutoConfiguration.ServerMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return AsyncMcpAnnotationProviders.statelessCompleteSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpComplete.class));
        }

        @Bean
        public List<McpStatelessServerFeatures.AsyncToolSpecification> toolSpecs(McpServerAnnotationScannerAutoConfiguration.ServerMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return AsyncMcpAnnotationProviders.statelessToolSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpTool.class));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"type"}, havingValue="SYNC", matchIfMissing=true)
    static class SyncStatelessServerSpecificationConfiguration {
        SyncStatelessServerSpecificationConfiguration() {
        }

        @Bean
        public List<McpStatelessServerFeatures.SyncResourceSpecification> resourceSpecs(McpServerAnnotationScannerAutoConfiguration.ServerMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return SyncMcpAnnotationProviders.statelessResourceSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpResource.class));
        }

        @Bean
        public List<McpStatelessServerFeatures.SyncPromptSpecification> promptSpecs(McpServerAnnotationScannerAutoConfiguration.ServerMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return SyncMcpAnnotationProviders.statelessPromptSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpPrompt.class));
        }

        @Bean
        public List<McpStatelessServerFeatures.SyncCompletionSpecification> completionSpecs(McpServerAnnotationScannerAutoConfiguration.ServerMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            return SyncMcpAnnotationProviders.statelessCompleteSpecifications((List)beansWithMcpMethodAnnotations.getBeansByAnnotation(McpComplete.class));
        }

        @Bean
        public List<McpStatelessServerFeatures.SyncToolSpecification> toolSpecs(McpServerAnnotationScannerAutoConfiguration.ServerMcpAnnotatedBeans beansWithMcpMethodAnnotations) {
            List beansByAnnotation = beansWithMcpMethodAnnotations.getBeansByAnnotation(McpTool.class);
            List syncToolSpecifications = SyncMcpAnnotationProviders.statelessToolSpecifications((List)beansByAnnotation);
            return syncToolSpecifications;
        }
    }
}

