/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.anthropic.api;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.anthropic.api.AnthropicApi;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class StreamHelper {
    private static final Logger logger = LoggerFactory.getLogger(StreamHelper.class);

    public boolean isToolUseStart(AnthropicApi.StreamEvent event) {
        if (event == null || event.type() == null || event.type() != AnthropicApi.EventType.CONTENT_BLOCK_START) {
            return false;
        }
        return AnthropicApi.ContentBlock.Type.TOOL_USE.getValue().equals(((AnthropicApi.ContentBlockStartEvent)event).contentBlock().type());
    }

    public boolean isToolUseFinish(AnthropicApi.StreamEvent event) {
        return event != null && event.type() != null && event.type() == AnthropicApi.EventType.CONTENT_BLOCK_STOP;
    }

    public AnthropicApi.StreamEvent mergeToolUseEvents(AnthropicApi.StreamEvent previousEvent, AnthropicApi.StreamEvent event) {
        if (!(previousEvent instanceof AnthropicApi.ToolUseAggregationEvent)) {
            return event;
        }
        AnthropicApi.ToolUseAggregationEvent eventAggregator = (AnthropicApi.ToolUseAggregationEvent)previousEvent;
        if (event.type() == AnthropicApi.EventType.CONTENT_BLOCK_START) {
            AnthropicApi.ContentBlockStartEvent contentBlockStart = (AnthropicApi.ContentBlockStartEvent)event;
            if (AnthropicApi.ContentBlock.Type.TOOL_USE.getValue().equals(contentBlockStart.contentBlock().type())) {
                AnthropicApi.ContentBlockStartEvent.ContentBlockToolUse cbToolUse = (AnthropicApi.ContentBlockStartEvent.ContentBlockToolUse)contentBlockStart.contentBlock();
                return eventAggregator.withIndex(contentBlockStart.index()).withId(cbToolUse.id()).withName(cbToolUse.name()).appendPartialJson("");
            }
        } else if (event.type() == AnthropicApi.EventType.CONTENT_BLOCK_DELTA) {
            AnthropicApi.ContentBlockDeltaEvent contentBlockDelta = (AnthropicApi.ContentBlockDeltaEvent)event;
            if (AnthropicApi.ContentBlock.Type.INPUT_JSON_DELTA.getValue().equals(contentBlockDelta.delta().type())) {
                return eventAggregator.appendPartialJson(((AnthropicApi.ContentBlockDeltaEvent.ContentBlockDeltaJson)contentBlockDelta.delta()).partialJson());
            }
        } else if (event.type() == AnthropicApi.EventType.CONTENT_BLOCK_STOP && !eventAggregator.isEmpty()) {
            eventAggregator.squashIntoContentBlock();
            return eventAggregator;
        }
        return event;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AnthropicApi.ChatCompletionResponse eventToChatCompletionResponse(AnthropicApi.StreamEvent event, AtomicReference<ChatCompletionResponseBuilder> contentBlockReference) {
        if (event.type().equals((Object)AnthropicApi.EventType.MESSAGE_START)) {
            contentBlockReference.set(new ChatCompletionResponseBuilder());
            AnthropicApi.MessageStartEvent messageStartEvent = (AnthropicApi.MessageStartEvent)event;
            contentBlockReference.get().withType(event.type().name()).withId(messageStartEvent.message().id()).withRole(messageStartEvent.message().role()).withModel(messageStartEvent.message().model()).withUsage(messageStartEvent.message().usage()).withContent(new ArrayList<AnthropicApi.ContentBlock>());
            return contentBlockReference.get().build();
        } else if (event.type().equals((Object)AnthropicApi.EventType.TOOL_USE_AGGREGATE)) {
            AnthropicApi.ToolUseAggregationEvent eventToolUseBuilder = (AnthropicApi.ToolUseAggregationEvent)event;
            if (CollectionUtils.isEmpty(eventToolUseBuilder.getToolContentBlocks())) return contentBlockReference.get().build();
            List<AnthropicApi.ContentBlock> content = eventToolUseBuilder.getToolContentBlocks().stream().map(tooToUse -> new AnthropicApi.ContentBlock(AnthropicApi.ContentBlock.Type.TOOL_USE, tooToUse.id(), tooToUse.name(), tooToUse.input())).toList();
            contentBlockReference.get().withContent(content);
            return contentBlockReference.get().build();
        } else if (event.type().equals((Object)AnthropicApi.EventType.CONTENT_BLOCK_START)) {
            AnthropicApi.ContentBlockStartEvent contentBlockStartEvent = (AnthropicApi.ContentBlockStartEvent)event;
            AnthropicApi.ContentBlockStartEvent.ContentBlockBody contentBlockBody = contentBlockStartEvent.contentBlock();
            if (contentBlockBody instanceof AnthropicApi.ContentBlockStartEvent.ContentBlockText) {
                AnthropicApi.ContentBlockStartEvent.ContentBlockText textBlock = (AnthropicApi.ContentBlockStartEvent.ContentBlockText)contentBlockBody;
                cb = new AnthropicApi.ContentBlock(AnthropicApi.ContentBlock.Type.TEXT, null, textBlock.text(), contentBlockStartEvent.index());
                contentBlockReference.get().withType(event.type().name()).withContent(List.of(cb));
                return contentBlockReference.get().build();
            } else {
                cb = contentBlockStartEvent.contentBlock();
                if (!(cb instanceof AnthropicApi.ContentBlockStartEvent.ContentBlockThinking)) throw new IllegalArgumentException("Unsupported content block type: " + contentBlockStartEvent.contentBlock().type());
                AnthropicApi.ContentBlockStartEvent.ContentBlockThinking thinkingBlock = (AnthropicApi.ContentBlockStartEvent.ContentBlockThinking)cb;
                cb = new AnthropicApi.ContentBlock(AnthropicApi.ContentBlock.Type.THINKING, null, null, contentBlockStartEvent.index(), null, null, null, null, null, thinkingBlock.signature(), thinkingBlock.thinking(), null, null);
                contentBlockReference.get().withType(event.type().name()).withContent(List.of(cb));
            }
            return contentBlockReference.get().build();
        } else if (event.type().equals((Object)AnthropicApi.EventType.CONTENT_BLOCK_DELTA)) {
            AnthropicApi.ContentBlockDeltaEvent contentBlockDeltaEvent = (AnthropicApi.ContentBlockDeltaEvent)event;
            AnthropicApi.ContentBlockDeltaEvent.ContentBlockDeltaBody contentBlockDeltaBody = contentBlockDeltaEvent.delta();
            if (contentBlockDeltaBody instanceof AnthropicApi.ContentBlockDeltaEvent.ContentBlockDeltaText) {
                AnthropicApi.ContentBlockDeltaEvent.ContentBlockDeltaText txt = (AnthropicApi.ContentBlockDeltaEvent.ContentBlockDeltaText)contentBlockDeltaBody;
                cb = new AnthropicApi.ContentBlock(AnthropicApi.ContentBlock.Type.TEXT_DELTA, null, txt.text(), contentBlockDeltaEvent.index());
                contentBlockReference.get().withType(event.type().name()).withContent(List.of(cb));
                return contentBlockReference.get().build();
            } else {
                cb = contentBlockDeltaEvent.delta();
                if (cb instanceof AnthropicApi.ContentBlockDeltaEvent.ContentBlockDeltaThinking) {
                    AnthropicApi.ContentBlockDeltaEvent.ContentBlockDeltaThinking thinking = (AnthropicApi.ContentBlockDeltaEvent.ContentBlockDeltaThinking)cb;
                    cb = new AnthropicApi.ContentBlock(AnthropicApi.ContentBlock.Type.THINKING_DELTA, null, null, contentBlockDeltaEvent.index(), null, null, null, null, null, null, thinking.thinking(), null, null);
                    contentBlockReference.get().withType(event.type().name()).withContent(List.of(cb));
                    return contentBlockReference.get().build();
                } else {
                    cb = contentBlockDeltaEvent.delta();
                    if (!(cb instanceof AnthropicApi.ContentBlockDeltaEvent.ContentBlockDeltaSignature)) throw new IllegalArgumentException("Unsupported content block delta type: " + contentBlockDeltaEvent.delta().type());
                    AnthropicApi.ContentBlockDeltaEvent.ContentBlockDeltaSignature sig = (AnthropicApi.ContentBlockDeltaEvent.ContentBlockDeltaSignature)cb;
                    cb = new AnthropicApi.ContentBlock(AnthropicApi.ContentBlock.Type.SIGNATURE_DELTA, null, null, contentBlockDeltaEvent.index(), null, null, null, null, null, sig.signature(), null, null, null);
                    contentBlockReference.get().withType(event.type().name()).withContent(List.of(cb));
                }
            }
            return contentBlockReference.get().build();
        } else if (event.type().equals((Object)AnthropicApi.EventType.MESSAGE_DELTA)) {
            contentBlockReference.get().withType(event.type().name());
            AnthropicApi.MessageDeltaEvent messageDeltaEvent = (AnthropicApi.MessageDeltaEvent)event;
            if (StringUtils.hasText((String)messageDeltaEvent.delta().stopReason())) {
                contentBlockReference.get().withStopReason(messageDeltaEvent.delta().stopReason());
            }
            if (StringUtils.hasText((String)messageDeltaEvent.delta().stopSequence())) {
                contentBlockReference.get().withStopSequence(messageDeltaEvent.delta().stopSequence());
            }
            if (messageDeltaEvent.usage() == null) return contentBlockReference.get().build();
            AnthropicApi.Usage totalUsage = new AnthropicApi.Usage(contentBlockReference.get().usage.inputTokens(), messageDeltaEvent.usage().outputTokens(), contentBlockReference.get().usage.cacheCreationInputTokens(), contentBlockReference.get().usage.cacheReadInputTokens());
            contentBlockReference.get().withUsage(totalUsage);
            return contentBlockReference.get().build();
        } else if (event.type().equals((Object)AnthropicApi.EventType.MESSAGE_STOP)) {
            contentBlockReference.get().withType(event.type().name()).withContent(List.of()).withStopReason(null).withStopSequence(null);
            return contentBlockReference.get().build();
        } else {
            if (contentBlockReference.get() == null) {
                contentBlockReference.set(new ChatCompletionResponseBuilder());
            }
            contentBlockReference.get().withType(event.type().name()).withContent(List.of());
            logger.warn("Unhandled event type: {}", (Object)event.type().name());
        }
        return contentBlockReference.get().build();
    }

    public static class ChatCompletionResponseBuilder {
        private String type;
        private String id;
        private AnthropicApi.Role role;
        private List<AnthropicApi.ContentBlock> content;
        private String model;
        private String stopReason;
        private String stopSequence;
        private AnthropicApi.Usage usage;

        public ChatCompletionResponseBuilder withType(String type) {
            this.type = type;
            return this;
        }

        public ChatCompletionResponseBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public ChatCompletionResponseBuilder withRole(AnthropicApi.Role role) {
            this.role = role;
            return this;
        }

        public ChatCompletionResponseBuilder withContent(List<AnthropicApi.ContentBlock> content) {
            this.content = content;
            return this;
        }

        public ChatCompletionResponseBuilder withModel(String model) {
            this.model = model;
            return this;
        }

        public ChatCompletionResponseBuilder withStopReason(String stopReason) {
            this.stopReason = stopReason;
            return this;
        }

        public ChatCompletionResponseBuilder withStopSequence(String stopSequence) {
            this.stopSequence = stopSequence;
            return this;
        }

        public ChatCompletionResponseBuilder withUsage(AnthropicApi.Usage usage) {
            this.usage = usage;
            return this;
        }

        public AnthropicApi.ChatCompletionResponse build() {
            return new AnthropicApi.ChatCompletionResponse(this.id, this.type, this.role, this.content, this.model, this.stopReason, this.stopSequence, this.usage);
        }
    }
}

